(in-package :xit)

(defcontact tape-key (bitmap-dispel)
  ((reactivity :initform '(((:button-release :button-1) "" (call :self release-this-button-and-stop))))))

(defmethod part-event-type ((self tape-key))
  '(:button-press :button-1))

(defmethod before-display ((self tape-key) &optional x y w h)
  :no-clear-area)

(defclass video (view-mixin)
  ((state :initform :stop :accessor state)
   (frame :initform 0 :accessor frame)
   (delay :initform 1 :accessor delay)
   (max-frame :initform 100)
   (min-frame :initform 0)
   (process :initform nil)))

(defmethod initialize-video ((self video))
  (with-slots (process) self
	      (setf process
		(mp::process-run-function "video" #'video-loop self))
	      (mp::process-enable process)))

(defmethod kill-video ((self video))
  (with-slots (process view) self
	      (when process (mp::process-kill process))
	      (destroy view)))
	      
(defmethod frame-text ((vid video))
  (with-slots (frame state) vid
  (if (eq state :stop)
      (format nil "~A" frame)
    (format nil "~A" frame))))

(defmethod incr-frame ((vid video))
  (with-slots (frame max-frame state) vid
	      (cond ((eq frame max-frame)
		     (just-stop-video vid))
		(t (incf frame))))) 

(defmethod decr-frame ((vid video))
  (with-slots (frame min-frame state) vid
	      (cond ((eq frame min-frame)
		     (just-stop-video vid))
		    (t (decf frame)))))

(defmethod video-loop ((self video))
  (with-slots (state delay) self
     (loop
       (mp::process-wait "stopped"
			 #'(lambda ()
			     (with-slots (state) self
			       (not (eql state :stop)))))
       (case state
	 (:fwd (mp:process-sleep .08)
	       (incr-frame self))
	 (:rwd (mp:process-sleep .1)
	       (decr-frame self))
	 (:play (mp:process-sleep delay)
		(incr-frame self)))
       (setf (text (part (view self) :video)) (frame-text self))
       (display-force-output *display*))))

(defmethod stop-video ((self video))
  (with-slots (state view) self
	      (press-button view 'stop)
	      (display-finish-output *display*)
	      (setf state :stop)
	      (release-all-buttons view)
	      (sleep 0.3) 
              (release-button view 'stop)
              (display-finish-output *display*)))

(defmethod just-stop-video ((self video))
  (with-slots (state view) self
	      (setf state :stop)
	      (release-all-buttons view)))

(defmethod play-video ((self video))
  (with-slots (state view) self
	      (release-all-buttons view)
	      (setf state :play)
	      (press-button view `play)))

(defmethod fwd-video ((self video))
  (with-slots (state view) self
	      (release-all-buttons view)
	      (setf state :fwd)
	      (press-button view `fwd)))

(defmethod rwd-video ((self video))
  (with-slots (state view) self
	      (release-all-buttons view)
	      (setf state :rwd)
	      (press-button view `rwd)))

(defmethod release-this-button-and-stop (vb)
  (with-slots (state) (view-of (part-of vb))
    (release-button (part-of (part-of vb)) (contact-name vb)) ;; inefficient
    (setf state :stop)))

(defmethod press-button (vw name)
  (setf (selected? (part (part vw :menu) name)) t))

(defmethod release-button (vw name)
  (setf (selected? (part (part vw :menu) name)) nil))

(defmethod release-all-buttons (vw)
 (release-button vw 'play)
 (release-button vw 'fwd)
 (release-button vw 'rwd))

(defun start-video ()    
 (setq *video* (make-instance 'video))

 (setq *video-window*
  (make-window 'intel-example-window
	       :name :video-examples
	       :title "Video Control"
	       :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Video Control")
	       :x 50
	       :y 400 :width 328
	       :height 190
	       
	       :background 0
	       :border-width 2
	       :view-of *video*
	       :layouter '(distance-layouter :orientation :down
			   :distance 0)))

 (setf (view (view-of *video-window*)) *video-window*)

 (setq *animation-window*
  (make-window 'text-dispel
	       :parent *video-window*
	       :name :video
	       :adjust-size? nil
	       :display-position :center
	       :width 328
	       :height 120
	       :view-of 0
	       :text ""
	       :font '(:size 50 :face :bold)))
				    
 
 (setq *tape-menu*
  (make-window 'bitmap-menu
	       :name :menu
	       :parent *video-window*
	       :border-width 0
	       :inside-border 0
	       :layouter '(distance-layouter :orientation :right
			   :distance 0
			   )
	       :reactivity
	       '((:part-event (call :eval
				    (funcall *part-value* (view-of *self*)))))
	       :part-mouse-feedback :none
	       :part-class 'tape-key
	       :parts '((:name stop
			       :cursor "hand2-cursor"
			 :view-of stop-video
			 :bitmap "tape-stop"
			 :action-docu
			 "Stop animation")
			(:name rwd
			       :cursor "hand2-cursor"
			 :view-of rwd-video
			 :bitmap "tape-rwd"
			 :action-docu "Rewind animation")
			(:name play
			       :cursor "hand2-cursor"
			 :reactivity-entries (((:button-release :button-1) :none))
			 :view-of play-video
			 :bitmap "tape-play"
			 :action-docu "Play animation")
			(:name fwd
			       :cursor "hand2-cursor"
			 :view-of fwd-video
			 :bitmap "tape-fwd"
			 :action-docu "Fast forward")
			)))

 (initialize-video *video*)
 )

(define-resources
  (* tape-key background) "lightsteelblue"
  (* tape-key foreground) "black")

(start-video)
