;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Icon Examples
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/icon-examples.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 01/13/93 14:21:51
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

(proclaim '(special demo-window icon-menu icon-window
		    icon-1 icon-2 button-1 button-2 button-3 button-4 button-5
		    button-6 button-7 button-8 button-9 *display*))


(setq icon-window
      (make-window 'intel-example-window
		   :name :icon-examples
		   :x 300 :y 30 :width 500 :height 350
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Icons")
		   :title "Icons and Buttons"))

(setq icon-1 (make-window 'icon
			  :parent icon-window
			  :x 20 :y 40
			  :border-width 1
			  :inside-border 5
			  :mouse-documentation
			  "Icon with a bitmap part"
			  :text-part :none
			  :bitmap-part '(:bitmap "terminal")))

(setq icon-2 (make-window 'text-icon
			  :parent icon-window
			  :name :icon-with-text
			  :x 150 :y 40
			  :border-width 2
			  :inside-border 5
			  :mouse-documentation
			  "Icon with a bitmap part and a text part"
			  :bitmap-part '(:bitmap "identifier")
			  :text-part   '(:x 20 :y 10
					 :inside-border 3
					 ;:layouted? nil
					 :text "some text"
					 :font (:size 10)
					 :mouse-feedback :border
					 :edit-mode :point)))

(setq button-1 (make-window 'soft-button
			    :parent icon-window
			    :x 20 :y 150
			    :cursor "leftbutton"
			    :view-of demo-window
			    :action '(call :view-of totop-window)
			    :action-docu "Put Test Window on top"
			    :bitmap-part '(:bitmap "bar")
			    :text-part   '(:font (:face :bold)
					   :text "Top")))

(setq button-2 (make-window 'soft-button
			    :parent icon-window
			    :x 120 :y 150
			    :cursor "leftbutton"
			    :view-of demo-window
			    :action '(call :view-of tobottom-window)
			    :action-docu "Put Test Window to bottom"
			    :bitmap-part '(:bitmap "bar")
			    :text-part   '(:font (:face :bold)
					   :text "Bottom")))

(setq button-3 (make-window 'soft-button
			    :parent icon-window
			    :name :border-width-button
			    :x 20 :y 220
			    :inside-border 5
			    :view-of demo-window
			    :mouse-feedback :border
			    :action '(call :view-of
				      change-geometry :border-width 1)
			    :action-docu "Set border-width of Test Window to 1"
			    :bitmap-part :none
			    :text-part   '(:text "border width = 1"
					   :font (:size 14))))

(setq button-4 (make-window 'soft-button
			    :parent icon-window
			    :name :border-width-button
			    :x 190 :y 220
			    :inside-border 5
			    :view-of demo-window
			    :mouse-feedback :border
			    :action '(call :view-of
				      change-geometry :border-width 2)
			    :action-docu "Set border-width of Test Window to 2"
			    :bitmap-part :none
			    :text-part   '(:text "border width = 2"
					   :font (:size 14))))

(setq button-5 (make-window 'soft-button
			    :parent icon-window
			    :name :border-width-button
			    :x 360 :y 220
			    :inside-border 5
			    :view-of demo-window
			    :mouse-feedback :border
			    :action '(call :view-of
				      change-geometry :border-width 3)
			    :action-docu "Set border-width of Test Window to 3"
			    :bitmap-part :none
			    :text-part   '(:text "border width = 3"
					   :font (:size 14))))

(setq button-6 (make-window 'soft-button :parent icon-window
			    :x 20 :y 290
			    :view-of demo-window
			    :action '(call :view-of flash-window 0.6)
			    :action-docu "Cancel"
			    :text-part '(:text "Cancel"
					 :font (:family :lucida
						:face :normal
						:size 12))))


(setq button-7 (make-window 'soft-button :parent icon-window
			    :x 100 :y 290
			    :view-of demo-window
			    :action '(call :view-of flash-window 0.3)
			    :action-docu "OK"
			    :text-part '(:text "OK"
					 :font (:family :lucida
						:face :bold
						:size 12))))

(setq button-8 (make-window 'soft-button :parent icon-window
			    :x 180 :y 290
			    :view-of demo-window
			    :action '(call :view-of flash-window 0.9)
			    :action-docu "Accept Changes"
			    :bitmap-part '(:bitmap "button-xl")
			    :text-part '(:text "Accept Changes"
					 :font (:family :lucida
						:face :bold
						:size 12))))

(setq button-9 (make-window 'soft-button :parent icon-window
			    :x 350 :y 290
			    :view-of demo-window
			    :action '(call :view-of flash-window 1.0)
			    :action-docu "Accept"
			    :bitmap-part '(:bitmap "accept-button-m")
			    :text-part '(:text "Accept"
					 :font (:family :lucida
						:face :normal
						:size 12))))



(update-state *display*)
(process-all-events *display*)

(shrink icon-window)

(update-state *display*)
(process-all-events *display*)
