;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Example Definitions
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/definitions.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 04/08/93 11:40:32
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

(defcontact intel-example-icon (text-dispel)
  ((mouse-feedback :initform :border)))

(defcontact intel-example-icon-menu (window-icon-mixin popup-part-connection
				     title-window uniform-part-intel)
  ((part-class :initform 'text-dispel)
   (layouter :initform 'distance-layouter)
   (popup-part :initform :default)
   (reactivity :initform '((:select "Put window to top")
			   (:move)
			   (:menu)
			   (:double-left-button "Shrink to icon"
			    (call :self shrink)))))
  (:resources
   (inside-border :initform 2)))

(defcontact intel-example-window (focus-mixin
				  minimax-mixin window-icon-mixin
				  popup-part-connection
				  title-window intel)
  ((adjust-size? :initform nil)
   (popup-part :initform :default)
   (reactivity :initform '((:select "Put window to top")
			   (:move)
			   (:menu)
			   (:double-left-button "Shrink to icon"
			    (call :self shrink)))))
  (:resources
   (inside-border :initform 2)))

(defcontact layouter-example-window (title-window intel)
  ((inside-border :initform 10)))

(defcontact menu-example-dispel (dispel)
  ((adjust-size? :initform nil)
   (mouse-feedback-border-width :initform 2
				:allocation :class)))

;(defcontact menu-example-dispel (dispel) ())

(defcontact shadow-popup-property-sheet (shadow-borders-mixin
					 popup-window property-sheet)
  ())

(defmethod popup-for :after ((self shadow-popup-property-sheet) obj)
  (read-from-application self))


; no longer needed in latest clos version
;#+(and lucid clos (not pcl))
;(pmds::load-system :lucid-clos-patch)
