;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: chungl $
;;; $Source: /n/mickey/cluster/picasso/new/widgets/etc/RCS/start-func.cl,v $
;;; $Revision: 1.6 $
;;; $Date: 1992/04/06 01:05:26 $
;;;

(in-package "PT")

(defun start-picasso ()
  (unless (member "-noinit" (command-line-args) :test #'string=)
	  (attach (make-display))
	  (refresh-environment)
    ;; will look for a .lisp in lucid
	  (or (load "~/.picasso-init" :if-does-not-exist nil)
	      (load "~/.clinit" :if-does-not-exist nil))
	  (in-package "PT")
	  (set-prompt #+allegro "<new-picasso> " #+lucid "<lucid-picasso> ")
	  (do-whatever-initialization)))

(defun do-whatever-initialization ()
  (load-event-maps)
  (add-var 'po (root-window) (root-window))
  (setf *user* (get-environment "USER"))
  (setf *picasso-home* (get-environment "PICASSOHOME"))
  (if (not *picasso-home*) (setf *picasso-home* *picasso-home-default*))
    ;; multiprocessing is allegro, multitasking is lucid
  ;; lucid scheduler always active (sort-of)
  #+multiprocessing 
  (unless mp::*all-processes* (mp:start-scheduler))
  (when (member (name *current-display*) *video-machine-names* :test #'string=)
	(with-open-file (f "/etc/hostname.le0" :direction :input
			   :if-does-not-exist nil)
			(if (and f (member (read f) *video-machines*))
			    (setf
			     video:*real-player-p* t
			     *pip-pos* (#+allegro excl:run-shell-command
					#+lucid run-program
					(resolve-pathname (picasso-path "bin/pip-pos"))
					:wait nil :input :stream)))))
  (format t "Picasso Initialized")
  #+allegro 
  (let ((oldh top-level:*history*)) 
       (setq top-level:*history* 0)
       (setq top-level:*history* oldh)))
