;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: chungl $
;;; $Source: /pic2/picasso/src/toolkit/resource/RCS/screen.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 1992/04/06 01:07:48 $
;;;

(in-package "PT")

;;;
;;; screen class
;;;

;; screens are created when the display attach method calls
;; the function #'init-display-screens.
;; the attach/detach functionality is all wrong here, but works if
;; screens are only created when a display is attached.

(defclass screen (pmc)
  ((number
    :initarg :number 
    :initform 0
    :type integer
    :reader number)
   (res
    :initarg :res 
    :initform nil
    :type vector
    :reader res)
   (display
    :initarg :display 
    :initform nil
    :type display
    :reader display)
   (root
    :initarg :root 
    :initform nil
    :type root-window
    :reader root)
   (colormap-table
    :initform nil
    :type hash-table
    :reader colormap-table)))

(defun make-screen (&rest keys)
  (apply #'make-instance 'screen :allow-other-keys t keys))

(defun get-colormap (&optional name spec)
  (cond ((screen-p spec) 
	 (if name 
	     (gethash name (colormap-table spec))
	     (current-colormap spec)))
	((display-p spec)
	 (if name 
	     (gethash name (colormap-table (current-screen 
					    (default-colormap spec))))
	     (current-colormap spec)))
	((window-p spec)
	 (if name 
	     (gethash name (colormap-table (screen spec)))
	     (current-colormap spec)))
	(spec
	 (error "get-color: illegal second argument \'~s\'" spec))
	(t (gethash name (colormap-table (current-screen))))))

;; this function is not called anymore.  new-instance display now
;; does the necessary inits.
(defun init-display-screens (display &aux screen table)
  "Return the first screen"

  ;; create screen-table
  (setf (slot-value display 'screen-table)
	(setq table (make-array (list (xlib:display-nscreens (res display))))))

  ;; create screens
  (do* ((screens (xlib:display-roots (res display)) (cdr screens))
	(res (car screens))
	(num 0 (1+ num)))
       ((null screens))
       ;; create screen
       (setq screen (make-screen :number num :res res :display display))
       (setf (aref table num) screen))
  
  ;; return first screen
  (aref table 0))

(defun init-screen-colors (&optional (self (colormap (root-window))))
  ;; make white/black color
  (make-color :name "white" :colormap self :attach-p t)
  (make-color :name "black" :colormap self :attach-p t)
  (when (color-display-p self)
	(make-color :red .50 :green .50 :blue .50 :colormap self
		    :name "gray25" :attach-p t)
	(make-color :red .60 :green .60 :blue .60 :colormap self
		    :name "gray50" :attach-p t)
	(make-color :red .80 :green .80 :blue .80 :colormap self
		    :name "gray75" :attach-p t)))

(defmethod new-instance ((self screen)
			 &rest args)
  (declare (ignore args))
  (call-next-method)
  (setf (slot-value self 'root)
	(make-root-window :screen self :display (display self)))
  self)

;; only one screen is supported.
(defmethod do-attach ((self screen))
  (let ((display (display self)))
       (if (attached-p display)
	   (let* ((screens (xlib:display-roots (res display)))
		  (screen (car screens))
		  (root (root self))
		  (ht (colormap-table self))
		  )
		 (setf (slot-value self 'res) screen)
		 ;; force attach.  parent of root-window is nil,
		 ;; so call do-attach directly.
		 (do-attach root)
		 
		 ;; attach colormaps
		 (when (hash-table-p ht)
		       (maphash #'(lambda (k v) (attach v)) ht))

		 (init-screen-colors (colormap root))
		 )
	   ;; else, detached display
	   (warn "do-attach screen: display not attached")
	   )
       )
  self)

(defmethod do-detach ((self screen))
  ;; detach colormaps
  ;; (when (colormap-table self) 
  ;; 	(maphash #'(lambda (k v) (detach v))
  ;; 		 (colormap-table self)))
  (mapcar #'detach (instances (get-colormap)))

  ;; detach children of root window.
  (dolist (ch (children (root self)))
	  (detach ch))
  (detach (root self))
  (setf (slot-value self 'res) nil))
