(setf string "test-pathname.abc" symbol 'test-pathname.abc)
test-pathname.abc

;;pathname -mgl. Argumenttypen: pathname,string,symbol,stream
;;         -resultat: pathname

(SETF PATHSTRING (PATHNAME STRING))   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" 

TYPE "ABC" SYSTEM::VERSION NIL)

(SETF PATHSYMBOL (PATHNAME symbol))   
#S(PATHNAME SYSTEM::HOST 
NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME 

"TEST-PATHNAME" TYPE "ABC" SYSTEM::VERSION NIL)

(SETF PATHPATH (PATHNAME PATHSYMBOL))   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" 

TYPE "ABC" SYSTEM::VERSION NIL)

(SETF STREAM (OPEN STRING :DIRECTION :OUTPUT)
      a nil) 
nil

;(SETF PATHSTREAM (PATHNAME STREAM))   
;"test-pathname.lsp"

(MAPCAR (FUNCTION PATHNAMEP) 
	(QUOTE (PATHSTRING PATHSYMBOL PATHPATH ;PATHSTREAM
						)))   
(T T T ;T
	)


;; funktion truename liefert filename fuer pathname oder stream
;; 	             einen Pfadnamen
;
;(MAPCAR (FUNCTION TRUENAME) (QUOTE (PATHSTRING PATHSYMBOL PATHPATH 
STREAM 
;								;PATHSTREAM
;								   )))   
;  ERROR



(PARSE-NAMESTRING STRING)   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" 

TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING SYMBOL)   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" 

TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "bab:test-pathname.abc")   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "$1$DUA70" DIRECTORY "43.BABYLON.REL2" SYSTEM::NAME 

"TEST-PATHNAME" TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "bab:test-pathname.abc;3")   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "$1$DUA70" DIRECTORY "43.BABYLON.REL2" SYSTEM::NAME 

"TEST-PATHNAME" TYPE "ABC" SYSTEM::VERSION 3)

(PARSE-NAMESTRING PATHSTRING)   
#S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE 
"DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" TYPE 
"ABC" 
SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "test-pathname.abc" NIL)   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST-PATHNAME" 

TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "sirius::disk00$abt43:[heicking]test-pathname.abc") 
  
#S(PATHNAME 
SYSTEM::HOST "SIRIUS" SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "HEICKING" 

SYSTEM::NAME "TEST-PATHNAME" TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "sirius::disk00$abt43:[heicking]test-pathname.abc" 
"sirius")   
#S(PATHNAME 
SYSTEM::HOST "SIRIUS" SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "HEICKING" 

SYSTEM::NAME "TEST-PATHNAME" TYPE "ABC" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "sirius::disk00$abt43:[heicking]test-pathname.abc" 
"orion")
ERROR

(PARSE-NAMESTRING "abc.123" NIL NIL :START 0 :END 5)   #S(PATHNAME 
SYSTEM::HOST 
NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME 
"ABC" TYPE 
"1" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "abc.123" NIL NIL :START 2 :END 5)   #S(PATHNAME 
SYSTEM::HOST 
NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME 
"C" 
TYPE "1" 
SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "babylon" NIL NIL :START 0 :END 3)   #S(PATHNAME 
SYSTEM::HOST 
NIL SYSTEM::DEVICE "$1$DUA70" DIRECTORY "43.BABYLON.REL2" SYSTEM::NAME 
NIL TYPE 
NIL SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "babylon" NIL NIL :START 0 :END 7)   #S(PATHNAME 
SYSTEM::HOST 
NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME 
"BABYLON" 
TYPE NIL SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "babylon" NIL *DEFAULT-PATHNAME-DEFAULTS* :START 
0 :END 7)
#S(PATHNAME 
SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" 
SYSTEM::NAME 
"BABYLON" TYPE NIL SYSTEM::VERSION NIL)


*DEFAULT-PATHNAME-DEFAULTS*   #S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE 
NIL 
DIRECTORY NIL SYSTEM::NAME NIL TYPE "lsp" SYSTEM::VERSION :NEWEST)

(PARSE-NAMESTRING "babylon" NIL *DEFAULT-PATHNAME-DEFAULTS* :START 
0 :END 3)  
#S(PATHNAME 
SYSTEM::HOST NIL SYSTEM::DEVICE "$1$DUA70" DIRECTORY "43.BABYLON.REL2" 

SYSTEM::NAME NIL TYPE NIL SYSTEM::VERSION NIL)

;(PARSE-NAMESTRING "babylon.c.c" NIL NIL :JUNK-ALLOWED T)   #S(PATHNAME 

;SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" 
SYSTEM::NAME 
;"BABYLON" TYPE "C" SYSTEM::VERSION NIL)

;(PARSE-NAMESTRING "babylon;c.c" NIL NIL :JUNK-ALLOWED T)   #S(PATHNAME 

;SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" 
SYSTEM::NAME 
;"BABYLON" TYPE NIL SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "babylon;c.c" NIL NIL :JUNK-ALLOWED NIL)   ERROR

(PARSE-NAMESTRING "babylon.c.c" NIL NIL :JUNK-ALLOWED NIL)   ERROR

(PARSE-NAMESTRING "babylon.c;c" NIL NIL :JUNK-ALLOWED NIL)   ERROR

(PARSE-NAMESTRING "babylon.c;" NIL NIL :JUNK-ALLOWED NIL)   
#S(PATHNAME 
SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" 
SYSTEM::NAME 
"BABYLON" TYPE "C" SYSTEM::VERSION NIL)

(PARSE-NAMESTRING "babylon.c;5" NIL NIL :JUNK-ALLOWED NIL)   
#S(PATHNAME 
SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" 
SYSTEM::NAME 
"BABYLON" TYPE "C" SYSTEM::VERSION 5)

;(MERGE-PATHNAME "test$$" SYMBOL 10)   ERROR
;;
;(MERGE-PATHNAME "test$$" SYMBOL)   ERROR
;
;(MERGE-PATHNAME "test$$" PATH)   ERROR
;
;(MERGE-PATHNAME "test$$")   ERROR

(MERGE-PATHNAMES "test$$")   
#S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE 
"DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST$$" TYPE "lsp" 

SYSTEM::VERSION :NEWEST)

(MERGE-PATHNAMES "test$$" SYMBOL)   
#S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE 
"DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST$$" TYPE "ABC" 

SYSTEM::VERSION :NEWEST)

(MERGE-PATHNAMES "test$$" SYMBOL 2)   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST$$" 
TYPE 
"ABC" SYSTEM::VERSION 2)

(MERGE-PATHNAMES "test$$" (PATHNAME SYMBOL) 2)   
#S(PATHNAME SYSTEM::HOST NIL 
SYSTEM::DEVICE "DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST$$" 
TYPE 
"ABC" SYSTEM::VERSION 2)

(MERGE-PATHNAMES "test$$" STREAM 2)   
#S(PATHNAME SYSTEM::HOST 16 SYSTEM::DEVICE 
"DISK00$ABT43" DIRECTORY "XCL.MAIN" SYSTEM::NAME "TEST$$" TYPE :ESCAPE 

SYSTEM::VERSION 2)


;(MERGE-PATHNAME STRING SYMBOL)   ERROR

(MAKE-PATHNAME :NAME "a" :HOST (QUOTE ORION))   
#S(PATHNAME SYSTEM::HOST ORION 
SYSTEM::DEVICE NIL DIRECTORY NIL SYSTEM::NAME "a" TYPE NIL SYSTEM::VERSION 

:NEWEST)

(DEFMACRO TEST (&REST BODY) (\` (APPLY (FUNCTION MAKE-PATHNAME) (\,@ 
BODY)))) 
TEST

(setf a '(:host "sirius" :name "a"))
(:host "sirius" :name "a")


(TEST A)   
#S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE NIL DIRECTORY NIL 

SYSTEM::NAME "a" TYPE NIL SYSTEM::VERSION :NEWEST)

(SETF A (LIST* :DEVICE "disk00$abt43" A))   
(:DEVICE "disk00$abt43" :HOST "sirius" :NAME "a")

(TEST A)   
#S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE "disk00$abt43" 
DIRECTORY NIL SYSTEM::NAME "a" TYPE NIL SYSTEM::VERSION :NEWEST)

(SETF A (LIST* :DIRECTORY "[heicking.comlisp]" A))   
(:DIRECTORY 
"[heicking.comlisp]" :DEVICE "disk00$abt43" :HOST "sirius" :NAME "a")

(TEST A)   
#S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE "disk00$abt43" 
DIRECTORY "[heicking.comlisp]" SYSTEM::NAME "a" TYPE NIL SYSTEM::VERSION 
:NEWEST)

(SETF A (LIST* :TYPE "raf" A))   
(:TYPE "raf" :DIRECTORY "[heicking.comlisp]" 
:DEVICE "disk00$abt43" :HOST "sirius" :NAME "a")

(TEST A)   
#S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE "disk00$abt43" 
DIRECTORY "[heicking.comlisp]" SYSTEM::NAME "a" TYPE "raf" SYSTEM::VERSION 

:NEWEST)

(SETF A (LIST* :VERSION 3 A))   (:VERSION 3 :TYPE "raf" :DIRECTORY 

"[heicking.comlisp]" :DEVICE "disk00$abt43" :HOST "sirius" :NAME "a")

(TEST A)   
#S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE "disk00$abt43" 
DIRECTORY "[heicking.comlisp]" SYSTEM::NAME "a" TYPE "raf" SYSTEM::VERSION 
3)

(MAPCAR (FUNCTION PATHNAMEP) (QUOTE (PATHSYMBOL PATHPATH PATHSTRING))) 
  
(NIL NIL NIL)

(SETF PATH (TEST A))   #S(PATHNAME SYSTEM::HOST "sirius" SYSTEM::DEVICE 

"disk00$abt43" DIRECTORY "[heicking.comlisp]" SYSTEM::NAME "a" TYPE 
"raf" 
SYSTEM::VERSION 3)

(MAPCAR (FUNCTION PATHNAME-HOST) (QUOTE (SYMBOL STRING STREAM PATH))) 
  
(NIL NIL NIL NIL)

(MAPCAR (FUNCTION PATHNAME-DEVICE) (QUOTE (SYMBOL STRING STREAM PATH))) 
  
("DISK00$ABT43" "DISK00$ABT43" "DISK00$ABT43" "DISK00$ABT43")

(MAPCAR (FUNCTION PATHNAME-DIRECTORY) (QUOTE (SYMBOL STRING STREAM 
PATH)))   
("XCL.MAIN" "XCL.MAIN" "XCL.MAIN" "XCL.MAIN")

;(MAPCAR (FUNCTION PATHNAME-NAME) (QUOTE (SYMBOL STRING STREAM PATH))) 
  
;("SYMBOL" "STRING" "STREAM" "PATH")
;
;(MAPCAR (FUNCTION PATHNAME-TYPE) (QUOTE (SYMBOL STRING STREAM PATH))) 
  
;(NIL NIL NIL NIL)
;
;(MAPCAR (FUNCTION PATHNAME-VERSION) (QUOTE (SYMBOL STRING STREAM PATH))) 
  (NIL 
;NIL NIL NIL)
;
;
;(MAPCAR (FUNCTION NAMESTRING) (QUOTE (STRING SYMBOL PATH STREAM))) 
  ERROR
;
;(MAPCAR (FUNCTION FILE-NAMESTRING) (QUOTE (STRING SYMBOL PATH STREAM))) 
  (
;"STRING" "SYMBOL" "PATH" "STREAM")
;
(USER-HOMEDIR-PATHNAME)   
#S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE 
"DISK00$ABT43" DIRECTORY "HEICKING" SYSTEM::NAME NIL TYPE NIL SYSTEM::VERSION 

NIL)

(PATHNAME "*.*")   #S(PATHNAME SYSTEM::HOST NIL SYSTEM::DEVICE "DISK00$ABT43" 

DIRECTORY "HEICKING" SYSTEM::NAME "*" TYPE :WILD SYSTEM::VERSION NIL)

(progn (setf file (open "nicht-vorhandenes-file.non" 
                        :direction :input 
                        :element-type 'string-char
                        :if-does-not-exist :create)) t}
t

(probe-file "nicht-vorhandenes-file.non")
"disk00$abt43:[heicking.comlisp]nicht-vorhandenes-file.non" 

(progn (close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :error)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :new-version)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :rename)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :rename-and-delete)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :overwrite)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :append)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists :supersede)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-exists nil)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.new" 
                        :direction :io 
                        :element-type 'string-char
                        :if-does-not-exist :error)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.new" 
                        :direction :io 
                        :element-type 'string-char
                        :if-does-not-exist :create)) 
nil

(progn(close file) t}
t

(setf file (open "nicht-vorhandenes-file.non" 
                        :direction :io 
                        :element-type 'string-char
                        :if-does-not-exist nil)) 
nil

(progn(close file) t}
t


(multiple-value-setq (new-name pathname truename)
                     (rename-file "nicht-vorhandenes-file.non" "file.da"}
"file.da"

new-name
"file.da"

pathname
nil

truename
nil
