;; -*- Mode:LISP; Package:(BOXER GLOBAL 1000); Fonts:cptfont,cptfontb; Base:10. -*-
#|
            Copyright 1985 Massachusetts Institute of Technology

 Permission to use, copy, modify, distribute, and sell this software
 and its documentation for any purpose is hereby granted without fee,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of M.I.T. not be used in
 advertising or publicity pertaining to distribution of the software
 without specific, written prior permission.  M.I.T. makes no
 representations about the suitability of this software for any
 purpose.  It is provided "as is" without express or implied warranty.


                                          +-Data--+
                 This file is part of the | BOXER | system
                                          +-------+


  This File contains the Definition of Sprite boxes

                                                                  by Jeremy

|#


(defmethod (sprite-box :type) ()
  ':sprite-box)

(defun make-initialized-sprite-box (&rest init-plist)
  (instantiate-flavor 'sprite-box (locf init-plist) t))

(defun make-sprite-box (&OPTIONAL EXISTING-TURTLE)
  (let* ((xpos (make-box '((0.))))
	 (ypos (make-box '((0.))))
	 (heading (make-box '((0.))))
	 (rows (list (make-row (list xpos ypos) NIL)
		     (make-row (ncons heading) NIL)))
	 (turtle (OR EXISTING-TURTLE (make-turtle)))
	 (box (make-initialized-sprite-box ':type ':sprite-box
					   ':associated-turtle turtle)))
    (tell turtle :set-sprite-box box)
    (tell xpos :set-name (make-name-row '(xpos)))
    (tell ypos :set-name (make-name-row '(ypos)))
    (tell heading :set-name (make-name-row '(heading)))
    (tell box :set-first-inferior-row nil)
    (tell box :add-static-variable-pair 'bu:xpos xpos)
    (tell box :add-static-variable-pair 'bu:ypos ypos)
    (tell box :add-static-variable-pair 'bu:heading heading)
    (dolist (row rows)
      (tell box :append-row row))
    box))


(defmethod (sprite-box :before :init) (init-plist)
  (unless (get init-plist ':type)
    (putprop init-plist ':sprite-box ':type)))

;(defmethod (sprite-box :copy) (&optional (with-name? nil))
;  (let* ((turtle (make-turtle))
;	 (new-box (make-initialized-sprite-box ':associated-turtle turtle)))
;    (tell turtle :Set-sprite-box new-box)
;    new-box))

(DEFMETHOD (sprite-box :COPY) ()
  (LET ((NEW-BOX (MAKE-initialized-sprite-BOX
		   ':associated-turtle (tell associated-turtle :copy)))
	(BOX-STREAM (MAKE-BOX-STREAM SELF)))
    (TELL NEW-BOX :SET-CONTENTS-FROM-STREAM BOX-STREAM T)
    (WHEN (NOT-NULL PORTS)
      (PUSH (CONS SELF NEW-BOX) .LINK-TARGET-ALIST.))
    (tell (tell new-box :associated-turtle) :set-sprite-box new-box)
    NEW-BOX))

(defmethod (sprite-box :add-graphics-object) (turtle)
  (tell associated-turtle :add-subturtle turtle))

(defmethod (sprite-box :remove-graphics-object) (turtle)
  (tell associated-turtle :remove-subturtle turtle))

(defmethod (sprite-box :toggle-type) () (beep))

;;; The next two messages hookup sprite boxes and graphics boxes.

(defmethod (sprite-box :before :delete-self-action) ()
  (let ((surrounding-box (tell self :superior-box)))
    (when (or (graphics-data-box? surrounding-box)
	      (graphics-box? surrounding-box)
	      (sprite-box? surrounding-box))	      
       (tell surrounding-box :remove-graphics-object associated-turtle))))

(defmethod (sprite-box :after :insert-self-action) ()
  (let ((surrounding-box (tell self :superior-box)))
    (when (or (graphics-data-box? surrounding-box)
	      (graphics-box? surrounding-box)
	      (sprite-box? surrounding-box))
      (tell surrounding-box :add-graphics-object associated-turtle))))


(defun single-number-p (elt-list)
  (and (= (length elt-list) 1)
       (numberp (car elt-list))))

(defun double-number-p (elt-list)
  (and (= (length elt-list) 2)
       (numberp (car elt-list))
       (numberp (cadr elt-list))))

(defmethod (box :clear-and-insert-stuff) (&rest stuff)
  (tell self :set-first-inferior-row nil)
  (tell self :append-row (make-row stuff))
  (tell self :modified))


;;; This is the magic message which should be called every time 
;;; a sprite box instance variable might be changed by boxer.

(defmethod (box :exit-from-sprite-instance-var) ()
  (let ((superior-box (tell self :superior-box)))
    (when (sprite-box? superior-box)
      (let ((elts (tell self :elements))
	    (MY-NAME (TELL SELF :NAME))
	    (turtle (tell superior-box :associated-turtle)))
       (when (not-null (tell turtle :assoc-graphics-box))
	    (cond
	      ((STRING-EQUAL "who-line" MY-NAME)
	       (LET ((ST (SEND SELF :TEXT-STRING)))
		 (IF (EQ "" ST)
		     (SEND SUPERIOR-BOX :REMPROP :WHO-LINE)
		     (SEND SUPERIOR-BOX :PUTPROP ST :WHO-LINE))))
	      ((string-equal "xpos" my-name)
	       (if (single-number-p elts)
		   (tell turtle
			 :move-to (car elts) (tell turtle :y-position))
		   (tell self :clear-and-insert-stuff (tell turtle :x-position))))
	      ((string-equal "ypos" my-name)
	       (if (single-number-p elts)
		   (tell turtle
			 :move-to (tell turtle :x-position) (car elts))
		   (tell self :clear-and-insert-stuff (tell turtle :y-position))))
	      ((string-equal "heading" my-name)
	       (if (single-number-p elts)		 
		   (tell turtle :set-heading (car elts))
		   (tell self :clear-and-insert-stuff (tell turtle :heading))))
	      ((string-equal "size" my-name)
	       (if (single-number-p elts)
		   (tell turtle :set-size (car elts))
		   (tell self :clear-and-insert-stuff (tell turtle :size))))
	      ((string-equal "shown" my-name)
	       (if (and (= (length elts) 1)
			(memq (car elts) '(bu:none bu:all
					  bu:subsprites bu:no-subsprites
					  bu:true bu:false)))
		   (tell turtle :set-shown-p (car elts))
		   (tell self :clear-and-insert-stuff (tell turtle :shown-p-symbol))))
	      ((string-equal "origin" my-name)
	       (if (double-number-p elts)
	       (tell turtle :set-home (first elts) (second elts)))
	       (tell self :clear-and-insert-stuff
		     (tell turtle :home-x)
		     (tell turtle :home-y)))
	      ((string-equal "shape" my-name)
	       (tell turtle :set-shape-from-box self));;; should try to catch errors here!
	      ((string-equal "pen" my-name)
	       (if (and (= (length elts) 1)
			(memq (car elts) '(bu:up bu:xor bu:erase bu:down)))
		   (tell turtle :set-pen (car elts))
		   (tell self :clear-and-insert-stuff (tell turtle :pen))))))))))

(defmethod (port-box :after :exit) (&rest ignore)
  (tell ports :exit-from-sprite-instance-var))

;;; This hooks up sprite state variables

(defmethod (sprite-box :after :add-static-variable-pair) (var value)
  (selectq var
    ((bu:shape)
     (tell associated-turtle :add-shape-box value))
    ((bu:size)
     (tell associated-turtle :add-size-box value))
    ((bu:xpos)
     (tell associated-turtle :add-xpos-box value))
    ((bu:ypos)
     (tell associated-turtle :add-ypos-box value))
    ((bu:heading)
     (tell associated-turtle :add-heading-box value))
    ((bu:pen)
     (tell associated-turtle :add-pen-box value))
    ((bu:origin)
     (tell associated-turtle :Add-home-box value))
    ((bu:shown)
     (tell associated-turtle :add-shown-p-box value)))
  (when (box? value) (tell value :exit-from-sprite-instance-var)))

(defmethod (sprite-box :after :remove-all-static-bindings) (value)
  (multiple-value-bind (value-name ignore) (tell value :name)
    (setq value-name (string-downcase value-name))
    (cond 
      ((equal "size" value-name)
       (tell associated-turtle :remove-size-box))
      ((equal "xpos" value-name)
       (tell associated-turtle :remove-xpos-box))
      ((equal "ypos" value-name)
       (tell associated-turtle :remove-ypos-box))
      ((equal "heading" value-name)
       (tell associated-turtle :remove-heading-box))
      ((equal "origin" value-name)
       (tell associated-turtle :remove-home-box))
      ((equal "pen" value-name)
       (tell associated-turtle :remove-pen-box))
      ((equal "shape" value-name)
       (tell associated-turtle :remove-shape-box))
      ((equal "shown" value-name)
       (tell associated-turtle :remove-shown-p-box)))))

(DEFMETHOD (SPRITE-BOX :AFTER :REMOVE-STATIC-VARIABLE) (VARIABLE)
  (WHEN (EQ VARIABLE 'BU:WHO-LINE)
    (SEND SELF :REMPROP :WHO-LINE)))

(defboxer-function update ()
  (let ((boxes (with-collection
		 (dolist (r (tell (tell-named-sprite :sprite-box) :rows))
		   (do-row-chas ((c r))
		     (when (box? c) (collect c)))))))
    (dolist (b boxes)
      (when (equal (tell b :name) "SHAPE")
	(tell b :exit-from-sprite-instance-var)))))
