(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defvar *g1* nil)
(defvar *g2* nil)
(defvar *g3* nil)
(defvar *g4* nil)
(defvar *g5* nil)

(defun next-to (x y)
  (= 1 (abs (- x y))))

(defun nequal (x y)
  (not (equal x y)))

(defun immediately-to-the-right-of (x y)
  (= x (- y 1)))

(defun immediately-to-the-left-of (x y)
  (= x (+ y 1)))

(defun make-dechters-zebra ()
  (let ((houses '(red blue yellow green ivory))
	(cigarettes '(old-gold parliament kools lucky chesterfield))
	(nationalities '(norwegian ukranian englishman spaniard japanese))
	(pets '(zebra dog horse fox snails))
	(drinks '(coffee tea water milk orange-juice)))
    (map nil #'delete-object *vars*)
    (map nil #'delete-object *constraints*)
    (setq *g1* (map 'list #'(lambda (name) (make-var name '(1 2 3 4 5))) houses)
	  *g2* (map 'list #'(lambda (name) (make-var name '(1 2 3 4 5))) cigarettes)
	  *g3* (map 'list #'(lambda (name) (make-var name '(1 2 3 4 5))) nationalities)
	  *g4* (map 'list #'(lambda (name) (make-var name '(1 2 3 4 5))) pets)
	  *g5* (map 'list #'(lambda (name) (make-var name '(1 2 3 4 5))) drinks))
    (loop for i in houses do
	  (loop for j in houses do
		(cond ((and (nequal i j)
			    (not (and (equal i 'green) (equal j 'ivory)))
			    (not (and (equal j 'green) (equal i 'ivory))))
		       (make-constraint i '/= j)))))
    (loop for i in cigarettes do
	  (loop for j in cigarettes do
		(cond ((nequal i j) (make-constraint i '/= j)))))
    (loop for i in nationalities do
	  (loop for j in nationalities do
		(cond ((nequal i j) (make-constraint i '/= j)))))
    (loop for i in pets do
	  (loop for j in pets do
		(cond ((nequal i j) (make-constraint i '/= j)))))
    (loop for i in drinks do
	  (loop for j in drinks do
		(cond ((nequal i j) (make-constraint i '/= j)))))
    (map nil #'(lambda (c) (make-constraint (first c) (second c) (third c)))
	 '((englishman = red) (red = englishman)
	   (spaniard = dog) (dog = spaniard)
	   (coffee = green) (green = coffee)
	   (ukranian = tea) (tea = ukranian)
	   (green immediately-to-the-right-of ivory)
	   (ivory immediately-to-the-left-of green)
	   (old-gold = snails) (snails = old-gold)
	   (kools = yellow) (yellow = kools)
	   (chesterfield next-to fox) (fox next-to chesterfield)
	   (kools next-to horse) (horse next-to kools)
	   (lucky = orange-juice) (orange-juice = lucky)
	   (japanese = parliament) (parliament = japanese)
	   (norwegian next-to blue) (blue next-to norwegian)))
    (setf (domain (get-var 'milk)) '(3))
    (setf (domain (get-var 'norwegian)) '(1))
    'zebra))
