(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defvar *solution* nil)
(defvar *results* nil)
(defvar *width* nil)
(defvar *induced-width* nil)
(defvar *bandwidth* nil)
(defvar *trials* 0)
(defvar *f* nil)


(defun get-solution ()
  (let ((s nil))
    (loop for i from *n* downto 1 do
	  (push (aref v i) s))
  s))

(defun get-bandwidth ()
  (let ((w 0))
    (loop for i from 1 to *n* do
	  (loop for j from 1 to *n* do
		(cond ((aref constraint i j)
		       (setq w (max w (abs (- i j))))))))
    w))


(defun get-width ()
  (let ((vertex-width 0)
	(width 0))
    (loop for i from 1 to *n* do
	  (setq vertex-width 0)
	  (loop for j from 1 to (- i 1) do
		(cond ((aref constraint i j)
		       (setq vertex-width (+ 1 vertex-width)))))
	  (setq width (max width vertex-width)))
    width))


(defun get-induced-width ()
  (let ((induced (make-array '(30 30)))
	(iw 0)
	(induced-width 0))
    (loop for i from 1 to *n* do
	  (loop for j from 1 to *n* do
		(setf (aref induced i j) (aref constraint i j))))
    (loop for i from *n* downto 1 do
	  (loop for h from 1 to (- i 1) do
		(loop for g from 1 to (- i 1) do
		      (cond ((and (aref induced i h) (aref induced i g))
			     (setf (aref induced g h) t
				   (aref induced h g) t))))))
    (loop for i from 1 to *n* do
	  (setq iw 0)
	  (loop for j from 1 to (- i 1) do
		(cond ((aref induced i j) (setq iw (+ 1 iw)))))
	  (setq induced-width (max induced-width iw)))
    induced-width))


(defun equal-lists (x y)
  (or (and (null x) (null y))
      (and (equal (first x) (first y))
	   (equal-lists (rest x) (rest y)))))


(defvar *count* 0)


(defun make-order (instantiation-order)
  (let ((vars nil))
    (loop for name in instantiation-order do
	  (setq vars (append vars (list (get-var name)))))
    (setq *vars* vars)
    (init)))


(defun random-tests (functions data-file results-file)
  (let ((f-in (open data-file :direction :input))
	(f-out (open results-file :direction :output :if-exists :rename))
	(datum nil)
	(s nil)
	(start-f nil)
	(end-f nil)
	(status nil)
	(cpu-time nil))
    (setq *trials* 0)
    (make-dechters-zebra)
    (setq datum (read f-in))
    (loop until (equal datum "end of data") do
	  (setq *trials* (+ 1 *trials*)
		*solution* nil)
	  (make-order datum)
	  (setq *bandwidth* (get-bandwidth)
		*width* (get-width)
		*induced-width* (get-induced-width))
	  (loop for f in functions do
		(reset)
		(setq *f* f)
		(setq start-f (get-internal-run-time))
		(setq status (funcall f))
		(setq end-f (get-internal-run-time))
		(setq cpu-time (/ (* 1.0 (- end-f start-f)) internal-time-units-per-second))
		(setq s (get-solution))
		(cond ((equal status 'impossible)
		       (print (list "disaster" *trials* *f*))))
		(cond ((null *solution*) (setq *solution* s))
		      ((not (equal-lists *solution* s)) (print "Error: different solution")))
		(write (list f *bandwidth* checks nodes *width* *induced-width* cpu-time) :stream f-out))
	  (setq datum (read f-in)))
    (write "end of data" :stream f-out)
    (close f-in)
    (close f-out)))


(defun AAAI-tests ()
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-16.data"
		"/usr/keg/pat/CSP/AAAI/width-16.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-17.data"
		"/usr/keg/pat/CSP/AAAI/width-17.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-18.data"
		"/usr/keg/pat/CSP/AAAI/width-18.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-19.data"
		"/usr/keg/pat/CSP/AAAI/width-19.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-20.data"
		"/usr/keg/pat/CSP/AAAI/width-20.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-21.data"
		"/usr/keg/pat/CSP/AAAI/width-21.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-22.data"
		"/usr/keg/pat/CSP/AAAI/width-22.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-23.data"
		"/usr/keg/pat/CSP/AAAI/width-23.results")
  (random-tests '(fc fc-d2c fc-cbj fc-cbj-dkc)
		"/usr/keg/pat/csp/width-24.data"
		"/usr/keg/pat/CSP/AAAI/width-24.results"))

(defun IJCAI-tests-1 ()
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-16.data"
		"/usr/keg/pat/CSP/IJCAI/width-16.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-17.data"
		"/usr/keg/pat/CSP/IJCAI/width-17.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-18.data"
		"/usr/keg/pat/CSP/IJCAI/width-18.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-19.data"
		"/usr/keg/pat/CSP/IJCAI/width-19.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-20.data"
		"/usr/keg/pat/CSP/IJCAI/width-20.results"))

(defun IJCAI-tests-2 ()
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-21.data"
		"/usr/keg/pat/CSP/IJCAI/width-21.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-22.data"
		"/usr/keg/pat/CSP/IJCAI/width-22.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-23.data"
		"/usr/keg/pat/CSP/IJCAI/width-23.results")
  (random-tests '(bt bj gbj cbj bm bj-d2c cbj-dkc fc fc-d2c)
		"/usr/keg/pat/csp/width-24.data"
		"/usr/keg/pat/CSP/IJCAI/width-24.results"))
