

(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defun nequal (x y)
  (not (equal x y)))


(defun check (i j)
  (let ((f (aref constraint i j)))
    (cond (f (setq checks (+ checks 1))
	     (funcall f (aref v i) (aref v j)))
	  (t t))))

(defun max-list (l)
  (let ((m (first l)))
    (loop for e in l do
	  (setq m (max m e)))
    m))

(defun bcssp (label unlabel)
  (let ((status 'unknown)
	(i 1))
    (setq consistent t)
    (loop while (equal status 'unknown) do
	  (cond (consistent
		 (setq nodes (+ 1 nodes))
		 (setq i (funcall label i)))
		((not consistent)
		 (setq i (funcall unlabel i))))
	  (cond ((> i *n*) (setq status 'solution))
		((= i 0) (setq status 'impossible))))
    status))


(defun check-forwards (i j)
  (cond ((aref constraint i j)
	 (let ((reduction nil))
	   (loop for k in (aref current-domain j) do
		 (setf (aref v j) k)
		 (cond ((not (check i j)) (push k reduction))))
	   (cond (reduction
		  (setf (aref current-domain j)
			(set-difference (aref current-domain j) reduction))
		  (push reduction (aref reductions j))
		  (push j (aref future-fc i))
		  (push i (aref past-fc j)))))))
  (aref current-domain j))

(defun undo-reductions (i)
  (let ((reduction nil))
    (loop for j in (aref future-fc i) do
	  (setq reduction (pop (aref reductions j)))
	  (setf (aref current-domain j)
		(cond ((listp (first reduction))
		       (sort (append (aref current-domain j) reduction) '< :key 'second))
		       (t (sort (append (aref current-domain j) reduction) '<))))
	  (pop (aref past-fc j)))
    (setf (aref future-fc i) nil)))

(defun update-current-domain (i)
  (setf (aref current-domain i) (aref domain i))
  (loop for reduction in (aref reductions i) do
	(setf (aref current-domain i)
	      (set-difference (aref current-domain i) reduction))))

(defun fc-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setq consistent t)
	(setf (aref v i) k)
	(loop for j from (+ i 1) to *n* while consistent do
	      (setq consistent (check-forwards i j)))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i)))
	       (undo-reductions i))))
  (cond (consistent (+ i 1))
	(t i)))

(defun fc-unlabel (i)
  (let ((h (- i 1)))
    (undo-reductions h)
    (update-current-domain i)
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (aref current-domain h))
    h))

(defun fc-d2c-label (i)
  (let ((j nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setq consistent t)
	  (setf (aref v i) k)
	  (loop for temp from (+ i 1) to *n* while consistent do
	      (setq j temp
		    consistent (check-forwards i j)))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i)))
	       (undo-reductions i)
	       (cond ((= 1 (length (aref past-fc j)))
		      (setf (aref domain i) (remove k (aref domain i))))))))
    (cond (consistent (+ i 1))
	  (t i))))

(defun fc-cbj-label (i)
  (let ((j nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setq consistent t)
	  (setf (aref v i) k)
	  (loop for temp from (+ i 1) to *n* while consistent do
		(setq j temp
		      consistent (check-forwards i j)))
	  (cond ((not consistent)
		 (setf (aref current-domain i) (remove k (aref current-domain i)))
		 (undo-reductions i)
		 (setf (aref conf-set i)
		       (union (aref conf-set i) (aref past-fc j))))))
    (cond (consistent (+ i 1))
	  (t i))))

(defun fc-cbj-unlabel (i)
  (let ((h (max (max-list (aref conf-set i)) (max-list (aref past-fc i)))))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (union (aref conf-set i) (aref past-fc i)))))
    (loop for j from i downto (+ h 1) do
	  (setf (aref conf-set j) (list 0))
	  (undo-reductions j)
	  (update-current-domain j))
    (undo-reductions h)
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (aref current-domain h))
    h))


(defun fc-cbj-dkc-label (i)
  (let ((j nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setq consistent t)
	  (setf (aref v i) k)
	  (loop for temp from (+ i 1) to *n* while consistent do
		(setq j temp
		      consistent (check-forwards i j)))
	  (cond ((not consistent)
		 (setf (aref current-domain i) (remove k (aref current-domain i)))
		 (undo-reductions i)
		 (cond ((= 1 (length (aref past-fc j)))
			(setf (aref domain i) (remove k (aref domain i)))))
		 (setf (aref conf-set i)
		       (union (aref conf-set i) (aref past-fc j))))))
    (cond (consistent (+ i 1))
	  (t i))))

(defun fc-cbj-dkc-unlabel (i)
  (let ((h (max (max-list (aref conf-set i)) (max-list (aref past-fc i)))))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (union (aref conf-set i) (aref past-fc i)))))
    (loop for j from i downto (+ h 1) do
	  (setf (aref conf-set j) (list 0))
	  (undo-reductions j)
	  (update-current-domain j))
    (undo-reductions h)
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (cond ((= 1 (length (aref conf-set h)))
			(setf (aref domain h) (remove (aref v h) (aref domain h)))))
    (setq consistent (aref current-domain h))
    h))


(defun fc () (bcssp 'fc-label 'fc-unlabel))
(defun fc-d2c () (bcssp 'fc-d2c-label 'fc-unlabel))
(defun fc-cbj () (bcssp 'fc-cbj-label 'fc-cbj-unlabel))
(defun fc-cbj-dkc () (bcssp 'fc-cbj-dkc-label 'fc-cbj-dkc-unlabel))


(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defun bt-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setq consistent t)
	(setf (aref v i) k)
	(loop for h from 1 to (- i 1) while consistent do
	      (setq consistent (check i h)))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i))))))
  (cond (consistent (+ i 1))
	(t i)))


(defun bt-unlabel (i)
  (let ((h (- i 1)))
    (setf (aref current-domain i) (aref domain i))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))

(defun bj-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setf consistent t
	      (aref v i) k)
	(loop for h from 1 to (- i 1) while consistent do
	      (setf (aref max-check i) (max h (aref max-check i))
		    consistent (check i h)))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i))))))
  (cond (consistent (+ i 1))
	(t i)))

(defun bj-unlabel (i)
  (let ((h (aref max-check i)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref max-check j) 0))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h))
	  consistent (nequal (aref current-domain h) nil))
    h))

(defun bj-d2c-label (i)
  (let ((h nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setf consistent t
		(aref v i) k)
	  (loop for temp from 1 to (- i 1) while consistent do
		(setf h temp
		      (aref max-check i) (max h (aref max-check i))
		      consistent (check i h)))
	  (cond ((not consistent)
		 (setf (aref current-domain i) (remove k (aref current-domain i)))
		 (pushnew h (aref conf-set i)))))
    (cond (consistent
	   (setf (aref instantiated i) t)
	   (+ i 1))
	  (t i))))

(defun bj-d2c-unlabel (i)
  (let* ((h (aref max-check i))
	 (k (aref v h)))
    (cond ((and (not (aref instantiated i))
		(= 2 (length (aref conf-set i))))
	   (setf (aref domain h) (remove k (aref domain h)))))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref max-check j) 0
		(aref conf-set j) (list 0)
		(aref instantiated j) nil))
    (setf (aref current-domain h)
	  (remove k (aref current-domain h))
	  consistent (nequal (aref current-domain h) nil))
    h))

(defun cbj-label (i)
  (let ((h nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setf consistent t
		(aref v i) k)
	  (loop for temp from 1 to (- i 1) while consistent do
		(setf h temp
		      consistent (check i h)))
	  (cond ((not consistent)
		 (setf (aref current-domain i) (remove k (aref current-domain i)))
		 (pushnew h (aref conf-set i)))))
    (cond (consistent (+ i 1))
	  (t i))))

(defun cbj-unlabel (i)
  (let ((h (max-list (aref conf-set i))))
    (cond (*trace*
	   (print (list i (aref conf-set i) h (aref conf-set h)) *trace*)))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (aref conf-set i))))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref conf-set j) (list 0)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h))
	  consistent (nequal (aref current-domain h) nil))
    h))

(defun gbj-label (i)
  (bt-label i))

(defun gbj-unlabel (i)
  (cond (*trace*
	   (print (list i (aref parents i) P) *trace*)))
  (setq P (remove i (union P (aref parents i))))
  (let ((h (max-list P)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)))
    (setf (aref current-domain h)	  
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))
;;;
;;; Note: this is Dechter's (1990) version of GBJ. Forward move is bt-label
;;;



(defun cbj-dkc-label (i)
  (let ((h nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setq consistent t)
	  (setf	(aref v i) k)
	  (loop for temp from 1 to (- i 1) while consistent do
		(setq h temp)
		(setq consistent (check i h)))
	  (cond ((not consistent)
		 (setf (aref current-domain i) (remove k (aref current-domain i)))
		 (pushnew h (aref conf-set i)))))
    (cond (consistent (+ i 1))
	  (t i))))

(defun cbj-dkc-unlabel (i)
  (let* ((h (max-list (aref conf-set i)))
	 (k (aref v h)))
    (cond (*trace*
	   (print (list i (aref conf-set i) h (aref conf-set h)) *trace*)))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (aref conf-set i))))
    (cond ((= 2 (length (aref conf-set i)))
	   (setf (aref domain h) (remove k (aref domain h))) ;{***}  
	   (cond (*trace* (print (list 'deleted k) *trace*)))))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref conf-set j) (list 0)))
    (setf (aref current-domain h)
	  (remove k (aref current-domain h)))
    (setq consistent (aref current-domain h))
    h))
;;;
;;; Retains "directed" k-consistent knowledge derived by search process
;;; {***} detects k-inconsistency. If we backtrack from v[i] to v[h] and
;;; the only variable that v[i] is in conflict with is v[h], we conclude
;;; that the value assigned to v[h] cannot occur within any solution to G
;;; Note that this line will (potentially) detect k-inconsistency for 2 <= k < n
;;;


(defun bm-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setq consistent (>= (aref mcl i k) (aref mbl i)))
	(setf (aref v i) k)
	(loop for h from (aref mbl i) to (- i 1) while consistent do
	      (setf consistent (check i h)
		    (aref mcl i k) h))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i))))))
  (cond (consistent (+ i 1))
	(t i)))

(defun bm-unlabel (i)
  (let ((h (- i 1)))
    (setf (aref current-domain i) (aref domain i)
	  (aref mbl i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref mbl j) (min (aref mbl j) h)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))

(defun bmj-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setq consistent (>= (aref mcl i k) (aref mbl i)))
	(setf (aref v i) k)
	(loop for h from (aref mbl i) to (- i 1) while consistent do
	      (setf consistent (check i h)
		    (aref mcl i k) h))
	(setf (aref max-check i) (max (aref max-check i) (aref mcl i k)))
	(cond ((not consistent)
	       (setf (aref current-domain i) (remove k (aref current-domain i))))))
  (cond (consistent (+ i 1))
	(t i)))


(defun bmj-unlabel (i)
  (let ((h (aref max-check i)))
    ;(print (list 'bmj-unlabel i (aref current-domain i) (aref v i) h))
    ;(sleep 5)
    (setf (aref mbl i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref mbl j) (min (aref mbl j) h)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref max-check j) 0))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))


(defun bm-cbj-label (i)
  (setq consistent nil)
  (loop for k in (aref current-domain i) while (not consistent) do
	(setq consistent (>= (aref mcl i k) (aref mbl i)))
	(setf (aref v i) k)
	(loop for h from (aref mbl i) to (- i 1) while consistent do
	      (setf consistent (check i h)
		    (aref mcl i k) h))
	(cond ((not consistent)
	       (pushnew (aref mcl i k) (aref conf-set i))
	       (setf (aref current-domain i) (remove k (aref current-domain i))))))
  (cond (consistent (+ i 1))
	(t i)))

(defun bm-cbj-unlabel (i)
  (let ((h (max-list (aref conf-set i))))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (aref conf-set i))))
    (setf (aref mbl i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref mbl j) (min (aref mbl j) h)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref conf-set j) (list 0)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))

(defun bm-gbj-unlabel (i)
  (setq P (remove i (union P (aref parents i))))
  (let ((h (max-list P)))
    (setf (aref mbl i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref mbl j) (min (aref mbl j) h)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))

(defun bm-cbj-dkc-unlabel (i)
  (let ((h (max-list (aref conf-set i))))
    (setf (aref conf-set h)
	  (remove h (union (aref conf-set h) (aref conf-set i))))
    (setf (aref mbl i) h)
    (cond ((= 2 (length (aref conf-set i)))
	   (setf (aref domain h) (remove (aref v h) (aref domain h)))))
    (loop for j from (+ h 1) to *n* do
	  (setf (aref mbl j) (min (aref mbl j) h)))
    (loop for j from (+ h 1) to i do
	  (setf (aref current-domain j) (aref domain j)
		(aref conf-set j) (list 0)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (nequal (aref current-domain h) nil))
    h))




(defun bt () (bcssp 'bt-label 'bt-unlabel))
(defun bj () (bcssp 'bj-label 'bj-unlabel))
(defun bj-d2c () (bcssp 'bj-d2c-label 'bj-d2c-unlabel))
(defun cbj () (bcssp 'cbj-label 'cbj-unlabel))
(defun gbj () (bcssp 'gbj-label 'gbj-unlabel))
(defun cbj-dkc () (bcssp 'cbj-dkc-label 'cbj-dkc-unlabel)) ; retains k-consistency

(defun bm () (bcssp 'bm-label 'bm-unlabel))
(defun bmj () (bcssp 'bmj-label 'bmj-unlabel))
(defun bm-cbj () (bcssp 'bm-cbj-label 'bm-cbj-unlabel))
(defun bm-gbj () (bcssp 'bm-label 'bm-gbj-unlabel))
(defun bm-cbj-dkc () (bcssp 'bm-cbj-label 'bm-cbj-dkc-unlabel))


