/*
* Packt stdin so, dass stdout ein brauchbarer Zufallsstrom wird.
* Das optionale Kommandozeilenargument gibt die Anzahl der auszugebenden Bytes an.

* Die Approximation fr die Entropie ist nur auf analoge Soundeingnge
* ohne angeschlossene Gerte (also ohne Microphon oder Player oder...) geeignet!
*
* Das Programm versagt, wenn mehr als 1MB fr 256bit Zufall ntig sind (siehe tuning unten).
*
* Der optionale Parameter gibt an, wieviele Byte gesammelt werden sollen, wenn er nicht
* vorhanden oder <=0 ist, dann wird solange gesammelt, bis ein Fehler auftritt.
*/
#include "sha2.h"
#include <strings.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

/*tuning: je grer der Puffer, umso wahrscheinlicher, dass noch Zufall aus
  sehr schwachen Quellen gequetscht wird, aber auch umso wahrscheinlicher,
  dass scheinbarer Zufall verarbeitet wird*/
#define BUFSIZE (1024*1024)

/*tuning: je kleiner, umso besser die Ausnutzung des Zufalls, je grer umso
  schneller das Programm; min=64, max=BUFSIZE*/
#define BLOCKSIZE 128

char gbuf[BUFSIZE];
int gpos=0,gentrop=0;


void estimate(int len)
{
	int c0=0,c1=0,i,j;
	/*gehe durch die gelesenen Bytes*/
	for(i=0;i<len;i++){
		/*zhle die Bits*/
		for(j=0;j<8;j++)
			if(gbuf[gpos+i] & (1<<j))c1++;
			else c0++;
	}
	/*korrigiere Position*/
	gpos+=len;
	/*korrigiere Entropie-Schtzung*/
	if(c0<c1)gentrop+=c0;
	else gentrop+=c1;
}

/*statistik speicher*/
int gcnt=0,gslen=0,gsent=0;

void pack()
{
	unsigned char buf[32];
	/*packen:*/
	sha256(buf,gbuf,BUFSIZE);
	/*auf stdout schreiben:*/
	write(STDOUT_FILENO,buf,32);
	/*aller 10 blcke: statitik*/
	gcnt++;
	gslen+=gpos;
	gsent+=gentrop;
	if(gcnt>=10){
		fprintf(stderr,"%i bytes contained %i bit entropy with output of %i bit\n",gslen,gsent,gcnt*256);
		gslen=gsent=gcnt=0;
	}
	/*reset & von vorn...*/
	gpos=gentrop=0;
}

/*Berechnung...*/
int main(int argc,char**argv)
{
	int r,rmax=-1,rcur=0;
	/*Argumente checken*/
	if(argc>1){
		rmax=strtol(argv[1],0,0);
	}
	/*einen Block lesen*/
	while((r=read(STDIN_FILENO,gbuf+gpos,BLOCKSIZE))>0){
		/*Zufallsanteil bestimmen*/
		estimate(r);
		/*wenn genug: packen & ausgeben*/
		if(gentrop>=256){
			pack();
			rcur+=32;
		}
		if(rmax>0 && rcur>=rmax){
			fprintf(stderr,"Ready. Output %i bytes.\n",rcur);
			exit(0);
		}
		/*wenn zuviel speicher mit zuwenig zufall: fehler*/
		if((gpos+BLOCKSIZE)>BUFSIZE){
			fprintf(stderr,"Error, collected %i bytes with only %i bits of randomness.\n",gpos,gentrop);
			exit(1);
		}
	}
	/*Schleife hat abgebrochen: lesefehler*/
	fprintf(stderr,"Error: could not read on stdin.\n");
	exit(1);
}
