/*
 * Eine einfache Methode Zufall zu verlngern...
 *
 * Es wird HMAC-SHA256 benutzt.
 *
 * Benutzung: ./randextend keylen saltlen roundlen rounds </dev/random >meinzufall
 * -> keylen - Lnge des initialen HMAC-Key (default 64 byte)
 * -> saltlen - Lnge des Salt pro Runde (default 64 byte)
 * -> roundlen - wieviele Bytes pro Runde ausgegeben werden (default 20MB)
 * -> rounds - Anzahl der Runden (default 1)
 * alle Argumente sind optional
 */


#include "hmac.h"


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

int keylen=0,saltlen=0,roundlen=0,rounds=0;
char *key,*salt;


/*fhrt exakt eine Runde aus:*/
void doround(int rn)
{
	int i;
	hmac_ctx ctx;
	char out[HASH_OUTPUT_SIZE];
	/*init salt*/
	if(read(STDIN_FILENO,salt,saltlen)<saltlen){
		fprintf(stderr,"Error: unable to read salt data.\n");
	}
	/*do looping*/
	for(i=0;i<roundlen;i++){
		/*init subround*/
		hmac_sha_begin(&ctx);
		/*set key*/
		hmac_sha_key(key,keylen,&ctx);
		/*hash salt*/
		hmac_sha_data(salt,saltlen,&ctx);
		/*hash counter*/
		hmac_sha_data((void*)&i,sizeof(i),&ctx);
		/*output*/
		hmac_sha_end(out,HASH_OUTPUT_SIZE,&ctx);
		write(STDOUT_FILENO,out,HASH_OUTPUT_SIZE);
	}
	fprintf(stderr,"Round %i successful.\n",rn);
}


int main(int argc,char**argv)
{
	int i;
	/*Argumente checken*/
	if(argc>1){
		keylen=strtol(argv[1],0,0);
	}
	if(keylen<=0)keylen=64;
	if(argc>2){
		saltlen=strtol(argv[2],0,0);
	}
	if(saltlen<=0)saltlen=64;
	if(argc>3){
		roundlen=strtol(argv[3],0,0);
	}
	if(roundlen<=0)roundlen=20*1024*1024;
	/*correct into rounds of SHA256 instead of bytes*/
	roundlen+=HASH_OUTPUT_SIZE-1;
	roundlen/=HASH_OUTPUT_SIZE;
	if(argc>4){
		rounds=strtol(argv[4],0,0);
	}
	if(rounds<=0)rounds=1;
	fprintf(stderr,"Attempting %i rounds with %i bytes output with keylen=%i and saltlen=%i.\n",
		rounds,roundlen*HASH_OUTPUT_SIZE,keylen,saltlen);
	/*key init*/
	key=malloc(keylen);
	if(read(STDIN_FILENO,key,keylen)<keylen){
		fprintf(stderr,"Error: cannot read key data from stdin.\n");
	}
	salt=malloc(saltlen);
	/*loop through rounds*/
	for(i=0;i<rounds;i++)
		doround(i);
		
	return 0;
}
