/*
* Errechnet die HMAC-SHA256-Checksumme von stdin mit seinem 1. Argument als Key.
*/
#include "hmac.h"

#include <strings.h>
#include <stdio.h>
#include <unistd.h>

/*SHA256 Hash hex ausgeben*/
void printout(unsigned char *buf)
{
	static const char hex[]="0123456789ABCDEF";
	char out[1024];
	int i;
	for(i=0;i<HASH_OUTPUT_SIZE;i++){
		out[i*2]=hex[(buf[i]>>4)&0xf];
		out[i*2+1]=hex[buf[i]&0xf];
	}
	out[64]=0;
	printf("%s\n",out);
}

/*Berechnung...*/
int main(int argc,char**argv)
{
	int i;
	unsigned char out[HASH_OUTPUT_SIZE];
	char buf[1024]="";
	/*die meisten Implementationen von Hashes speichern ihre Daten in einer Kontextstruktur:*/
	hmac_ctx ctx;
	
	/*dieser Kontext muss initialisiert werden:*/
	hmac_sha_begin(&ctx);
	
	/*bei HMAC muss der Key gesetzt werden:*/
	if(argc!=2){
		fprintf(stderr,"Usage: hmacsumme \"key\" < messagefile\n");
		exit(1);
	}
	hmac_sha_key(argv[1],strlen(argv[1]),&ctx);
	
	/*danach schreibt man die Daten hinein:*/
	while((i=read(STDIN_FILENO,buf,1024))>0){
		hmac_sha_data(buf,i,&ctx);
	}
	
	/*schliesslich wird der Kontext finalisiert und das Ergebnis zurckgeliefert:*/
	hmac_sha_end(out,sizeof(out),&ctx);
	
	printout(out);
	return 0;
}
