#include "sha2.h"
#include <strings.h>
#include <stdio.h>
#include <unistd.h>

char*key;
int ctr=0;

char kbuf[32];
int kpos=33;

/*einen neuen Block von Cipher Bytes erzeugen:*/
void refill()
{
	sha256_ctx ctx;
	
	ctr++;
	sha256_begin(&ctx);
	/*Key hashen*/
	sha256_hash(key,strlen(key),&ctx);
	/*Counter hashen*/
	sha256_hash((void*)&ctr,sizeof(ctr),&ctx);
	/*neuen Block speichern*/
	sha256_end(kbuf,&ctx);
	kpos=0;
}

/*liefert das nchste Stream-Cipher-Byte*/
char cipher()
{
	/*ist Key Puffer abgelaufen?*/
	if(kpos>=32)refill();
	
	/*nchste Position liefern*/
	return kbuf[kpos++];
}

int main(int argc,char**argv)
{
	int i,j;
	char buf[1024];
	/*key holen*/
	if(argc!=2){
		fprintf(stderr,"Usage: %s key <file",*argv);
		return 1;
	}
	key=argv[1];
	/*stdin lesen*/
	while((i=read(STDIN_FILENO,buf,1024))>0){
		/*ver-/ent-schlsseln*/
		for(j=0;j<i;j++){
			buf[j]^=cipher();
		}
		/*schreiben*/
		write(STDOUT_FILENO,buf,i);
	}
	return 0;
}
