/*
* Errechnet die SHA256-Checksumme von stdin.
*/
#include "sha2.h"

#include <strings.h>
#include <stdio.h>
#include <unistd.h>

/*SHA256 Hash hex ausgeben*/
void printout(unsigned char *buf)
{
	static const char hex[]="0123456789ABCDEF";
	char out[1024];
	int i;
	for(i=0;i<SHA256_DIGEST_SIZE;i++){
		out[i*2]=hex[(buf[i]>>4)&0xf];
		out[i*2+1]=hex[buf[i]&0xf];
	}
	out[64]=0;
	printf("%s\n",out);
}

/*Berechnung...*/
int main(int argc,char**argv)
{
	int i;
	unsigned char out[SHA256_DIGEST_SIZE];
	char buf[1024]="";
	/*die meisten Implementationen von Hashes speichern ihre Daten in einer Kontextstruktur:*/
	sha256_ctx ctx;
	
	/*dieser Kontext muss initialisiert werden:*/
	sha256_begin(&ctx);
	
	/*danach schreibt man die Daten hinein:*/
	while((i=read(STDIN_FILENO,buf,1024))>0){
		sha256_hash(buf,i,&ctx);
	}
	
	/*schliesslich wird der Kontext finalisiert und das Ergebnis zurckgeliefert:*/
	sha256_end(out,&ctx);
	
	printout(out);
	return 0;
}
