//
//  MatchingPursuit.h
//  DBMCrossSynth
//
//  Created by Nicholas Collins on 17/05/2011.
//  Copyright 2011 Nick Collins. All rights reserved.
//

#include "DBMInnerProducts.h"

//normal matching pursuit on a single file 
struct IterationData {
    
    float weight_; 
    int whichscale_; 
    int whichframe_; 
    int whichfreq_;
    
}; 


class MatchingPursuit {
public:
    DBMInnerProducts* ips_; 
    
    IterationData * iterations_; 
    int numiterations_; 
    int numiterationsnow_; 
    
    float *  residual_; 
    float * output_; 
    int numsamples_; //same size as input sound file data
    
    MatchingPursuit(DBMInnerProducts* ip); 
    ~MatchingPursuit(); 
    
    //analysis
    void Compute(float * source, float * target, int numsamples, int iterations); 
    
    //previous analysis affects this next analysis; strictly same order of atoms
    //void CrossAnalysis1(float * input, int numsamples, int iterations, IterationData * inputiterations); 
    
    //simulataneous analysis of two files, one step in each at a time
    //assumed valid same number of samples in both files
    //void DualAnalysis1(float * input1, float * input2, int numsamples, int iterations, MatchingPursuit *); 
    
    
    //straight re-synthesis
   //void Synthesize(float * output, int numsamples); 
    
    //transformation experiments
    //void Synthesize2(float * output, int numsamples); 
    
    void Save(char *);
    void Load(char *);
    
};