//
//  DictionaryAtomsAtScale.cpp
//  DBMCrossSynth
//
//  Created by Nicholas Collins on 07/05/2011.
//  Copyright 2011 Nick Collins. All rights reserved.
//

#include "DictionaryAtomsAtScale.h"

#include <math.h>

//#include <iostream>

//, int samplerate
DictionaryAtomsAtScale::DictionaryAtomsAtScale(int scale, int timeres) {
    
    scale_ = scale; 
    timeresolution_ = timeres; 

    gaussianwindow_ = new float [scale_]; 
    
    int i,j; 
    
    //http://en.wikipedia.org/wiki/Window_function#Gaussian_windows
    //must choose extent in std devs of window
    float sigma = 0.4; 
    
    float halfway = (scale_-1)/2.0f; 
    
    //precalculation to avoid too many steps
    sigma *= halfway; 
    sigma = 1.0f/sigma; 
    
    float temp; 
    
    for ( i=0; i<scale_; ++i ) {
       
        temp = sigma*(i-halfway); 
        
        gaussianwindow_[i] = exp(-0.5*temp*temp); 
        
        //std::cout << gaussianwindow_[i] << std::endl; 
        
    } 
        
    normalizationconstants_ = 0;  
          
    
}


DictionaryAtomsAtScale::~DictionaryAtomsAtScale() {
        
    delete gaussianwindow_; 
    delete [] normalizationconstants_;
    
}

void DictionaryAtomsAtScale::PrepareAtomsFromAudio(float * samples, long length) {
    
    int i,j; 
    
    delete [] normalizationconstants_;
    
    length_ = length; 
    
    numwindowsfit_ = (length-scale_)/timeresolution_ +1; 
    
    normalizationconstants_ = new float[numwindowsfit_]; 
    
    for (i=0; i<numwindowsfit_; ++i) {
        
        //atom must be normalized so its inner product with self is 1
        float norm = 0.0; 
        
        float * source = samples + (i*timeresolution_); 
        
        for ( j=0; j<scale_; ++j ) {
        
            float val = source[j]*gaussianwindow_[j];   //lookup table for cosine would make it quicker
            norm += val*val; 
        
        }
        
        norm = sqrt(1.0f/norm); 
        
        normalizationconstants_[i] = norm; 
    }
    
}


Dictionary::Dictionary() {

    //keep relatively small scales for now, avoid too much memory and calculation to start with
    numscales_ = 2; 
    
    scaledata_ = new DictionaryAtomsAtScale *[numscales_]; 
    
    //scaledata_[0] = new DictionaryAtomsAtScale(256, 128);
    scaledata_[0] = new DictionaryAtomsAtScale(512, 256);
    scaledata_[1] = new DictionaryAtomsAtScale(1024, 512);
    //scaledata_[2] = new DictionaryAtomsAtScale(2048, 1024);
    
    //scaledata_[3] = new DictionaryAtomsAtScale(4096, 2048);
//    scaledata_[5] = new DictionaryAtomsAtScale(8192, 4096, 5.4, g_samplingrate);
//    scaledata_[6] = new DictionaryAtomsAtScale(16384, 8192, 2.7, g_samplingrate);
    

}

Dictionary::~Dictionary() {
    
    
    for (int i=0; i<numscales_; ++i) 
        delete scaledata_[i]; 
    
    delete [] scaledata_; 

}

void Dictionary::PrepareAtomsFromAudio(float * samples, long length) {
    
    for (int i=0; i<numscales_; ++i) 
        scaledata_[i]->PrepareAtomsFromAudio(samples, length); 
        
}
















