//
//  DBMInnerProducts.h
//  DBMCrossSynth
//
//  Created by Nicholas Collins on 07/05/2011.
//  Copyright 2011 Nick Collins. All rights reserved.
//

#include "DictionaryAtomsAtScale.h"


class DBMInnerProductsAtScale {
    
public: 
    DictionaryAtomsAtScale * scaleatoms_; //pointer to global data store for these
    float ** ips_;  //for each frame of target, ip for each source atom
    int lengthinframes_;
    float * enveloped_; 
    
    //int framesize_; and framehop_ from scaleatoms_
    //efficient maximum checks, renewed as needed
    int maxframeatscale_; 
    float maxatscale_;
    float * maxperframe_; //for each frame
    int * maxindexperframe_;
    
    
    
    DBMInnerProductsAtScale(int numsamples, DictionaryAtomsAtScale * scaledata); 
    ~DBMInnerProductsAtScale(); 
    
    void Compute(int startsample, int endsample, float * source, float * target);
    
};


class DBMInnerProducts {
  
public:
    int numscales_; 
    DBMInnerProductsAtScale ** ipatscales_; 
    int lengthinsamples_; 
    int maxindexscale_; 
    float maxscale_; 

    DBMInnerProducts(int numsamples, Dictionary * atomdata); 
    ~DBMInnerProducts(); 
    
    //source is always padded to be big enough
    //forces recalculation in a given range. based on recent update; start by invalidating throughout range
    void Compute(int startsample, int endsample, float * source, float * target);
    
};

