//
//  DBMInnerProducts.cpp
//  DBMCrossSynth
//
//  Created by Nicholas Collins on 07/05/2011.
//  Copyright 2011 Nick Collins. All rights reserved.
//

#include "DBMInnerProducts.h"

//no zero padding for now, abandon any signal that doesn't fit. 

DBMInnerProductsAtScale::DBMInnerProductsAtScale(int numsamples, DictionaryAtomsAtScale * scaledata) {
    
    scaleatoms_ = scaledata; 
    
    //assumes numsamples > scaleatoms_->scale_
    if(numsamples > scaleatoms_->scale_)
        lengthinframes_ = (numsamples - scaleatoms_->scale_)/(scaleatoms_->timeresolution_) + 1; 
    else
        lengthinframes_ = 0; 
    
    ips_ = new float * [lengthinframes_]; 
    
    enveloped_ = new float [scaleatoms_->scale_]; 
    
    maxatscale_ = 0.0f; //not really set up until after first iteration; will be invalidated as first iteration whole sample range is worked over
    maxframeatscale_ = 0; 
    
    maxperframe_ = new float[lengthinframes_]; 
    maxindexperframe_ = new int[lengthinframes_]; 

    
    int i; //, j; 
    
    int numatomsperframe = scaleatoms_->numwindowsfit_; 
    
    for (i= 0; i<lengthinframes_; ++i ) {
        
        ips_[i] = new float[numatomsperframe]; 
        
        //no need to initialise, since immediately calculate everything on first MP iteration
        //float * target =  ips_[i];
        
        //for ( j= 0; j<numatomsperframe; ++j ) 
        //    target[j] = 0.0; 
        
        //maxperframe_[i] = 0.0f; 
        //maxindexperframe_[i] = 0;
        
    }
                                         

}

DBMInnerProductsAtScale::~DBMInnerProductsAtScale() {
    
    for (int i= 0; i<lengthinframes_; ++i )
        delete [] ips_[i]; 
        
    delete [] ips_; 
    
    delete [] maxperframe_; 
    
    delete [] maxindexperframe_; 
    
    delete [] enveloped_;     
}

void DBMInnerProductsAtScale::Compute(int startsample, int endsample, float * source, float * target) {
    
    //int scale = scaleatoms_->scale_;
    int hop = scaleatoms_->timeresolution_;
    //int frames = lengthinframes_; 
    
    int windowstart = startsample/hop; 
    int windowend = endsample/hop; 
    
    if (windowend>=lengthinframes_) windowend = lengthinframes_-1; 
  
    //recompute IPS in this window range inclusive
    
    
    int i,j,k; 
    
    int size = scaleatoms_->scale_;
    int numatoms = scaleatoms_->numwindowsfit_;
    
    for (i=windowstart; i<=windowend;++i) {
        
        int samplepos = hop*i; 
        
        //target is global sample data
        float * data = target+samplepos; 
        
        float maxatframe = -9999999999.9f; //maxperframe_[i];
        int maxindex = 0; //maxindexperframe_[i]; 
        
        float * ipsnow = ips_[i]; 
        
        
        //precalculate enveloping on target window
        
        float * envelopenow = scaleatoms_->gaussianwindow_; 
        
         for (j=0; j<size;++j)
             enveloped_[j] = data[j]*envelopenow[j]; 
        
        
        //for each source atom
        for (j=0; j<numatoms;++j) {
         
            float normconstant = scaleatoms_->normalizationconstants_[j];
            
            float *atom = source + (j * scaleatoms_->timeresolution_); //scaleatoms_->atoms_[j]; 
            
            float ipsum = 0.0f; 
            //calculate ip
            for (k=0; k<size;++k) {
             
                ipsum += atom[k]*enveloped_[k]; 
                
            }
            
            ipsum *= normconstant; 
            
            //check if max 
            if(ipsum>maxatframe) {
                
                maxatframe = ipsum; 
                maxindex = j; 
            }
            
            ipsnow[j] = ipsum; 
            
        }
        
        maxperframe_[i] = maxatframe;
        maxindexperframe_[i] = maxindex;
        
    }
    
    int checkframe1 = windowstart; 
    int checkframe2 = windowend; 
    
    if((maxframeatscale_>=windowstart) && (maxframeatscale_<=windowend)) {
        
         //if killed previous max, must check ALL frames
        
        checkframe1 = 0; 
        checkframe2 = lengthinframes_-1; 
        
        //initialise as well lest there be issues of using old out of date value! 
        maxframeatscale_ = 0; 
        maxatscale_ = maxperframe_[0]; 
        
    }
 

    for (i = checkframe1; i<=checkframe2; ++i) {
        
        float maxnow = maxperframe_[i]; 
        
        if(maxnow>maxatscale_) {
            
            maxatscale_ = maxnow; 
            maxframeatscale_ = i; 
        }
    }
   
    
}


DBMInnerProducts::DBMInnerProducts(int numsamples, Dictionary * atomdata) {
    
    lengthinsamples_ = numsamples; 
    
    numscales_ = atomdata->numscales_; 
    
    ipatscales_= new DBMInnerProductsAtScale *[numscales_]; 

    for ( int i= 0; i<numscales_; ++i ) 
        ipatscales_[i] = new DBMInnerProductsAtScale(lengthinsamples_,atomdata->scaledata_[i]); 
    
    maxscale_=0.0f;
    maxindexscale_=0;
    
}

DBMInnerProducts::~DBMInnerProducts() {
    
    for ( int i= 0; i<numscales_; ++i ) 
        delete ipatscales_[i]; 
    
    delete [] ipatscales_; 
}



void DBMInnerProducts::Compute(int startsample, int endsample, float * source, float * target) {
    
//at each scale, find invalidated region, then call through to appropriate DBMInnerProductsAtScale object to compute further
    
    int i; 
    
    for ( i = 0; i<numscales_; ++i ) {
 
        ipatscales_[i]->Compute(startsample, endsample, source, target);
        //CHECK lengthinsamples_
        
    }
    
    //update global max winner: using process can read this, and then set residual calculation in motion  
    
    //reset search. Could avoid this hunt if knew which scale was chosen already, but then only a small number of scales in dictionary
    
    maxscale_ = -99999999.9f; 
    maxindexscale_ = 0; 
    
    for ( i = 0; i<numscales_; ++i ) {
        
        float maxnow = ipatscales_[i]->maxatscale_; 
        
        if(maxnow>maxscale_) {
            
            maxscale_ = maxnow; 
            maxindexscale_ = i; 
            
        }
        
    }
    
}






