/*
	SuperCollider real time audio synthesis system
 Copyright (c) 2002 James McCartney. All rights reserved.
	http://www.audiosynth.com
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help


//this file 17/1/05 by Nicholas M. Collins after Brown/Puckette

//conversion of Qitch for chord detection- finds top n scoring fundamentals, reducing salience of any discovered


//will need compiler ifs for #include Altivec etc, kept in for now

#include "SC_PlugIn.h"
#include <vecLib/vecLib.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>

//helpful constants
#define PI 3.1415926535898f
#define TWOPI 6.28318530717952646f 

//FFT data, globals
int g_SR;
int g_Nyquist;
int g_N; 
int g_log2N;
int g_Nover2;
int g_overlap;
int g_overlapindex;
float g_framespersec;
float g_fftscale;
float g_freqperbin;

//float g_fmin;
//int g_qbands;
//float * g_qfreqs;
//float * g_kernels;

//non windowed FFT for the signal x[n] because the kernels are pre windowed
//float * g_hanning; 

//for pitch search, MATLAB calculated
//sieve= round(24*log(1:11)/log(2))       
//amps= fliplr(0.6:0.04:1.0);

int g_sieve[11]= {0,24,38,48,56,62,67,72,76,80,83};
float g_amps[11]={1,0.96,0.92,0.88,0.84,0.8,0.76,0.72,0.68,0.64,0.6}; 

//116 is near 5000 Hz in this , 90 is 2500Hz or so

extern "C"
{
	void load(InterfaceTable *inTable);
}

InterfaceTable *ft;

struct Citch : Unit {
	
	//FFT data
	int m_bufWritePos;
	float * m_prepareFFTBuf;
	float * m_FFTBuf;
	
	//vDSP
	unsigned long m_vlog2n;
	COMPLEX_SPLIT m_vA;
	FFTSetup m_vsetup;
	
	//Q data
	
	//FFT constants
	//int m_SR, m_N; //not used, just have globals
	int m_SR;
	int m_Nyquist;
	int m_N; 
	int m_log2N;
	int m_Nover2;
	int m_overlap;
	int m_overlapindex;
	float m_framespersec;
	float m_fftscale;
	float m_freqperbin;
	
	//constants for efficiency
	float m_twopioverN;
	float realb,imagb;
	
	int m_qbands;
	float * m_qfreqs;
	int * m_startindex;
	int * m_numindices;
	//int * m_cumulindices;
	float ** m_speckernelvals; //pointers into buffer data
	
	float * m_qmags;
	
	float m_amps[11];
	
	//instantaneous frequency tracking 
	int m_topqcandidate;
	int m_ifbins;
	
	float m_currfreq, m_hasfreq;
	
	
	float m_minfreq, m_maxfreq;
	int m_minqband, m_maxqband;
	
	float m_topten[10];
	int m_toptenindices[10];
	
	float m_lastfreqs[10];
	float m_currfreqs[10];
	float * m_freqbuf; 
	
};

extern "C"
{
	//required interface functions
	void Citch_next(Citch *unit, int wrongNumSamples);
	void Citch_Ctor(Citch *unit);
	void Citch_Dtor(Citch *unit);
}

//other functions
void preparefft(Citch *unit, float* in, int n);
void dofft(Citch *unit);
void prepareQ(InterfaceTable *inTable);
void prepareHanningWindow(); 
float instantaneousfrequency(Citch * unit, float * fftbuf, int k);

void Citch_Ctor(Citch* unit)
{
	int i;
	
	///////constant Q data in buffer passed in
	
	World *world = unit->mWorld;
    
	uint32 bufnum = (uint32)ZIN0(1);
	if (bufnum >= world->mNumSndBufs) bufnum = 0;
	
	SndBuf *buf = world->mSndBufs + bufnum; 
	
	int bufsize = buf->samples;
	
	//printf("bufnum %d size %d\n",bufnum, bufsize);			
	
	float * pdata= buf->data; 
	//get Q data	
	
	int SR= (int)pdata[0];
	int N= (int)pdata[1];
	
	int numbands= (int)pdata[2];
	
	unit->m_qbands=numbands;
	//int cumulsize= (int)pdata[3];
	
	//printf("SR %d N %d bands %d cumulsize %d \n",unit->m_SR, unit->m_N, unit->m_qbands, cumulsize);				
	
	//if(g_SR != SR){
	//		
	//		g_SR=SR; 
	//		g_Nyquist=(int)(SR/2);  
	//		g_framespersec= (float)g_overlap/g_SR;
	//		g_freqperbin= (float)g_SR/(float)g_N;
	//		
	//	};
	
	//other globals like g_N assumed correct for now
	//all FFTs are taken as a multiple of 1024
	unit->m_SR= SR;
	unit->m_Nyquist= SR/2;
	unit->m_N= N; 
	unit->m_log2N=(int)(log2(N)+0.5);  ;
	unit->m_Nover2= N/2;
	unit->m_overlap= N-1024;
	unit->m_overlapindex= (1024)%N;
	unit->m_framespersec= (float)(unit->m_overlap)/(float)SR;
	unit->m_fftscale=  1.0/(2.0*N);
	unit->m_freqperbin= (float)SR/(float)N;
	
	//constants for efficiency
	unit->m_twopioverN= TWOPI/(float)N;
	unit->realb=cos(unit->m_twopioverN);
	unit->imagb=sin(unit->m_twopioverN);
	
	////////FFT data///////////
	
	unit->m_prepareFFTBuf = (float*)RTAlloc(unit->mWorld, N * sizeof(float));
	unit->m_FFTBuf = (float*)RTAlloc(unit->mWorld, N * sizeof(float));
	unit->m_bufWritePos = 0;	
	
	////////vDSP///////////////
	
	unit->m_vA.realp = (float*)RTAlloc(unit->mWorld, unit->m_Nover2 * sizeof(float)); 
	unit->m_vA.imagp = (float*)RTAlloc(unit->mWorld, unit->m_Nover2 * sizeof(float));
	unit->m_vlog2n = unit->m_log2N; //(int)(log2(N)+0.5); //10; //N is hard coded as 1024, so 10^2=1024 //log2max(N);
	unit->m_vsetup = create_fftsetup(unit->m_vlog2n, 0);
	
	
	float * qfreqs=(float*)RTAlloc(world, numbands * sizeof(float));
	int * startindex=(int*)RTAlloc(world, numbands * sizeof(int));
	int * numindices=(int*)RTAlloc(world, numbands * sizeof(int));
	float ** speckernelvals=(float**)RTAlloc(world, numbands * sizeof(float*));
	float * qmags= (float*)RTAlloc(world, numbands * sizeof(float));
	
	/*
	 unit->m_qfreqs= (float*)RTAlloc(world, numbands * sizeof(float));
	 unit->m_startindex= (int*)RTAlloc(world, numbands * sizeof(int));
	 unit->m_numindices= (int*)RTAlloc(world, numbands * sizeof(int));
	 //unit->m_cumulindices= (int*)RTAlloc(world, numbands * sizeof(int));
	 //unit->m_speckernelvals = (float*)RTAlloc(world, cumulsize * sizeof(float));
	 unit->m_speckernelvals = (float*)RTAlloc(world, numbands * sizeof(float*));
	 unit->m_qmags = (float*)RTAlloc(world, numbands * sizeof(float));
	 */
	
	//load data 
	int bufpos=3; //4;
	
	//printf("%d %p %d %p \n",i,&(pdata[bufpos]),bufpos,pdata);
	
	//can be made more efficient with pointers
	for (i=0;i<numbands; ++i) {
		
		//printf("%d %p %d %p \n",i,&(pdata[bufpos]),bufpos,pdata);
		
		//freq startind cumul numvals vals'
		qfreqs[i]= pdata[bufpos];
		startindex[i]= (int) pdata[bufpos+1];
		numindices[i]= (int) pdata[bufpos+2]; //+3
		
		//int specind= pdata[bufpos+2]; //cumulative position into this buffer
		//unit->m_cumulindices[i]=specind;
		
		//printf("%d startind %d numind %d cumul %d \n",i, unit->m_startindex[i], unit->m_numindices[i], unit->m_cumulindices[i]);
		bufpos+=3; //4;
		
		speckernelvals[i]= pdata+bufpos;
		
		//printf("%d %p %d %p %p \n",i,&(pdata[bufpos]),bufpos,pdata+bufpos, speckernelvals[i]);
		
		/*
		 for (j=0;j<unit->m_numindices[i]; ++j) {
			 
			 unit->m_speckernelvals[specind+j]= pdata[bufpos+j];
			 //if(pdata[bufpos+j]>1000) printf("%d big %f indtarget %d indsource %d",i,pdata[bufpos+j],specind+j,bufpos+j);
		 }*/
		
		bufpos+= numindices[i]; 
	}
	
	unit->m_qfreqs=qfreqs;
	unit->m_startindex= startindex;
	unit->m_numindices= numindices;
	unit->m_speckernelvals= speckernelvals;
	unit->m_qmags= qmags;
	
	
	/////storing complex numbers from previous frames for instananeous frequency calculation
	unit->m_topqcandidate=numbands-(g_sieve[10])-1; //85
	float tempfreq= unit->m_qfreqs[unit->m_topqcandidate];
	unit->m_ifbins=((int)ceil((tempfreq/(unit->m_freqperbin))+0.5))+1; //cover yourself for safety
	
	//printf("numbinsstored %d tempfreq %f topcand %d \n",unit->m_ifbins,tempfreq, unit->m_topqcandidate); //more info! 
	
	//if input amp template can correct search comb
	
	for (i=0;i<11;++i)
		unit->m_amps[i]= g_amps[i];
	
	uint32 ampbufnum = (uint32)ZIN0(4);
	if (!(ampbufnum > world->mNumSndBufs || ampbufnum<0)) {
		SndBuf *buf2 = world->mSndBufs + ampbufnum; 
		
		bufsize = buf2->samples;
		
		pdata= buf2->data; 
		
		if(bufsize==11) {
			for (i=0;i<11;++i)
				unit->m_amps[i]= pdata[i];
		}
	}
	
	unit->m_minfreq= ZIN0(5);
	unit->m_maxfreq= ZIN0(6);
	
	//search qfreqs 
	unit->m_minqband= 0; 
	unit->m_maxqband=unit->m_topqcandidate;
	
	for(i=0;i<numbands; ++i) {
		
		if(qfreqs[i]>=unit->m_minfreq) {unit->m_minqband=i; break;} 
		
	}
	
	for(i=numbands-1;i>=0; --i) {
		
		if(qfreqs[i]<=unit->m_maxfreq) {unit->m_maxqband=i; break;} 
		
	}
	
	//unecessary, already true unit->m_maxqband= sc_min(unit->m_topqcandidate, unit->m_maxqband);
	unit->m_minqband= sc_min(unit->m_minqband, unit->m_maxqband); //necessary test if input stupid
	
	//printf("minfreq %f maxfreq %f minqband %d maxqband %d \n", unit->m_minfreq, unit->m_maxfreq, unit->m_minqband,unit->m_maxqband);
	
	unit->m_currfreq=440;  
	unit->m_hasfreq=0;
	
	//judging best, looking also at previous round
	for (i=0;i<10;++i) {
		unit->m_lastfreqs[i]=440.0;
		unit->m_currfreqs[i]=440.0;
	}
	
	//must be size 12
	uint32 freqbufnum = (uint32)ZIN0(3);
	if (!(freqbufnum > world->mNumSndBufs || freqbufnum<0)) {
		SndBuf *buf3 = world->mSndBufs + freqbufnum; 
		
		unit->m_freqbuf= buf3->data; 
		
	} else unit->m_freqbuf=0; //NULL pointer
	
	unit->mCalcFunc = (UnitCalcFunc)&Citch_next;
	
}



void Citch_Dtor(Citch *unit)
{
	
	RTFree(unit->mWorld, unit->m_prepareFFTBuf);
	RTFree(unit->mWorld, unit->m_FFTBuf);
	
	RTFree(unit->mWorld, unit->m_qfreqs);
	RTFree(unit->mWorld, unit->m_startindex);
	RTFree(unit->mWorld, unit->m_numindices);
	//RTFree(unit->mWorld, unit->m_cumulindices);
	RTFree(unit->mWorld, unit->m_speckernelvals);
	
	//RTFree(unit->mWorld, unit->m_store[0]);
	//RTFree(unit->mWorld, unit->m_store[1]);
	
	if (unit->m_vA.realp) RTFree(unit->mWorld, unit->m_vA.realp);
	if (unit->m_vA.imagp) RTFree(unit->mWorld, unit->m_vA.imagp);
	if (unit->m_vsetup) destroy_fftsetup(unit->m_vsetup);
	
}


void Citch_next(Citch *unit, int wrongNumSamples)
{
	//would normally be float,will be cast to int for Tristan's optimisation
	float *in = IN(0);
	
	int numSamples = unit->mWorld->mFullRate.mBufLength;
	
	//float *output = ZOUT(0);
	
	preparefft(unit, in, numSamples);
	
	ZOUT0(0)=unit->m_currfreq;
	ZOUT0(1)=unit->m_hasfreq;
	
	//float outval= 0.0;	
	//	for (int i=0; i<numSamples; ++i) {
	//		*++output = outval;
	//	}
	//	
}


//update for unknown SR, overlap

//Tristan Jehan recommends copying ints rather than floats- I say negligible compared to over algorithm costs for the moment
void preparefft(Citch *unit, float* in, int n) {
	
	int i, index = 0, cpt = n, maxindex;
	
	int bufpos= unit->m_bufWritePos;
	
	float * preparefftbuf=unit->m_prepareFFTBuf;
	float * fftbuf= unit->m_FFTBuf;
	
	// Copy input samples into prepare buffer	
	while ((bufpos < unit->m_N) && (cpt > 0)) {
		preparefftbuf[bufpos] = in[index];
		bufpos++;
		index++;
		cpt--;
	}
	
	// When Buffer is full...
	if (bufpos >= unit->m_N) {
		
		// Make a copy of prepared buffer into FFT buffer for computation
		for (i=0; i<unit->m_N; i++) 
			fftbuf[i] = preparefftbuf[i];
		
		//if(unit->m_overlap>0) will be safe as long as overlap=0l overlapindex=0 too
		
		// Save overlapping samples back into buffer- no danger since no indices overwritten
		for (i=0; i<unit->m_overlap; i++) 
			preparefftbuf[i] = preparefftbuf[unit->m_overlapindex+i];
		
		maxindex = n - index + unit->m_overlapindex;
		
		//blockSize less than g_N-g_overlapindex so no problem
		// Copy the rest of incoming samples into prepareFFTBuffer
		for (i=unit->m_overlapindex; i<maxindex; i++) {
			preparefftbuf[i] = in[index];
			index++;
		}
		
		bufpos = maxindex;
		
		//FFT buffer ready- calculate away!
		dofft(unit);
	}
	
	
	unit->m_bufWritePos= bufpos;
	//printf("%d \n",bufpos);
	
}



//calculation function once FFT data ready, will be removing windowing! 
void dofft(Citch *unit) {
	
	int i,j,k;
	
	float * fftbuf= unit->m_FFTBuf;
	
	float ampthresh = ZIN0(2);
	
	bool ampok=false;
	
	for (j = 0; j < unit->m_N; ++j) {	
		if (fabs(fftbuf[j]) >= ampthresh) {
			ampok = true;
			break;
		}
	}
	
	if(ampok) {
		
		
		//NO WINDOWING FOR CONSTANT Q TRANSFORM 
		//	for (i=0; i<g_N; ++i)
		//		fftbuf[i] *= g_hanning[i];
		//				
		
		// Look at the real signal as an interleaved complex vector by casting it.
		// Then call the transformation function ctoz to get a split complex vector,
		// which for a real signal, divides into an even-odd configuration.
		ctoz ((COMPLEX *) fftbuf, 2, &unit->m_vA, 1, unit->m_Nover2);
		
		// Carry out a Forward FFT transform
		fft_zrip(unit->m_vsetup, &unit->m_vA, 1, unit->m_vlog2n, FFT_FORWARD);
		
		//correct for scaling error in ALTIVEC
		//float scale = (float)1.0/(2*n);
		//vsmul( A.realp, 1, &scale, A.realp, 1, nOver2 );
		//vsmul( A.imagp, 1, &scale, A.imagp, 1, nOver2 );
		
		// The output signal is now in a split real form, ie two arrays for real and imag.  Use the function
		// ztoc to get a real vector, in format [dc,nyq, bin1realm bin1imag, bin2real, bin2imag, ....] etc
		ztoc ( &unit->m_vA, 1, (COMPLEX *) fftbuf, 2, unit->m_Nover2);
		
		//will probably want to store phase first 
		
		// Squared Absolute so get power
		//for (i=0; i<g_N; i+=2)
		//		//i>>1 is i/2 
		//		fftbuf[i>>1] = (fftbuf[i] * fftbuf[i]) + (fftbuf[i+1] * fftbuf[i+1]);
		//	
		
		//amortise state changes:
		
		///////////////////////////////////////////////////////////////
		//constant Q conversion, only need magnitudes
		int qtodo= unit->m_qbands;
		
		float * qfreqs= unit->m_qfreqs;
		int * startindex= unit->m_startindex;
		int * numindices= unit->m_numindices;
		float ** speckernelvals= unit->m_speckernelvals ;
		
		float * qmags = unit->m_qmags;
		
		//int cumul=0;
		
		float magtotal=0.0;
		
		//printf("here 2 %p %p %p \n",speckernelvals, speckernelvals[0], speckernelvals[0]-6);
		
		for (i=0; i<qtodo; ++i) {
			
			float realsum=0.0;
			float imagsum=0.0;
			
			int start= startindex[i];
			int end=start+numindices[i];
			
			float * readbase= speckernelvals[i]-start; //+(unit->m_cumulindices[i])-start;
			
			//printf("%d %p %p %p \n",i, speckernelvals[i], speckernelvals[i]-start, readbase);
			
			for (j=start; j<end; ++j) {
				float mult= readbase[j]; 
				realsum+= mult*fftbuf[2*j];
				imagsum+= mult*fftbuf[2*j+1];
			}
			
			//scale here by 1/(2*g_N)
			
			//sclaing unecessary
			//realsum*=unit->m_fftscale;
			//imagsum*=unit->m_fftscale;
			
			qmags[i]= realsum*realsum+imagsum*imagsum; 
			magtotal+=qmags[i];
			//if(i>70) printf("%d %f   ",i,qmags[i]);
			
		}
		//printf("\n");
		
		/////////////////////////////////////////////////////////
		
		float * topten= unit->m_topten; 
		int*  toptenindices= unit->m_toptenindices;
		
		for (i=0;i<10;++i) {
			topten[i]=-1000.0;
			toptenindices[i]=0;
		}
		
		float * pamps= unit->m_amps;
		
		unit->m_hasfreq=1; //could turn off if too close to call...won't bother for now
		
		//pitch detection by cross correlation, only check roots up to 2000 or so, also don't need guard element then! 
		
		for (i=unit->m_minqband; i<unit->m_maxqband; ++i) {
			
			float sum=0.0;
			for (j=0; j<11; ++j) {
				sum+= pamps[j]*qmags[i+g_sieve[j]];
			}
			
			if(sum>topten[9]) {
				
				//where does it rate
				for (k=0; k<10; ++k) {
					if(sum>topten[k]) break;
				}
				
				//copy all below down one
				for (j=9; j>k; --j) {
					topten[j]=topten[j-1];
					toptenindices[j]=toptenindices[j-1];
				}
				
				//insertion at i
				topten[k]=sum;
				toptenindices[k]=i;
			}
			
		}
		
		
		//	for (i=0;i<10;++i)
		//		unit->m_topten[i]=-1000;
		//		
		
		//printf("pitch %f \n",qfreqs[maxindex]);
		
		
		
		//////////////////////////////////////////////////////////INSTANTANEOUS FREQUENCY TRACK
		
		float * lastfreqs= unit->m_lastfreqs;
		float * currfreqs= unit->m_currfreqs;
		
		float * freqbuf= unit->m_freqbuf;
		
		for(i=0;i<10;++i) {
			
			k= (int)((qfreqs[toptenindices[i]]/unit->m_freqperbin)+0.5);
			
			currfreqs[i]= instantaneousfrequency(unit, fftbuf, k);
			
			//copy to buffer
			if(freqbuf) freqbuf[i]=currfreqs[i]; 
			
			//printf("%d freq %f \n",i,freq);
		}			
		
		//test for best estimate to see if consistent
		//score it by current and previous top ten
		
		float freq= currfreqs[0];
		
		float score=0.0;
		
		float dist;
		
		for(i=1;i<10;++i) {
			
			float other= currfreqs[i];
			
			//score is higher if closer
			if(other<freq)
				dist= other/freq;
			else
				dist= freq/other;
			
			score+= 10*dist;
		}
		
		for(i=0;i<10;++i) {
			
			float other= lastfreqs[i];
			
			//score is higher if closer
			if(other<freq)
				dist= other/freq;
			else
				dist= freq/other;
			
			score+= 10*dist;
		}
		
		//printf("score %f \n", score);
		
		float scorethresh = ZIN0(7);
		
		//check no dodgy answers
		if((score<scorethresh) || (freq<unit->m_minfreq) || (freq>unit->m_maxfreq)) {unit->m_hasfreq=0;}
		else
			unit->m_currfreq= freq;
		
		freqbuf[10]=unit->m_currfreq; 
		freqbuf[11]=score; 
		
		
		//update stored
		
		for (i=0;i<10;++i)
			lastfreqs[i]=currfreqs[i];
		
		
	}	else {unit->m_hasfreq=0;}	
}	



float instantaneousfrequency(Citch * unit, float * fftbuf, int k) {
	
	//printf("check k %f %f %f %d \n",qfreqs[maxindex],unit->m_freqperbin,(qfreqs[maxindex]/unit->m_freqperbin)+0.5,k);
	
	//instantaneous frequency correction
	float Xhkreal, Xhkimag, Xhk2real, Xhk2imag; 
	
	Xhkreal=0.5*((fftbuf[2*k])-(0.5*fftbuf[2*(k+1)])-(0.5*fftbuf[2*(k-1)]));
	Xhkimag=0.5*((fftbuf[2*k+1])-(0.5*fftbuf[2*(k+1)+1])-(0.5*fftbuf[2*(k-1)+1]));
	
	float calc= (unit->m_twopioverN)*k;
	float areal= cos(calc);
	float aimag= sin(calc);
	
	float breal= unit->realb;
	float bimag= unit->imagb;
	
	float tmpreal= fftbuf[2*k] - (0.5*((breal*fftbuf[2*(k+1)]) - (bimag*fftbuf[2*(k+1)+1]))) - (0.5*((breal*fftbuf[2*(k-1)]) + (bimag*fftbuf[2*(k-1)+1])));
	float tmpimag= fftbuf[2*k+1] - (0.5*((breal*fftbuf[2*(k+1)+1]) + (bimag*fftbuf[2*(k+1)]))) - (0.5*((breal*fftbuf[2*(k-1)+1]) - (bimag*fftbuf[2*(k-1)])));
	
	Xhk2real= 0.5*(areal*tmpreal- aimag*tmpimag);
	Xhk2imag= 0.5*(areal*tmpimag+ aimag*tmpreal);
	
	//float Xhk2= 0.5*exp(j*2*pi*k/F.N)*(F.data(k,ii)- (0.5*exp(j*2*pi/F.N)*F.data(k+1,ii)) - (0.5*exp(-j*2*pi/F.N)*F.data(k-1,ii)));
	
	float theta2= atan(Xhk2imag/Xhk2real);
	float theta= atan(Xhkimag/Xhkreal);
	
	float freq= ((float)unit->m_SR)*(fabs(theta2-theta))/(TWOPI);
	
	//printf("do you believe freq? %d max %f min %f result %f\n",k,unit->m_maxfreq, unit->m_minfreq, freq);
	return freq;
	
}



void load(InterfaceTable *inTable)
{
	
	ft= inTable;
	
	//printf("Citch by Nick Collins (www.sicklincoln.org) \n based on algorithms published by Judith Brown and Miller Puckette\n");
	
	//can't confirm here, confirm when run UGen instance
	g_SR=44100; 
	g_Nyquist=22050;  
	
	g_N= 4096;
	g_Nover2=2048;
	g_overlap=3072; 
	g_overlapindex=1024; 
	g_framespersec= (float)g_overlap/g_SR;
	g_freqperbin= (float)g_SR/(float)g_N;
	
	g_log2N = (int)(log2(g_N)+0.5); 
	
	//correct for Altivec only, o/w take out the factor of 1/2
	g_fftscale= 1.0/(2.0*g_N);
	
	//prepareQ(inTable);
	
	//prepareHanningWindow();
	
	DefineDtorCantAliasUnit(Citch);
}



