#include <stdio.h>
#include <math.h>
#include <list>


//http://stackoverflow.com/questions/101439/the-most-efficient-way-to-implement-an-integer-based-power-function-powint-int
int ipow(int base, int exp)
{
    int result = 1;
    while (exp)
    {
        if (exp & 1)
            result *= base;
        exp >>= 1;
        base *= base;
    }
	
    return result;
}


//start again
int g_numoutput; 
int g_duplicate; 



void checkifrepresentative(int * values, int numvalues, int p, int numchordtypes, int numpossiblechords); 
int outputifpasses(int *data, int numvalues, int p, int numchordtypes); 	
void bruteforceenumeration(int length, int p, int numchordtypes); 


int main (int argc, const char * argv[]) {
	
	g_numoutput = 0; 
	g_duplicate = 0; 
	
	bruteforceenumeration(3, 12, 2); //gives correct 296 answer
	
	//bruteforceenumeration(4, 2, 3); 
	
	//bruteforceenumeration(6, 6, 3); 
	
	//bruteforceenumeration(4, 3, 2); 
	
	//bruteforceenumeration(4, 3, 2); 
	
	//bruteforceenumeration(4, 7, 3); 
	
	//bruteforceenumeration(6, 7, 3); 
	
	//long long test= 5; 
	//long other = 6; 
	
	//printf("test %d other %d\n", sizeof(test), sizeof(other));

	
	printf("numoutput %d duplicate %d\n", g_numoutput, g_duplicate);

}



//length of sequence passed in 

//assumes no interaction between chord types and transpositions, ie all chord are distinct at all transpositions
void bruteforceenumeration(int length, int p, int numchordtypes) {

	int *value = new int[length];
	
	//check all possible assignments of transposition and chord types
	
	long numpossiblechords = p*numchordtypes; 
	
	long totalpossibilities = ipow(numpossiblechords,length-1);  
	long i, j, k; 
	long temp, temp2; 
	
	
	printf("numpos %d\n", (int)totalpossibilities); 
	
	//can have any chord type at position 0, but no need to worry about transpositions there 
	for (i=0; i<numchordtypes; ++i) {
	
		printf("here on initial chord type %d\n", i); 
		
		value[0] = i; 
		
		for (j=0; j<totalpossibilities; ++j) {
	
			if (j%10000==0)
				printf("here on possible j %d\n", j); 
			
			temp= j; 
			
			//int valid=1; 
			
			for (k=1; k<length; ++k) {
			
				temp2 = temp%numpossiblechords; 
				
				temp = temp/numpossiblechords; 
				
				//hard coded self transposing augmented chord checks
				//if((temp2>=9) && (temp2%2==1))
				//	valid=0; 
				
				value[k] = temp2; 
				
			}
			
	//		if ((j>9000)&& (j<9100)) {
//			
//				printf ("j %d \n",j);
//				for (int jj=0; jj<length; ++jj) 
//					printf("%d \t",value[jj]);
//				printf ("\n");
//				
//			}
			
			//if (valid==1)
			//test value
				checkifrepresentative(value,length, p, numchordtypes, numpossiblechords);
		}
	
	}
	
	delete [] value; 
	
}







void checkifrepresentative(int * values, int numvalues, int p, int numchordtypes, int numpossiblechords) {
	
	int j,k; 
	
	int canonical = true; 
	int test, against; 
	
	//if canonical, has min code 
	//try all transpositions, rotations
	//as soon as find one wrong, can return
	
	//pure transpositions will never improve codes since first column must be a chord type already at transposition 0
	for (j=1; j<numvalues; ++j) {
		
		int start = numvalues-j; 
		int critical = values[start]; //this value will go to column 0, so must go to 0 or 1 under transposition
		
		//for (int transpostest=0; transpostest<p; ++transpostest) {
		//int transposition= numchordtypes*transpostest; 	
		
		
		//check one at a time stepping through where would wrap around to column 0, then column 1, etc
		int transposition = numchordtypes*((p- (critical/numchordtypes))%p); 
		
			
		int stillgoing= true; 
		k=0; 
		while (stillgoing && (k<numvalues)) {
			test = (values[(start+k)%numvalues]+transposition)%numpossiblechords; 
			
			//reduce self-transposing to early codes
			//if((test>=9) && (test%2==1))
			//	test = 2*((test/2)%4)+1; 
			
			against = values[k]; 
			
			if (test<against) {stillgoing = false; canonical = false;} 
			
			if (test>against) {stillgoing = false; }
			
			++k;
		}
		
		
		//}
		
//		if ((k==numvalues) && (test==against)) {
//			
//			for (int jj=0; jj<numvalues; ++jj) 
//				printf("%d \t",values[jj]);
//			printf("odd? element %d transposition %d test %d against %d \n",j, transposition, test, against);
//			
//			
//			++g_duplicate ;
//		}
		
		if(canonical == false) break; 
		
	}
	
	//would be more cases for dihedral group looking at reverse order on rotations too
	
	if (canonical) {
		
		outputifpasses(values, numvalues, p, numchordtypes); 
		
	}
	
	
}





int outputifpasses(int *data, int numvalues, int p, int numchordtypes) {
	
	int i; 
	
	//condition; no repeated transpositions
	
	int pass = true; 
	
	int lastval = data[0]/numchordtypes; 
	
	for (i=1; i<=numvalues; ++i) {
	
		int valnow = data[i%numvalues]/numchordtypes; 
		
		if (valnow==lastval) {
			
			pass= false; 
			break;
		}
			
		lastval = valnow; 
		
	}
	
	if (pass) {
		
		//printf("chord %d: ", g_numoutput); 
		
//		for (i=0; i<numvalues; ++i) {
//			
//			int valnow = data[i]; 
//			
//			//printf("transposition %d type %d ",valnow/numchordtypes,valnow%numchordtypes); //?"minor":"major"
//			//printf("%d %d ",valnow/numchordtypes,valnow%numchordtypes); //?"minor":"major"
//			printf("%d ",valnow); //?"minor":"major"
//			
//		}
//		printf(" ---> ");
//		for (i=0; i<numvalues; ++i) {
//			
//			int valnow = data[i]; 
//			
//			//printf("transposition %d type %d ",valnow/numchordtypes,valnow%numchordtypes); //?"minor":"major"
//			printf("%d %d ",valnow/numchordtypes,valnow%numchordtypes); //?"minor":"major"
//			//printf("%d ",valnow); //?"minor":"major"
//			
//		}
//		printf("\n"); 
		
		
		
		++g_numoutput; 
		
		
		return 1; 
	}
	
	return 0; 
}








