#python implementation of counting of orbits
#nice language cheat sheets http://www.astro.ufl.edu/~warner/prog/python.html
#http://www.cs.caltech.edu/courses/cs11/material/python/misc/python_idioms.html

#python allows arbitrary size integers natively, which is just what we need here. 

length=3 #50	#length of sequence
n=12 #19	#number of transposition levels
q=2 #3	#number of distinct chord types, assumed that they are different in all transpositions
m = q*n	#if no self-transposing chords
#24+4 #test of major, minor and four augmented self-transposing chords q*n

a = [None]*(length+2)
b = [None]*(length+2)

types = q #1 #either num chord types available, or just 1 if only excluding repetition of exact same chord

twotypes = 2*types

#different initial conditions
b[1]= m
b[2] = m*(m-types) 
b[3] = m*(m-types)*(m-twotypes)

#situation where chord after the set to be chosen is DIFFERENT to the first chord in the set, i.e., wrap to something other than first
a[1]= m-types
a[2] = m*(m-twotypes) 
#a[3] = m*(m-types)*(m-twotypes)
a[3] = (m*q*(m-q)) + (m*(m-twotypes)*(m-twotypes)); #((m-twotypes)*(a[2])) + (types*(m-types)*(a[1]))


if(length>3):
	for i in range(4,length+1):
		b[i] = ((m-twotypes)*(b[i-1])) + (types*(m-types)*(b[i-2]))
		a[i] = ((m-twotypes)*(a[i-1])) + (types*(m-types)*(a[i-2]))
			
print b
	
	
#gives length of orbit
orders = [None]*(length)

for j in range(length):
	ordernow = None
	for k in range(length):
		if ordernow==None:
			temp= (k+1)*j 
			if (temp%length)==0:
				ordernow = (k+1)
	orders[j] = ordernow		


numorbits = map(lambda x: length/x, orders)
	
indices = [None]*(length)

testi = range(n) 

for j in range(length):
	ordernow= orders[j]
	indices[j] = filter(lambda i: (ordernow*i)%n==0, testi)	
	
print numorbits
print indices

sum = 0

for index, orbj in enumerate(numorbits):
	print orbj, indices[index]
	for i in indices[index]:
		#print sum
		if orbj==1:
			if i!=0: 
				sum = sum + m
		else:
			if i>0: 
				sum = sum + (a[orbj])
			else:
				sum=sum+(b[orbj])
	
			#sum = sum + b[orbj]
		print sum
	 
#if modulo off, evidence of cock up in counting	 
print 'count of orbits', sum, length*n, sum/(length*n), sum%(length*n)



