SCryptogram {
	
	var w, letterbox, textbox; 
	var littlefont, bigfont; 
	var names; 
	var cumulstring; 
	var jmcsynth; 
	var group, mastersynth; 
	var imagefilters; 
	
	*new {
		
	^super.new.initSCryptogram;	
	}	
	
	
	
	initSCryptogram {
		
		//JMC will get special treatment; rest are from some algorithmic routine
		
		names = [
		"Jan Trtzschler von Falkenstein"]
		++([
		"Tom Hall",
		"Fredrik Olofsson",
		"Julian Rohrhuber",
		"Marije Baalman",
		"Scott Wilson",
		"Neil Cosgrove",
		"Thor Magnusson",
		"Chris Kiefer",
		"Christopher Frauenberger",
		"Andrea Valle",
		"Takeko Akamatsu",
		"Alberto de Campo",
		"John Eacott",
		"Tim Blechmann",
		"Josh Parmenter",
		"Dan Stowell",
		"Fabrice Mogini",
		"Lucas Samaruga",
		"Jonatan Liljedahl",
		"Jakob Leden",
		"Hanns Holger Rutz",
		"Miguel Negrao",
		"Paul Miller",
		"Andre Bartetzki ",
		"Chris Jeffs",
		"Phil Jones",
		"Jerome Covington",
		"Bernardo Barros",
		"Sergio Luque",
		"James Harkins",
		"Julio d'Escrivan",
		"Lawrence Crow",
		"Martin Stepanek",
		"Adam Sanches",
		"Stelios Manousakis",
		"Chris Sattinger",
		"Till Bovermann",
		"David Cottle",
		"Stefan Nussbaumer",
		"Pikku Yokoi",
		"Uri Sala",
		"Brad Garton",
		"Blackrain",
		"Ronni Montoya",
		"PyoungRyang Ko",
		"Sylvain Le Beux",
		"isjtar",
		"Sakari Matikka",
		"Ricardo Gabriel Herdt",
		"e deleflie",
		"Florian Hanisch",
		"Daniel Palkowski",
		"Christoph Kummerer",
		"aucotsi",
		"Jonathan Segel",
		"Mileece",
		"Wouter Snoei",
		"Yvan Volochine",
		"Chad McKinney",
		"Axel Balley",
		"Taylan Cihan",
		"Ronald Kuivila",
		"Batuhan Bozkurt",
		"Iannis Zannos",
		"Stefan Kersten ",
		"Ross Bencina",
		"Marinos Koutsomichalis",
		"Simon Blackmore",
		"Daniel Mayer",
		"Samuel Potter",
		"Jae Ho YOUN",
		"Jascha Narveson",
		"Vincent Rioux",
		"Tim Walters",
		"Stephan Wittwer",
		"Nathaniel Virgo",
		"Pierre Alexandre Tremblay",
		"Martin Vognsen",
		"Clifford Dunn",
		"Andrew Grathwohl",
		"Scott Worthington",
		"Paul Jones",
		"mr.proxxxy",
		"Bjorn Westergard",
		"Farah Hatam",
		"Mr.SpOOn",
		"Guilherme Lunhani",
		"Click Nilson"].scramble)
		++[
		"James McCartney"];	
		
		
		jmcsynth= [
		{Impulse.ar([Line.kr(100,1,0.2),XLine.kr(100,1,0.2)])*Line.kr(1,1,0.4,doneAction:2)},
		{SinOsc.ar([440,440],0,0.3)*Line.kr(1,0,0.4,doneAction:2)},
		{MantissaMask.ar(LFSaw.ar([440,441]),Line.kr(23,0,0.5))*Line.kr(1,0,0.4,doneAction:2)},
		{LFNoise0.ar([130,140])*Line.kr(1,0,0.4,doneAction:2)},
		{WhiteNoise.ar([0.1,0.08])**Line.kr(1,0,0.4,doneAction:2)},
		//mccartney
		{Silent.ar*Line.kr(1,1,0.4,doneAction:2)},
		{MantissaMask.ar(LFNoise0.ar([1000,1001]),Line.kr(23,0,0.5))*Line.kr(1,0,0.4,doneAction:2)},
		{CombN.ar(PinkNoise.ar*Line.kr(1,0,0.4),0.1,[0.1,0.05],10)*EnvGen.kr(Env([0.2,0.2,0.0],[0.7,0.1]),doneAction:2)},
		{CombC.ar(PinkNoise.ar,0.01,[0.01,0.009],10)*EnvGen.kr(Env([0.0,0.5,0.0],[0.4,0.05]),doneAction:2)},
		{SinOsc.ar(440,0,0.3)*Line.kr([0,1],[1,0],0.4,doneAction:2)},
		{Ringz.ar(BrownNoise.ar(0.05),Line.kr(440,[44,45],0.5),0.7)*Line.kr(1,0,0.8,doneAction:2)},
		{TwoPole.ar(GrayNoise.ar,[2000,1000],0.1)*Line.kr(1,1,0.4,doneAction:2)},
		{Saw.ar(XLine.kr([10,20],2000,0.6))*Line.kr(1,1,0.4,doneAction:2)},
		{Impulse.ar([10,11])*Line.kr(1,1,0.4,doneAction:2)},
		{Pulse.ar(Line.kr([100,105],1),0.5).round(0.125)*Line.kr(1,1,0.4,doneAction:2)}
		]; 
		
		
		Server.default.waitForBoot({
		
		this.gui; 
		
		{
		this.initSynthDefs;
		
		Server.default.sync; 
		
		this.play; 
		
		}.fork;
		
		}); 
	}
	
	
	
	updatename {|letter| 
		
		{
			
			cumulstring = cumulstring++letter; 
			letterbox.string_(cumulstring);
				
			textbox.string_(letter);
		
		}.defer; 			
		
		
	}
	
	
	removename {|letter| 
		
		{
			
			cumulstring = cumulstring.copyRange(0,cumulstring.size-2); 
			letterbox.string_(cumulstring);
				
			textbox.string_(letter);
		
		}.defer; 			
		
		
	}
	
	
	getchordtones { arg name;
		var output; 
		
		output= List[]; 
		
		name.do{|letter,j|
					var code; 
					
					code = letter.ascii; 
										
					if((code>=65) && (code<=91),{code = code + 32;});

					if((code>=97) && (code<=122),{
					//synthesis reaction 
						
						output.add( code - 97 );
					})
					};
					
		//remove duplicates			
		^output.asSet.asArray.postln; 			
	
	} 
			
	
	
	//assumes booted
	play {
		
		var routine; 
		var imagefilterchance = #[0.8,0.5,0.5,0.9,0.4]; 
		var temp; 
		
		group = Group.basicNew(Server.default,1); 
		
		mastersynth = Synth.tail(group, \scryptogrammaster); 
		
		routine = {
			
			//start dark; 
			{
				
			letterbox.string_("scryptogram");
			textbox.string_(" ");
			
			imagefilters[4].enable_(true);
			
			imagefilters[4].brightness_(-1);
			imagefilters[4].contrast_(0.25);
			imagefilters[4].saturation_(0.0);
			
			 //w.refresh; 
			 w.view.refreshInRect(Rect(0,0,1024,768)); 
			}.defer; 
					
			2.0.wait; 
			
			
			
			
			names.do{|name,i|
			var code, capital; 
			var pitchoffset; 
			var filtering; 
			var baseamp, modamount, coef;
			var decay, panstrategy, dur;
			var timestrategy,baseioi, lurchioi;    
			//variations for each name
			var lettercount=0; 
			var tuberun= 0; 
			var addchord,chordtones, chordenv, chordoctave, chordamp; 
			//var chordcounter; 
			
			filtering = (i%10)*0.1;
			
			if(i%10==0,{tuberun= 2.rand; 
				
			if (tuberun==0) {mastersynth.set(\ntubemix,0.0);
				
			}; 	
			}); 
			
			
			addchord = 0.3.coin; 
			//chordcounter= 0; 
			chordtones= this.getchordtones(name); 
			chordoctave = [24,36,48,60].choose; 
			chordamp= rrand(0.1,0.25); 
			
			
			baseamp = rrand(0.1,0.5); 
			modamount= [0,rrand(0.0,0.1),exprand(0.01,0.9)].choose; 
			pitchoffset = [0,-1,1,-2,2].wchoose([0.7,0.13,0.13,0.02,0.02]);
			coef= rrand(-0.9,0.9); 
			decay = [rrand(0.5,2.0),exprand(1.5,25.0)].choose; 
			panstrategy= 2.rand;  
			dur= [rrand(0.1,1.0),rrand(0.4,5.0)].choose; 
			timestrategy = 4.rand; //0 = straight, 1= lurch, 2= followprop 
			baseioi = [0.2,rrand(0.1,0.3),exprand(0.05,0.5)].choose; 
			lurchioi= baseioi*(rrand(1.05,1.7)); 
			
			cumulstring = ""; //clear ready for adding letters
			
			
			//change font? 
			
			
			
			
			
			
			if (i==45,{
			
			//dark; 
			{
				
			imagefilters[4].enable_(true);
			
			imagefilters[4].brightness_(-1);
			imagefilters[4].contrast_(0.25);
			imagefilters[4].saturation_(0.0);
			
			 //w.refresh; 
			 w.view.refreshInRect(Rect(0,0,1024,768)); 
			}.defer; 
					
			0.5.wait; 
				
			temp = Synth(\default,[\freq,60.midicps,\amp,0.3]);	
				
			//Richard Boulanger special case
			"richard boulanger".do{|letter,j|
					
					this.updatename(letter); //updates GUI
					
					0.1.wait; 
				};	
				
				0.2.wait; 
				
			"richard boulanger".reverse.do{|letter,j|
					
					this.removename(letter); //updates GUI
					
					0.1.wait; 
				};		
		
			
			temp.set(\gate,0); 
			
			cumulstring = ""; //clear ready for adding letters
			
			this.updatename(" "); //clears GUI
					
			cumulstring = ""; //clear ready for adding letters
			
			0.5.wait; 
					
			}); 
			
			
			
			
			
			//change backdrop
			//\CIZoomBlur,\CIColorPosterize, \CIPixellate
			
			{
				
			imagefilters.do{arg filt,j; filt.enable_((imagefilterchance[j]).coin); };
			
			imagefilters[0].center_([rrand(0,1023),rrand(0,767)]);
			imagefilters[0].amount_(rrand(0,200));
			
			imagefilters[1].levels_(rrand(2,30));
			
			imagefilters[2].center_([rrand(0,1023),rrand(0,767)]);
			imagefilters[2].scale(rrand(1,100));
			 
			imagefilters[3].radius_(rrand(0,600));
			imagefilters[3].scale_(rrand(-1.0,1.0));
			imagefilters[3].center_([rrand(0,1023),rrand(0,767)]);
			  
			imagefilters[4].contrast_([1,rrand(0.25,4)].choose);
			imagefilters[4].brightness_([0,rrand(-0.5,0.5)].choose);
			imagefilters[4].saturation_([1,rrand(0.0,2.0)].choose);
			
			
			 
			 //w.refresh; 
			 w.view.refreshInRect(Rect(0,0,1024,768)); 
			}.defer; 
			
			0.1.wait; 
			
			
			
			
			//change effects
			
			
			if(0.1.coin,{
				mastersynth.set(\ntubemix,if (tuberun==0, 0.0,[rrand(0.0,0.05,exprand(0.01,0.1))].choose),\reverbmix, rrand(0.0,0.4));
				},{
			
			mastersynth.set(\ntubemix,if(tuberun==0, 0.0,(1.0-filtering)*0.1),\reverbmix,(1.0-filtering)*0.4);
			
				
			}); 
			
			
			
			if (i==(names.size-1),
			
			{
			
			//make sure font color is red for close? 
			
			{
			imagefilters.do{arg filt; filt.enable_(false); };
			
			 w.refresh; 
			}.defer; 
			
			0.1.wait; 

			
			
			mastersynth.set(\ntubemix,0.0,\reverbmix,0.2);
		
			//JMC special case	
			
			0.8.wait; 
			
				name.do{|letter,j|
					
					this.updatename(letter); //updates GUI
					
					//look up sounds in dictionary
					jmcsynth[j].play; 
					
					1.0.wait; 
				}	
				
			},
			
			{
				
				
				if(addchord,{
						
						chordtones = chordtones.scramble.copyRange(0,rrand(1,chordtones.size-1)); 
						
						temp = name.size*baseioi; 
						chordenv= ([[0.5,0.0,0.5],[0.01,0.98,0.01],[0.1,0.0,0.9],[0.9,0,0.1],[0.3,0.4,0.3],[0.05,0.45,0.5]].choose)*temp; 
						
						//chordenv.postln;
						//chordtones.postln;
						chordamp = (chordtones.size.reciprocal)*chordamp;
						
						chordtones.do{|tone|  Synth.head(group, \scryptogram2,[\freq,(((tone/26.0)*12.0)+chordoctave+([-12,0,12].choose)).midicps,\amp,chordamp*exprand(0.8,1.0),\mod,modamount, \filt, filtering.max(1.0.rand),\pan, rrand(-0.5,0.5), \attacktime, chordenv[0], \sustaintime, chordenv[1], \decaytime, chordenv[2]]); 
						}; 
						
					});
				
				name.do{|letter,j|
					var ampnow = baseamp*(rrand(0.9,1.1)); 
					var prop; 
					var ioi; 
					var freqnow; 
					
					ioi= baseioi; 
					this.updatename(letter); //updates GUI
					
					code = letter.ascii; 
					capital = 0; 
					
			
					
					
					if((code>=65) && (code<=91),{code = code + 32; capital=1; });

					if((code>=97) && (code<=122),{
					//synthesis reaction 
						
						code = code - 97; 
						
						prop = code/26.0;
						
						ioi= switch(timestrategy,0,{baseioi},1,{if(lettercount%2==0,baseioi, lurchioi); },2,{baseioi*prop;},3,{baseioi*(1.0-prop)}); 
						
						
						code = (prop*12.0)+60.05;
						
						if(capital==1,{code  = code + (rrand(-2,2)*12);  if(0.5.coin,{ampnow*rrand(1.2,1.7)})});
						
						code = code + (pitchoffset*12);
						
						freqnow = code.midicps; 
						
						 Synth.head(group, \scryptogram1,[\freq,freqnow,\amp,ampnow,\mod,modamount*freqnow, \coef, coef, \filt, filtering,\decay, decay, \pan, if(panstrategy==1,rrand(-0.1,0.1),2.0*prop-1.0), \dur, dur]); 
						//(code-97).postln
						
						lettercount = lettercount+1; 
						
						});
					
					//later speed depends on i, with base rate + noise both dependent on i,
					//and modulations from letters, reset to new scrambled codebook once in a while
					ioi.wait; 
				}	
				
				
			}); 
			
			rrand(0.75,1.25).wait;  //lingers
				
			};
			
		
		0.5.wait;	
		//very end
		{
			letterbox.string_("scryptogram complete");
			textbox.string_(" ");
		}.defer; 	
			
		2.0.wait; 
		
		//very end
		{
			letterbox.string_(" ");
			textbox.string_(" ");
		}.defer; 	
		
		//suicide?
		//s.quit; 	
			
		}.fork(TempoClock(1)); 
		
		
		^routine;
		
	}
	
	
	initSynthDefs {|numChannels=2|
		
		
		//var numChannels = 2; 
		
		SynthDef(\scryptogram1,{|freq=440 amp= 0.1 dur= 0.5 mod= 0.0 filt= 0.0 coef=0.2 decay= (-2) pan=0.0|
			
			var sound; 
			var excitation; 
			var env; 
			
			excitation = GrayNoise.ar*(Line.kr(1,0,0.1).squared);
			//excitation = Crackle.ar(1.9)*(Line.kr(1,0,0.1).squared);
			
			sound = Pluck.ar(excitation,Impulse.ar(0.01),0.05,(freq.max(20)+(mod*SinOsc.ar(7))).reciprocal,decay,coef); 
			
			env = EnvGen.ar(Env([0,1,1,0],[0.005,dur,0.1]),doneAction:2);
			
			sound= LPF.ar(sound, ((filt.squared)*15000)+1000);
			
			Out.ar(0,PanAz.ar(numChannels, sound*env*amp, pan));
			
		}).add; 
		
		
		//for occasional chord tones, stereo only
		
	SynthDef(\scryptogram2,{|freq=440 amp= 0.1 attacktime= 0.5 sustaintime= 0.0 decaytime= 0.5 mod= 0.0 filt= 1.0 pan=0.0|
			
			var sound;  
			var env; 
			var minus, plus; 
			
			minus= 1.0-(0.05*mod); 
			plus = minus.reciprocal; 
		
			sound = Mix(LFPar.ar(freq*([Rand(minus,plus),Rand(minus,plus)])));			
			env = EnvGen.ar(Env([0,1,1,0],[attacktime,sustaintime,decaytime]),doneAction:2);
			
			sound= LPF.ar(sound, ((filt.squared)*15000)+1000);
			
			//Mix(sound) 
			Out.ar(0, PanAz.ar(numChannels,sound*env,pan));
			
		}).add; 
		
		
		SynthDef(\scryptogrammaster,{arg ntubemix=0.0, reverbmix= 0.3; 
			var input; 
			
			input= In.ar(0,numChannels);
			
			input = input + (PanAz.ar(numChannels,(ntubemix.lag(0.1))*10.0*GVerb.ar(Mix(input),10,4),0.0)); 
			
			//removed NTube as want it to work on vanilla SC
			//input = input + (ntubemix.lag(0.1)*0.1*NTube.ar(input, 0.95,`[ 0.97769033908844, 0.055854916572571, 0.13120985031128, 0.72535228729248, 0.068947672843933, 0.60611248016357, 0.39148533344269, 0.73454916477203, 0.9549446105957 ], `[ 0.10148895382881, 0.11503208875656, 0.12339292764664, 0.16480521559715, 0.075598913431168, 0.10120233297348, 0.18820816874504, 0.099583280086517, 0.077866721153259, 0.088631677627563 ]));
			
			input = FreeVerb.ar(input, reverbmix.lag(0.1), 0.7); 
			
			//doesn't multi-channel expand properly 
			//if(CheckBadValues.ar(input)==0,input,Silent.ar)
			
			ReplaceOut.ar(0, Limiter.ar(input,0.99,0.01))
		}).add; 
		
	}
	
	
	
	
	gui {  
		var color = Color.white; //Color.yellow(0.85,0.7); // Color.black; 
		var textcolor = Color.red; //Color.green(0.5); 
		var image;
		
			image = SCImage(SCryptogram.filenameSymbol.asString.dirname++"/SCryptogram2.jpg"); 
		
			image.accelerated_(true); 
		
			imagefilters = [\CIZoomBlur,\CIColorPosterize, \CIPixellate, \CIBumpDistortion, \CIColorControls].collect({arg filtertype,i; SCImageFilter(filtertype) }); 
			
			
			imagefilters.do{|filt| image.addFilter(filt); }; 
		
		//
		//font= Font("Arial",16);  	 
		//littlefont = Font("Helvetica",36);  
		//bigfont = Font("Helvetica",170);  
		  
	//	font= Font("Transponder AOE",16);  	 
//		littlefont = Font("Transponder AOE",36);  
//		bigfont = Font("Transponder AOE",170);   
//		 
		//littlefont= Font("DS-Digital",60);   
		//bigfont = Font("DS-Digital",400);   
		littlefont= Font("Monaco",50);   
		bigfont = Font("Monaco",400);   
		  
		w = image.plotNoBorder("SCryptogram", Rect(0,100,1024,768), showInfo:false); 
		  
		//w.border= false; 
		  
		//from SCWindow help file  
		//w = Window("SCryptogram", Rect(0,100,1024,768), border: false);  
		  
		//w.view.background_(Color.green(0.5));  
		//w.view.background_(Color.white); 
		  
		w.onClose_({ image.free }); // free the image when the window is closed
		//w.view.backgroundImage_(image, 1,1.0, Rect(0,0,1024,768) );
	  
		w.front;  
		  
		//assumes resolution of 1024 by 768   
		w.fullScreen;  
		  
		//Button(w, Rect(0,0,30,30)).states_([["Close Window"]]).action_({w.endFullScreen;w.close});  
		
		
		letterbox= StaticText(w,Rect(12,34,1000,150)).font_(littlefont).string_("full names").stringColor_(textcolor); 		
		textbox = StaticText(w,Rect(352,164,800,500)).font_(bigfont).string_("*!*").stringColor_(textcolor); 	
		
		
		
	}
	
	
}