//This file is part of MotherFuga. Copyright (C) 2004  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file MotherFuga.help

//MotherFuga 28/12/04  by N.M.Collins 

MotherFuga {
	var oscbuf;
	var task;
	
	*new {
		^super.new.initMotherFuga;
	}
	
	initMotherFuga {
		oscbuf = Buffer.alloc(Server.local, 512, 1);
		oscbuf.sine1(1.0/[1,2,3,4,5,6], true, true, true);
	}
	
	
	//factors to change- quantise, num voices, transforms of theme in development, quantise etc
	fugue {arg voices=4, quantchance=0.1, quantval=0.25, themelength=6.0, expos=1,develop=1, waitonlast=false, def=\motherfugasound, group, outbus=0;
		var harmony,melody, theme, counter,form, quant;
			
		harmony=MFHarmonyCreator.new;
		
		harmony.newTuning;
		
		melody=MFMelodyCreator.new.initMFMelodyCreator;

		theme=melody.makeTheme(themelength);
		
		counter=Array.fill(2*voices-1,{melody.makeCounterMelody(theme);});
				
		form=MFSectionCreator.new;
		
		form.newStructure(harmony,voices,themelength, expos,develop);
		
		quant=if(quantchance.coin,{quantval.value},0.0);
		
		task=Task({
		
		form.sections.do({arg val; val.playSection(harmony,form.registers,[theme]++counter,voices).playMelody(oscbuf,quant, waitonlast,def,group, outbus);});
		
		nil
		});
		
		task.play;
	}
	
	
	infinite {
		var filt, reverb, fxgroup, rootnode;
		
		rootnode=Group.basicNew(Server.local, 1);
		
		fxgroup= Group.tail(rootnode);
		
		filt=Synth.tail(fxgroup,\psychoadjust);

		reverb=Synth.tail(fxgroup,\mfreverb, [\wet, 0.02]);
		
		task=Task({
			
			inf.do({
				var harmony,melody, theme, counter,form, quant;
				var voices=4, quantchance=0.1, quantval=0.25, themelength=6.0,expos=1, develop=1;
				var waitonlast, def;
				
				def=[\motherfugasound,\motherfugasound2,\motherfugasound3,\motherfugasound4,\motherfugasound5].wchoose([0.8,0.1,0.05,0.03,0.02]);
				
				waitonlast=if(0.3.coin,true,false);
				
				voices=[rrand(3,5),rrand(6,20)].wchoose([0.6,0.4]);
				quantchance= 0.4;
				quantval=[0.25,0.5,1.0,0.333,1.0/rrand(2,13)].wchoose([0.4,0.2,0.05,0.05,0.3]);
				themelength=[rrand(5.0,7.0),rrand(3.0,9.0),rrand(17.0,15.0),rrand(1.0,3.0)].wchoose([0.6,0.3,0.05,0.05]);
				
				expos=[0,1].wchoose([0.2,0.8]);
				develop=[0,1].wchoose([0.3,0.7]);
					
				if(expos==0,{develop=1;});	
					
				harmony=MFHarmonyCreator.new;
				
				harmony.newTuning;
				
				melody=MFMelodyCreator.new.initMFMelodyCreator;
		
				theme=melody.makeTheme(themelength);
				
				counter=Array.fill(2*voices-1,{melody.makeCounterMelody(theme);});
						
				form=MFSectionCreator.new;
				
				form.newStructure(harmony,voices,themelength, expos,develop);
				
				quant=if(quantchance.coin,{quantval.value},0.0);
				
				form.sections.do({arg val; val.playSection(harmony,form.registers,[theme]++counter,voices).playMelody(oscbuf,quant, waitonlast,def, rootnode);});
					
				1.0.wait;	
								
				//change wavetable every run
				if(0.2.coin,{
				oscbuf.setn(0,Array.fill(512,{arg i; (i**1.13+rrand(1.0,50.0))%2.0-1.0}));
				},{
				oscbuf.sine1(1.0/[1,2,3,4,5,6], true, true, true);
				});
				
				//change reverb setting
				reverb.set(\wet,[0.0,rrand(0.0,0.1),exprand(0.01,0.5)].wchoose([0.02,0.9,0.08]));
				
				0.2.wait;
				
				
				
			});
			
		});
		
		task.play;

	
	}
	
	//write Synth Defs 
	*initClass {
	
		SynthDef(\motherfugasound, {arg out,bufnum,freq,dur,amp,pan; 
		var output;
		
		output= Osc.ar(bufnum, freq, 0, LFNoise0.kr(Rand(5.1,9.05),0.15,0.85)*amp)*(Line.kr(1.0,0.0,dur,doneAction:2)**2);
		
		output=LPF.ar(output,XLine.kr(15000,4000,dur*0.1));
		
		Out.ar(out,Pan2.ar(output,pan));//output.dup
		
		}).writeDefFile;
		
		//adapted from jmc's synthetic piano
		SynthDef(\motherfugasound5, {arg out,bufnum,freq,dur,amp,pan; 
			var delayTime, output, detune, strike, hammerEnv, hammer, lfo;
	
		strike = Impulse.ar(Rand(0.1,0.5), Rand(0,2pi), 0.1); // random period for each key
		hammerEnv = Decay2.ar(strike, 0.008, 0.04); // excitation envelope
		
		lfo=Osc.kr(bufnum, Rand(0.13,0.6),0, LFNoise0.kr(Rand(5.1,9.05),0.15,0.85)*amp*0.1,amp);
		
		// array of 3 strings per note
		output=	Mix(Array.fill(3, { arg i;
				// detune strings, calculate delay time :
				detune = #[-0.01, 0, 0.01].at(i);
				delayTime = 1 / (freq*(1+detune));
				// each string gets own exciter :
				hammer = LFNoise2.ar(3000, hammerEnv); // 3000 Hz was chosen by ear..
		
				CombL.ar(hammer,		// used as a string resonator
					delayTime, 		// max delay time
					delayTime,			// actual delay time
					6) 				// decay time of string
			}));
		
		Out.ar(out,Pan2.ar(lfo*output*EnvGen.ar(Env.perc(0.01,dur),doneAction:2),pan));//output.dup
		
		}).writeDefFile;
		
				
		
		
		SynthDef(\motherfugasound2, {arg out,bufnum,freq,dur,amp,pan; 
		var output;
		
		output= SinOsc.ar(SinOsc.ar(Rand(0.1,10.5),0,freq*0.01,freq),0,amp*(1+Rand(0.01,0.1))*Osc.kr(bufnum, Rand(0.13,0.6)))*(Line.kr(1.0,0.0,dur,doneAction:2)**2);
		
		output=LPF.ar(output,XLine.kr(15000,4000,dur*0.1));
		
		Out.ar(out,Pan2.ar(output,pan));//output.dup
		
		}).writeDefFile;
		
			
		SynthDef(\motherfugasound3, {arg out,bufnum,freq,dur,amp,pan; 
		var output;
		
		output= LFSaw.ar(SinOsc.ar(Rand(0.1,10.5),0,freq*0.01,freq),0,amp*(1+Rand(0.01,0.1))*Osc.kr(bufnum, Rand(0.13,0.6)))*(Line.kr(1.0,0.0,dur,doneAction:2)**2);
		
		output=Resonz.ar(output,XLine.kr(15000,4000,dur*0.1),0.1);
		
		Out.ar(out,Pan2.ar(20*output,pan));//output.dup
		
		}).writeDefFile;
		
		SynthDef(\motherfugasound4, {arg out,bufnum,freq,dur,amp,pan; 
		var output;
		
		output= Formant.ar(SinOsc.ar(Rand(0.1,10.5),0,freq*0.01,freq),Rand(1000,2000),Rand(100,1000),amp*(1+Rand(0.01,0.1))*Osc.kr(bufnum, Rand(0.13,0.6)))*(EnvGen.kr(Env.perc(0.01,dur),doneAction:2));
		
		Out.ar(out,Pan2.ar(output,pan));//output.dup
		
		}).writeDefFile;
		
		SynthDef(\motherfugafx, {arg out=0; 
		
		ReplaceOut.ar(out,LPF.ar(In.ar(out,2),6000));
		
		}).writeDefFile;
				
				
		SynthDef(\psychoadjust, {arg out=0; 
		
		ReplaceOut.ar(out,LPF.ar(BRF.ar(In.ar(out,2),3500,0.1),6000));
		
		}).writeDefFile;
				
				
				
		SynthDef(\mfreverb,{arg out=0, wet=0.05;
		var a,c,z,y,in;
		c = 7; // number of comb delays
		a = 4; // number of allpass delays
		
		in=Limiter.ar(In.ar(out,2));
		// reverb predelay time :
		z = DelayN.ar(in, 0.048,0.048);
		
		//for delaytime if want modulation-	//LFNoise1.kr(0.1.rand, 0.04, 0.05)
		y=Mix.arFill(c,{CombL.ar(z,0.1,rrand(0.01, 0.1),5)});
			
		// chain of 4 allpass delays on each of two channels (8 total) :
		a.do({ y = AllpassN.ar(y, 0.051, [rrand(0.01, 0.05),rrand(0.01, 0.05)], 1) });
			
		// add original sound to reverb and play it :
		ReplaceOut.ar(out,in+(wet*y))
		}).writeDefFile;
		
			
	}

}