//This file is part of MotherFuga. Copyright (C) 2004  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file MotherFuga.help

//MFSection by N.M.Collins

//two types of harmonic section- fixed key or transition modulation (abrupt is empty/missing transition)  
	
//fugal statement, (answer), episode, stretto, pedal 	

//tempo curves during performance over sections in rendering?
MFSection {	
	var <>length;
	var <>keys, <>keychangepoint; //<>keychangestyle- abrupt, probabilistic, to be refined
	var <>harmonicsequence;
	var <>involvedvoices;
	var <>roles; //what the voices do, free= episode subjectx, counterx, stretto is repeat of subjectx
	var <>development; //flag for development section
	var <>augmentflag, <>augmentfactor;
	
	makeHarmonicSequence {arg hc;
		var done,nextchorddur,chord;
		//use harmony creator to make a transition over keys of given length
		
		//harmonic rhythm= chords are 0.5,1.0 sec long for now
		done=0.0;
		
		harmonicsequence=[];
		
		while({done<length},{
		
		nextchorddur=[0.5,1.0].choose;
		
		//if(done+nextchorddur>length,{nextchorddur=length;});
		
		chord=hc.chords.choose;
		
		//chord.postln;
		
		chord=chord+if(done<=keychangepoint,{keys[0]},{keys[1]});
		
		chord=(chord%(hc.n)).sort;
		
		harmonicsequence=harmonicsequence++[[done,nextchorddur,chord]];
	
		done=done+nextchorddur;
		});		
	
		//Post <<harmonicsequence <<nl;
	}

	//no break construct? use while... 
	chordattime {arg time;
		var index;
		
		index=harmonicsequence.size-1;
		 
		harmonicsequence.reverseDo({arg val,j;
		  
		if(val[0]>time,{index=j; }); 
		
		});
		
		^harmonicsequence[index][2];
	}
	
	
	//based on roles, transpositions, thematic material, harmony
	playSection {	arg hc, registers, inthemes, totalvoices;
		var events, sectmel, themes;
		var ampmax, augspecial;
		
		ampmax= (1.0/((totalvoices).sqrt));
		
		themes= if (development,{
			themes=inthemes.deepCopy;
			
			//permute order so new material can come through
			themes.scramble;
			
			augspecial=[0,1,rrand(0.0,1.0)].wchoose([0.6,0.2,0.2]);
			
			//mess them up
			
			//may have more than one theme, copy? Only if can circular permute them for stretto
			
			themes.do({arg val;
			
			if(0.1.coin,{
				val.invert;
			
			});
			
			if(0.1.coin,{
				val.mess1;
			});
			
			if(augmentflag,{
				
				if(augspecial.coin,{
				val.augment(augmentfactor);},{
				val.augment(augmentfactor*rrand(0.5,1.0));
				});
			
			});
			});
			
			themes
		},{inthemes});
		
		
		//"here".postln;
		
		events= roles.collect({arg r,i; 
		var transpose, pan;
		
		//registers.postln;
		//involvedvoices.postln;
		
		pan=((involvedvoices[i])/(totalvoices-1))*2-1;
		
		transpose= registers[involvedvoices[i]];
		
		//transpose.postln;
		
		if(r[0]==0,{ 
		//themes[r[1]].renderMelody(hc,this,transpose,ampmax,pan).melody;
		themes[i].renderMelody(hc,this,transpose,ampmax,pan).melody;
		},{
		
		if(r[0]==1,{
		//themes[r[1]], fixed because this always gave the same voice doing same theme each time
		themes[i].renderMelody(hc,this,transpose,ampmax*0.5,pan).melody;
		});
		
		});
		
		});
		
		//Post<<events<<nl;
		
		//Post<<events.flatten(1)<<nl;
		
		//must sort into linear order, flatten and sort based on first arg, play time
		events=events.flatten(1).sort({ arg a, b; a[0] <= b[0] });
		  
		//Post<<events<<nl;  
		  
		//new iois- but not the same as durations
		
		events.do({arg ev,i; var ioi; 
	
		ioi= if(i<(events.size-1), {events[i+1][0]- ev[0]},{length-ev[0]});
		
		//swap from absolute start time of event to IOIs for scheduling
		events[i][0]=ioi;
		
		});
		
		//Post<<events<<nl;  
		
		sectmel= MFMelody.new;
		
		sectmel.melody=events;
		
		^sectmel; 
		
		}

	
}

MFSectionCreator {	
	var <>sections; 
	var <>voices;
	var <>registers; //each voice has a register
	var <>totallength;
	var <>hc; //attached harmony creator
	var <>subjectentries;
	var <>answerentries;
	var <>hc;
	var <>involved;
	var <>themelength;
	
	//work out which voices enter when and in what order- could have a generate and test to avoid subject followed by answer
	decideEntries {
		var notinyet,currentlyinvolved,subjectavail,answeravail;
		
		//different options for orders of entries and involved voices at each point
		
		//have lists of entries and subjects and a list of flags of whether in yet or not
		involved=[];
		
		subjectavail=List.fill(voices,{arg i; i}).scramble;
		answeravail=List.fill(voices,{arg i; i}).scramble;
		subjectentries=List.new;
		answerentries=List.new;
		notinyet=Array.fill(voices,{true});
		currentlyinvolved=List.new;
		involved=Array.fill(2*voices,{nil});
		
		voices.do({arg i;
		var nextsubject, nextanswer,index;
		
		//Post << "avail " << subjectavail << nl;
		
		nextsubject= subjectavail.pop;
		
		//Post << "avail " << subjectavail << nl;
		
		if(notinyet[nextsubject],{
		
			notinyet[nextsubject]=false;
			currentlyinvolved.add(nextsubject);
			//currentlyinvolved.sort to keep in order?
		
		});
		
		subjectentries.add(nextsubject);
		
		//need nextsubject first
		
		//Post << "involved before " << currentlyinvolved << nl;
		
		currentlyinvolved.scramble; //always shuffling roles
		
		//but nextsubject must be first
		index=currentlyinvolved.indexOfEqual(nextsubject);
		
		//Post << "involved scrambled " << currentlyinvolved << " swap index " << index << nl;
		
		currentlyinvolved.swap(0,index);
		
		//Post << "involved after " << currentlyinvolved << nl;
		
		involved[2*i]= currentlyinvolved.copy;
		
		nextanswer= answeravail.pop;
		
		if(notinyet[nextanswer],{
		
			notinyet[nextanswer]=false;
			currentlyinvolved.add(nextanswer);
			//currentlyinvolved.sort to keep in order?
		
		});
		
		answerentries.add(nextanswer);
		
		currentlyinvolved.scramble; //always shuffling roles
		
		index=currentlyinvolved.indexOfEqual(nextanswer);
		
		currentlyinvolved.swap(0,index);
		
		involved[2*i+1]= currentlyinvolved.copy;

		
		});
		
		//Post << subjectentries << nl;
		//Post << answerentries << nl;
	
	}
	
	
	newStructure {arg harmonycreator,numvoices=4, tl=6.0, expos=1,develop=1;
		var subjects,answers, eps, epsdone,answermods,epsmods, epspositions;
		var lastkey, nextkey, devsections;
		
		themelength=tl;
		
		hc=harmonycreator;
		
		//hard code to begin with
		voices=numvoices; //[rrand(2,4),rrand(5,10),rrand(10,50)].choose;
		
		//if lots of voices, need spatial separation, register separation hard since too many
		registers=Array.fill(voices,{arg i; i%4; }).scramble;//[1,2,0,3].scramble; //shuffles octave entries//one octave each for now
		
		//this is not exposition then development, exp takes too long with lots of voices? just free fugal writing?
		
		//root transposition, keep as always 0 for now
		//homekey=0;
		
		//exposition, each voice subject and answer once, based on home key
		subjects= voices;
		answers=voices;
		eps= (voices-1).rand;
		
		epspositions= Array.series(answers,0,1).scramble.copyRange(0,eps-1);
		
		//if(eps==0,{epspositions.postln;});
		
		//need key sequence- generate close keys for each answer (see proximities in harmonycreator).
		//episode or answer must modulate back to home, subject always home to answer key
		
		answermods= Array.fill(answers,{harmonycreator.chooseCloseModulation;});
		epsmods= Array.fill(eps,{harmonycreator.chooseCloseModulation;});
		
		epsdone=0;
		
			
		//subjectentries=Array.series(voices,0,1).scramble;
//		answerentries=Array.series(voices,0,1).scramble;
//		
//		//create involved at each stage by checking 
//		
//	//could jumble subject and answer voice orders later
	//	subjectentries=[0,2,1,3];
//		answerentries=[1,3,0,2];
//		
		//involveds=[[1],[1,2],[1,2,3],[1,2,3,4]];		
		this.decideEntries;
		
		//create sections
		sections=[];
		
		if(expos>0.5,{
		
		subjects.do({arg i;
		
		this.makeSubject(0,answermods[i],i);
		
		if(epspositions.includes(i),{
		
		if(eps==0,{"this shouldn't happen!".postln;});
		
		this.makeAnswer(answermods[i],epsmods[epsdone],i);
		this.makeEpisode(epsmods[epsdone],0,i);
		//makeepisode(epsmods(epsdone),0,epsdone,i);
		epsdone=epsdone+1;
		},{
		this.makeAnswer(answermods[i],0,i);
		});
		
		//this.makeAnswer(answermods[i],0,i);
		
		});
		
		});
		
		//development happens most of the time
		
		if(develop>0.5,{
			
			lastkey=0;
			devsections=rrand(3,30);
			devsections.do({arg i;
			
				nextkey=	if(i==(devsections.size-1),0,{harmonycreator.chooseModulation});
				this.makeDev(lastkey,nextkey,i);
				lastkey=nextkey;
				
			});
		
		
		});
		
		
		}
	
	//for exposition only
	makeSubject {arg startkey,endkey,subjectnum;
		var subj, volve;
		//two Harmonic sections, first longer in home, phrase ends moving to endKey
		
		subj=MFSection.new;
		
		subj.keys=[startkey,endkey];
		subj.length=themelength; //length of theme
		subj.keychangepoint=subj.length*([0.8,rrand(0.5,0.9),rrand(0.75,0.95)].wchoose([0.6,0.3,0.1]));
		
		//create the chord sequence from the harmonycreator object
		subj.makeHarmonicSequence(hc);
		
		//howmanyvoices=min(subjectnum*2+1,voices);
		
		volve=involved[subjectnum*2];
		
	//	involved=[subjectentries[subjectnum]];
//		
//		//hard coded for now
//		if(subjectnum==1,{involved=involved++[0,1]});
//		
//		if(subjectnum==2,{involved=involved++[0,2,3]});
//		
//		if(subjectnum==3,{involved=involved++[0,1,2]});
//		
		subj.involvedvoices=volve;
		
		//[0,x]= subjectx, [1,x]=counterx, [2] free
		subj.roles=volve.collect({arg val,i; if(i==0,{[0,0]},{[1,i]})});
		
		subj.development=false;
		
		sections=sections++[subj];
		
	}
	
	
	
	
		//for exposition only
	makeAnswer {arg startkey,endkey,answernum;
		var subj, volve;
		//two Harmonic sections, first longer in home, phrase ends moving to endKey
		
		subj=MFSection.new;
		
		subj.keys=[startkey,endkey];
		subj.length=themelength; //length of theme
		subj.keychangepoint=subj.length*([0.8,rrand(0.5,0.9),rrand(0.75,0.95)].wchoose([0.6,0.3,0.1]));
		
		//create the chord sequence from the harmonycreator object
		subj.makeHarmonicSequence(hc);
		
		//howmanyvoices=min(subjectnum*2+1,voices);
		
		//[1,3,0,2];
		
		volve=involved[answernum*2+1];
		
		//involved=[answerentries[answernum]];
//		
//		//hard coded for now
//		if(answernum==0,{involved=involved++[0]});
//		
//		if(answernum==1,{involved=involved++[0,1]});
//		
//		if(answernum==2,{involved=involved++[1,2,3]});
//		
//		if(answernum==3,{involved=involved++[0,1,3]});
//		
		subj.involvedvoices=volve;
		
		//[0,x]= subjectx, [1,x]=counterx, [2] free
		subj.roles=volve.collect({arg val,i; if(i==0,{[0,0]},{[1,i]})});
		
		subj.development=false;
		
		sections=sections++[subj];
		
	}

	
	
		//for exposition only, no use of the subject at all
	makeEpisode {arg startkey,endkey,answernum;
		var subj, volve;
		//two Harmonic sections, first longer in home, phrase ends moving to endKey
		
		subj=MFSection.new;
		
		subj.keys=[startkey,endkey];
		subj.length=themelength; //length of theme
		subj.keychangepoint=subj.length*(rrand(0.3,0.9));
		
		//create the chord sequence from the harmonycreator object
		subj.makeHarmonicSequence(hc);
			
		volve=involved[answernum*2+1];
		subj.involvedvoices=volve;
		
		//[0,x]= subjectx, [1,x]=counterx, [2] free
		//all counterx, no subject
		subj.roles=volve.collect({arg val,i; [1,i]});
		
		subj.development=false;
		
		sections=sections++[subj];		
	}

	
	//need to transform themes and counter melodies for these
	makeDev {arg startkey,endkey,devnum;
		var subj, volve;
		//two Harmonic sections, first longer in home, phrase ends moving to endKey
		
		subj=MFSection.new;
		
		subj.keys=[startkey,endkey];
		subj.length=themelength; //length of theme
		
		//must change length and decide on any augmentation at this point
		subj.augmentflag= if(0.1.coin,{
		subj.augmentfactor= [0.5,2.0, rrand(0.5,2.0),rrand(0.1,0.5),rrand(2,10)].wchoose([0.2,0.2,0.5,0.05,0.05]);
		
		subj.length= themelength*subj.augmentfactor;
		
		true
		},false);
		
		subj.keychangepoint=subj.length*(rrand(0.3,0.9));
		

		//create the chord sequence from the harmonycreator object
		subj.makeHarmonicSequence(hc);
			
		volve=involved.choose;
		subj.involvedvoices=volve;
		
		//[0,x]= subjectx, [1,x]=counterx, [2] free
		subj.roles=volve.collect({arg val,i; if(i==0,{[0,0]},{[1,i]})});
		
		subj.development=true;
		
		sections=sections++[subj];		
		
		
	}

	
}


