//This file is part of MotherFuga. Copyright (C) 2004  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file MotherFuga.help

//MFMelody by N.M.Collins


//melody as succession of steps [0,1] (within one octave) 
//status (0=chord diatonic, 1=scale diatonic 2=chromatic accidental (3=mistuning)] 

//format- starttime, duration, restflag, pitch, pitchstatus, emphasis (amplitude)

MFMelody {	
	var <>length;
	var <>melody;
	
	//passes in harmonic sequence and harmony creator
	renderMelody {arg hc, hs, transpose=0, ampmult=1.0, panpos=0.0;
		var render;
		
		render=MFMelody.new;
		
		render.length=length;
		
		render.melody=melody.collect({	arg val; 
			var temp, pitch, pitchstatus, time, chord, octave, distances, minima, minindex;
			
			temp=val.copy;
			
			time=temp[0]; //start time
			
			pitchstatus=temp[4];
			pitch=temp[3];
			octave= floor(pitch+1.0)-1.0;
			pitch=pitch%1.0;
			
			temp[3]= transpose+ octave + if(pitchstatus==0,{			//chord diatonic
				
			chord=(hs.chordattime(time))/(hc.n);
			
			//hc.chorddiatonic(pitch);
			
			distances= chord.collect({arg val; 
				var tmp;
				tmp=abs(val-pitch);
				min(tmp, 1.0-tmp);
				});
			
			minima=distances[0];
			minindex=0;
			
			distances.do({arg val,j; if (val<minima, {minima=val; minindex=j;}); });
			
			chord[minindex];
			
			},{	
				if(pitchstatus==1,{ //scale diatonic
				
				chord=hc.scale/hc.n;
				
				distances= chord.collect({arg val; 
					var tmp;
					tmp=abs(val-pitch);
					 min(tmp, 1.0-tmp);
				 });
				
				minima=distances[0];
				minindex=0;
				
				distances.do({arg val,j; if (val<minima, {minima=val; minindex=j;}); });
				
				chord[minindex];
				},{//2 chromatic accidental
				
				pitch;
				});
			
			});
			
			temp[5]=temp[5]*ampmult;
			
			temp++[panpos];
		});
		
		^render;
	}
	
	//play a rendered finalised melody as a Task
	playMelody {arg b, quant=0, waitonlast=false, def=\motherfugasound, group, outbus=0;
		var melsize;
		
		group=group ?? {RootNode.new};
		
		melsize=melody.size;
	
		melody.do({arg val,j; 
			
			//Post << "ioi" << val[0] << " dur"<< val[1] << "rest " << val[2] << " pitch " << val[3] << " amp " << val[5]<< nl;
			
			//Post << val <<nl;
			
			if(val[2]<0.5,{
			
			//Post << "playnote! " <<nl;
			
			
			//0.5 times amplitude to avoid obvious overloads
			Synth.head(group,def,[\out,outbus,\bufnum,b.bufnum,\freq,(36+(12*val[3])).midicps,\dur,val[1],\amp,0.5*val[5],\pan,val[6]]);
		
			});
			
			//don't wait on last note so sections blend
			if(not(j==(melsize-1)) || waitonlast,{
			(val[0]).round(quant).wait;
			});
		});
		
	}
	
	
	
	
	invert {
	
	melody.do({arg val; 
		
		val[3]=1.0-val[3]; 
		});	
	
	}
	
	augment {arg factor=2;
	
	melody.do({arg val; 
		
		val[0]=val[0]*factor; 
		});	
	
	length= length*factor;
	}
	
	//change pitch statuses, amplitudes, durs, could have probability of change to each
	mess1 {
	
		//melody.postln;
		
	melody.do({arg val; 
		
		val[4]=[2,1,0].wchoose([0.05,0.5,0.45]); 
		
		val[5]= val[5]*([1.0,rrand(0.7,1.7),exprand(0.1,2)].wchoose([0.5,0.45,0.05]));
		
		//adjust dur
		val[1]= val[1]*([1.0,rrand(0.7,1.7),exprand(0.1,2)].wchoose([0.5,0.45,0.05]));
		
		});	
		
		//check it gets overwritten
		//melody.postln;
	}
	
	//circular permutation
	mess2 {
	
	}
	//must recalculate val[0]s 
	
	
}


//material of longdurs and cells appropriate for theme- can be used as source for counter
//to stop too much overwhelming variation, but must make sure counter is sufficiently different

MFMelodyCreator {	
	var <>longdurs;
	var <>longprobs;
	var <>cells, cellprobs;
	var <>startpoints, startprobs;
	var <>contours;
	var <>tatum;
	
	initMFMelodyCreator {	
		
		tatum= [exprand(0.0625,0.2),rrand(0.625,0.125),exprand(0.0625,1.0)].wchoose([0.6,0.2,0.3]);
		
		longdurs=tatum*Array.fill(rrand(5,9),{rrand(1,13)});
		longdurs=longdurs.sort;
		longprobs=(Array.series(longdurs.size,1,1).reverse).normalizeSum;
		
		//split long durations into shorter rhythms
		//Array.fill(rrand(1,5),{rrand(0.1,1.0)}).normalizeSum
		
		//make rhythmic figures from combinations of longdurs
		cells=Array.fill(rrand(5,9),{Array.fill(rrand(1,5),{longdurs.wchoose(longprobs);})});
		cellprobs=Array.fill(cells.size,{rrand(0.1,1.0)}).normalizeSum; 
		
		startpoints= Array.fill(rrand(5,9),{rrand(0.0,1.0)});
		startpoints=startpoints.sort;
		startprobs=Array.series(startpoints.size,1,1).normalizeSum;
		
		contours=Array.fill(rrand(5,9),{Array.fill(10,{[rrand(-0.4,0.0)*rrand(0.0,1.0),0.0,rrand(0.0,0.5)*rrand(0.0,1.0)].wchoose([0.3,0.2,0.5])})});
		
		}
	
	makeTheme {arg length;
		var theme, done;
		var nextcell,pitches;
		
		theme=MFMelody.new;
		theme.length=length;
		
		
		//recursive skeleton construction, start, end, high point and low point, iterate on sections to build up skeleton?
		
		//alert for possible sequences
		
		done=0.0;
		
		//make rhythms
		while({done<length},{	
			
			//could be less random, fine for now
			nextcell= cells.wchoose(cellprobs); //(longdurs.wchoose(longprobs))*
			
			pitches=(startpoints.wchoose(startprobs))+contours.choose;
			
			nextcell.do({arg dur,i;
			
			//to cover case where long note shoots past end of desired length
			if(((done+dur)>(length-0.05)) && (done<(length-0.5)),{dur=(length-0.06)-done;});
			
			if((done+dur)<(length-0.05),{	
				
				//format- starttime, duration, restflag, pitch, pitchstatus, emphasis (amplitude)
			theme.melody=theme.melody++[[done,dur,[1,0].wchoose([i*0.05,1.0]),pitches[i],[2,1,0].wchoose([0.05,0.5,0.45]),if(i==1,{rrand(0.5,1.0)},{rrand(0.25,1.0)})]];
				
				});
			
			done=done+dur;
			
			//done.postln;
			
			});
			
			});
		
		^theme;
		}
	
	
	//counter should usually be less busy than the opposition? 
	//can merge some opposition start points to form a lighter template
	makeCounterMelody { arg oppositionmelody;
	var length;
	var theme, done;
	var nextcell,pitches;
	var omstarts, omprev, omnext, left, wait, tatumwait;
		
		length=oppositionmelody.length;
		
		theme=MFMelody.new;
		theme.length=length;
		
		done=0.0;
		
		//find all start points of opposition, set all/most startpoints for counter inbetween
		//if opposition slow, counter fast and vice versa
		
		omstarts= oppositionmelody.melody.collect({arg val; val[0]});
		
		//make rhythms
		while({done<length},{	
			
			left=length-done;
			
			//find omstart previous and next after done- try and place counter start 
			//in the middle
			
			omprev=0;
			omnext=0;
			omstarts.do({arg val,j; if(val<done,{omprev=val; omnext=j;}); });
			if(omnext<(omstarts.size-1),{omnext=omstarts[omnext+1]},{omnext=length;});
			
			tatumwait= ((omnext-done)/tatum).floor;
			
			//avoid coincidence of parts most of the time
			if((0.6.coin) && ((done-omprev)<0.1),{
			
			wait= min(min(tatum*floor(tatumwait*0.5),longdurs.wchoose(longprobs)), left);
			
			//make a rest, or elongate last note, or just leave alone if inbetween
			theme.melody= theme.melody++[[done,wait,1,0,0,0.0]];
				
			done=done+wait;
			});
			
			//could be less random, fine for now
			nextcell= cells.wchoose(cellprobs); //(longdurs.wchoose(longprobs))*cells.choose;
			
			pitches=(startpoints.wchoose(startprobs))+contours.choose;
			
			nextcell.do({arg dur,i;
			
			//to cover case where long note shoots past end of desired length
			if(((done+dur)>(length-0.05)) && (done<(length-0.5)),{dur=(length-0.06)-done;});
			
			if((done+dur)<(length-0.05),{	
				
				//format- starttime, duration, restflag, pitch, pitchstatus, emphasis (amplitude)
				theme.melody= theme.melody++[[done,dur,[1,0].wchoose([i*0.05,1.0]),pitches[i],[2,1,0].wchoose([0.05,0.5,0.45]),if(i==1,{rrand(0.5,1.0)},{rrand(0.25,1.0)})]];
				
				});
			
			done=done+dur;
			
			//done.postln;
			
			});
			
			});
		
		^theme;

	}

//		
//	//returns a trill ornament
//	trill {
//	
//	}
//	
//	//mordent
//	mordent {
//	
//	}
//	
//	turn {
//	
//	}

	
}