//This file is part of MotherFuga. Copyright (C) 2004  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file MotherFuga.help

//MFHarmonyCreator by N.M.Collins

//melodies are diatonic step contour based,with percentage accidentals, so independent of tuning 
//can change tuning as you go then...

//can set up so some accidentals more likely than others

MFHarmonyCreator {
	var <>n; //tuning system
	var <>scale;	//key structure
	var <>transpositions; //transpositions 0 to n-1 and number of keys in common
	var <>modulations; //possible modulations and degree of remoteness
	var <>chords; //possible chords for each start note
	var <>closest;
	
	newTuning {
		var scalesteps, temp, diff, intervalvector, chordtype;
		
		n=[rrand(8,10),rrand(15,42)].wchoose([0.2,0.8]); //2**rrand(3,9);
		
		scalesteps= if(n<11, rrand(5,n-1),rrand(7,11)); //cognitive constraints at first- memory here
		
		//almost even spaced with permutations
		temp= n/scalesteps;
		
		scale=round(Array.series(scalesteps,0,temp)+Array.rand(scalesteps,(temp/2).neg,temp/2));
		
		scale[0]=0;
		
		//must make sure no repetitions, and starts with zero
		scale= scale.collect({arg v; min(max(v,0),n-1)});
		
		scale=scale.asSet.asSortedList.asArray;
		
		intervalvector= Array.fill(n,0);
		
		for (0,scale.size-1,{arg i; 
			
			for (0,scale.size-1,{arg j; 
			
				diff= (scale[j]-scale[i])%n; 
				
				intervalvector[diff]=intervalvector[diff]+1;
			});
			
		});
		
		//it's the same! 
		transpositions=intervalvector;
		
		//classify by closeness, 0 is 0 in common etc
		modulations=Array.fill(scale.size+1,{[]});
		
		transpositions.do({arg val,i; modulations[val]=modulations[val]++[i];});
	
		this.prepareClosestModulations;
		
		chords= Array.fill(scale.size);
	
		//triads for now- later make more than one chordtypes, differing over degrees?
		//these are diatonic (within scale) patterns
		chordtype= [0,2,4];
	
		//scalesize always greater than 5? 
		scale.size.do({arg i; 
		var degreechord;
		
		degreechord=(chordtype+i)%(scale.size);
		chords[i]= scale.at(degreechord);
				
		});
	
		//n.postln;
		//Post << scale << nl;
//		Post << transpositions <<nl;
//		Post << modulations <<nl;
		//Post << chords <<nl;
	}
	
	prepareClosestModulations { arg num=4;
		var i, which,done,modsizes;
		
		modsizes= modulations.collect({arg val; val.size});
	
		closest=[];
		
		done=false; i=scale.size;
		//find first non zero array 
		while({done==false},{
			
			which=modsizes[i];
			//which.postln;
			
			if(which!=0,{
				min(num-(closest.size),which).do({arg j;  
				
				closest= closest++[modulations[i][j]];
					
				});  
				
			});
			
			if(closest.size>=num,{done=true;});
			
			if(i==0,{done=true;});
			
			i=i-1;
			
		}); 
		
		//Post << "closest  " << closest << nl;
		
	}
	
	chooseCloseModulation {
	^closest.choose;
	}
	
	//chooses any modulation randomly 
	chooseModulation {
	^(modulations[transpositions.choose].choose)
	}
	
	//modulation transition probabilities, chord transition probabilities
	//possible modulation devices
	
	newModulationSequence {
	
	
	}
	
	
	//chorddiatonic
	
	
}