/*
 *  LLVMCompiler.cpp
 *  Clang
 *
 *  Created by Nicholas Collins on 06/10/2010.
 *  Copyright 2010 Nicholas M Collins. All rights reserved.
 *
 */

#include "LLVMCompiler.h"


LLVMCompiler::LLVMCompiler() {
	
	//printf("Clang Klang \n");
	M = new llvm::Module("JIT",llvm::getGlobalContext());			
	// Create the JIT.
	EE = llvm::EngineBuilder(M).create();						
	//			llvm::EngineBuilder EB = llvm::EngineBuilder(ns->MP);
	//			EB.setEngineKind(llvm::EngineKind::Interpreter); //JIT
	//			ns->EE = EB.create();			
	PM = new llvm::PassManager();
	
	PM->add(new llvm::TargetData(*EE->getTargetData()));
	// Do simple "peephole" optimizations and bit-twiddling optzns.
	PM->add(llvm::createInstructionCombiningPass());
	// Reassociate expressions.
	PM->add(llvm::createReassociatePass());
	// Eliminate Common SubExpressions.
	PM->add(llvm::createGVNPass());
	// Simplify the control flow graph (deleting unreachable blocks, etc).
	PM->add(llvm::createCFGSimplificationPass());
	// Function inlining
	PM->add(llvm::createFunctionInliningPass());
	//printf("hooray for LLVM\n");
	
}

LLVMCompiler::~LLVMCompiler() {
	
	delete PM; 
	delete EE; 
	delete M; 
	
}





void * LLVMCompiler::compute(char * assm) {
	
	//assume my_dsp for now
	//char * name = &(argv[0]->s);
	//char * assm = &(argv[1]->s);
	
	//now in NRT thread, should be safe
	//milliseconds? 
	//while(g_dspwait==1) { printf("waiting!\n"); usleep(200);} 
	
//	printf("dsp not active, proceeding with jit\n");
		
	//llvm::Function* func2= M->getFunction(std::string(name));
	llvm::Function* func2= M->getFunction(std::string("my_dsp"));
	
	if(func2) 	{
		func2->dropAllReferences();
		func2->removeFromParent(); 
	}

	//llvm::SMDiagnostic pa;
	//llvm::ParseError pa;
	llvm::Module* newM = ParseAssemblyString(assm, M, pa, llvm::getGlobalContext());


	//std::stringstream ss2; 
	//ss2 << *M << std::endl; 
	
	if(newM == 0)
	{
		
		
		printf("failure in llvm\n"); 
		//
		std::string errstr;
		llvm::raw_string_ostream ss(errstr);
		//		//pa.Print("Impromptu",ss);
		//const char progname[14] = "SuperCollider";
		pa.Print("SuperCollider",ss);
		
		printf("llvm diagnostic %s \n",ss.str());
		
		//std::cout << "llvm diagnostic " <<  (ss.str()) << std::endl; 
		
		return NULL; 
		//[[LogView sharedInstance] notification:[NSString stringWithCString:ss.str().c_str()]];
	}		
	
	
	
	llvm::Function* func= M->getFunction(std::string("my_dsp"));
	
	return EE->getPointerToFunction(func);
	
	//printf("hello2 %p\n",dspfunc); 
	
	
}



