/*
	SuperCollider real time audio synthesis system
 Copyright (c) 2002 James McCartney. All rights reserved.
	http://www.audiosynth.com
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


//released under the GNU GPL as extensions for SuperCollider 3, by Nick Collins, http://www.informatics.sussex.ac.uk/users/nc81/
//with extensive advice from Andrew Sorensen:
//http://impromptu.moso.com.au/
//the LLVM jit compiler is embedded within a SC UGen. OSC is used (via u_cmd message to a UGen) to send strings of LLVM intermediate notation. 
//These are jit compiled into a running dsp function. 
//Note that thread safety is handled pretty coarsely via a flag and sleep message in NRT thread 


//complex bunch of linker flags used for bringing in architecture specific LLVM libraries, in Xcode project 
//-L/Users/nickcollins/Desktop/llvm/llvm-2.6/Release/lib
//-lLLVMX86AsmParser
//-lLLVMX86AsmPrinter
//-lLLVMX86CodeGen
//-lLLVMSelectionDAG
//-lLLVMAsmParser
//-lLLVMAsmPrinter
//-lLLVMXCoreInfo
//-lLLVMX86Info
//-lLLVMInterpreter
//-lLLVMJIT
//-lLLVMExecutionEngine
//-lLLVMCodeGen
//-lLLVMScalarOpts
//-lLLVMTransformUtils
//-lLLVMInstrumentation
//-lLLVMipo
//-lLLVMipa
//-lLLVMAnalysis
//-lLLVMTarget
//-lLLVMMC
//-lLLVMCore
//-lLLVMSupport
//-lLLVMSystem
//-lffi





#define SC_DARWIN
#include "SC_PlugIn.h"
//local copy for this file only, else to share have to define a .h file
static InterfaceTable *ft; 


#include "LLVMCompiler.h"


//data to be shared between RT and NRT threads 
struct CmdData {
	enum Type
    {
		NRTCtorClang,
		NRTDtorClang,
		NRTCompileClang
    };
	
	Type type; 
	Unit * unit; 
	void *	nrtallocated; 
	char * string_; //for passing program to compile
	//float samplingrate_; 
	
};


//will be global now
LLVMCompiler * compiler_; 


struct Clang : public Unit    
{
	long long samplesdone; 
	float * floatbuffer_; 
	int * intbuffer_; 
	int numfloats_, numints_; 
	int changeflag_; 
	//void * environment; 
	
	int dspflag_; 
	
	//assumes mono
	void (*dspfunc) (int, float *, float *, long long, float *, int, int *, int); 
	
	
	
};

extern "C" {  
	
	void Clang_next(Clang *unit, int inNumSamples);
	void Clang_Ctor(Clang* unit);
	void Clang_Dtor(Clang* unit);

}




//for NRT allocation and deallocation 

bool cmdStage2(World* inWorld, CmdData* cmd) // NRT
{
	Clang* unit = (Clang *) cmd->unit;
	
	switch (cmd->type) {
		//case CmdData::NRTCtorClang: 
//			//cmd->samplingrate_ need to pass block size really 
//			cmd->nrtallocated = (void *)(new LLVMCompiler());
//			return true;
//		case CmdData::NRTDtorClang: 
//			
//			delete ((LLVMCompiler*)cmd->nrtallocated);
//			
//			return true;
		case CmdData::NRTCompileClang: 
			//unit->compiler_
			unit->dspfunc = (void (*) (int, float *, float *, long long, float *, int, int *, int)) compiler_->compute(cmd->string_); 
			
			return true;
			
	}
	
	return false;
}

bool cmdStage3(World* world, CmdData* cmd) // RT
{
	Clang* unit = (Clang *) cmd->unit;
	
	switch (cmd->type) {
//		case CmdData::NRTCtorClang: {
//			((Clang*)cmd->unit)->compiler_ = (LLVMCompiler*)cmd->nrtallocated;
//		}
//			return true;
		case CmdData::NRTCompileClang: 
			if(unit->dspfunc) {
				
				unit->dspflag_=1;
				
			} else {
			
				printf("failure in llvm, dsp offline!!!!!!\n"); 
				
			}
			return true;	
			
	}
	return true;
}

bool cmdStage4(World* world, CmdData* cmd) // NRT
{
	return true;
}

void cmdCleanup(World* world, void* cmd)
{
	if(((CmdData*)cmd)->string_)
		RTFree(world, ((CmdData*)cmd)->string_);
	RTFree(world, cmd);
}







void Clang_next(Clang *unit, int inNumSamples) {

	float* in = IN(0);
	
	float* out = OUT(0);

	if(unit->dspflag_==1) {
	
		long long samplesdone = unit->samplesdone; 	

		//printf("clangugen wrapper side  %p %d check %d %p %d %p %d check2 %p \n",out, inNumSamples, (int)samplesdone, &(g_floats[0]), unit->numfloats_, g_ints, unit->numints_, g_floats); 

		unit->dspfunc(inNumSamples, in, out, samplesdone,unit->floatbuffer_, unit->numfloats_, unit->intbuffer_, unit->numints_); 
	
		samplesdone+=inNumSamples; 
		
		unit->samplesdone = samplesdone; 
	} else {
		
		//printf("no dsp func \t"); 
		
		for (int j=0; j<inNumSamples; ++j)
			out[j]= 0.0; 
			
	}
		
	
}



void ClangUnitCmdFunc (Unit *unit, struct sc_msg_iter *args) {
	
	Clang * clangp = (Clang*) unit; 
	
	const char * stringarg = args->gets();
	
	//printf("got unit cmd: %s \n", stringarg); 
	
	//this is called in the RT thread ahead of traversing the Node Tree 
	
	//so need to pass off to non RT thread, or else would have to risk missed audio calculation based on time taken for LLVM compilation 
	
	//if (clangp->compiler_) {
		
	//set stop flag, store string
	clangp->dspflag_ = 0; 
	
	//pass off to NRT thread which will call LLVMCompiler and eventually swap dsp function and restore active flag
	
	CmdData* cmd = (CmdData*)RTAlloc(unit->mWorld, sizeof(CmdData));
	cmd->unit = unit; 
	
	cmd->type = CmdData::NRTCompileClang; 
	
	cmd->string_ = (char *)RTAlloc(unit->mWorld,sizeof(char)*strlen(stringarg));
	strcpy(cmd->string_, stringarg);  
	
	DoAsynchronousCommand(unit->mWorld, 0, "", (void*)cmd,
						  (AsyncStageFn)cmdStage2,
						  (AsyncStageFn)cmdStage3,
						  NULL,
						  cmdCleanup,
						  0, 0);
	
	//}
	
	
}


//will need to create in NRT mode

void Clang_Ctor(Clang* unit) {
	
	unit->samplesdone = 0; 

	unit->numfloats_ = (int)SAMPLERATE; //one second worth at sampling rate
	unit->floatbuffer_ = (float *)RTAlloc(unit->mWorld,sizeof(float)*unit->numfloats_); 
	unit->numints_ = 100; //surely 100 counters will be enough...
	unit->intbuffer_ = (int *)RTAlloc(unit->mWorld,sizeof(int)*unit->numints_); 
	
	//printf("num floats %d", unit->numfloats_); 
	
	int i; 
	
	for (i=0; i<unit->numfloats_;++i)
		unit->floatbuffer_[i]= 0.0f; 
	
	for (i=0; i<unit->numints_;++i)
		unit->intbuffer_[i]= 0; 
	
	//printf("clangugen wrapper constructor %p %d %p %d check2 %p \n",&(g_floats[0]), unit->numfloats_, g_ints, unit->numints_, g_floats); 
	
	unit->dspflag_ = 0; 
	
	//bool (*fDefineUnitCmd)(const char *inUnitClassName, const char *inCmdName, UnitCmdFunc inFunc);
	DefineUnitCmd("Clang","newir",ClangUnitCmdFunc);

	
//	
//	CmdData* cmd = (CmdData*)RTAlloc(unit->mWorld, sizeof(CmdData));
//	//cmd->samplingrate_ = unit->mWorld->mFullRate.mSampleRate; 
//	cmd->unit = (Unit *)unit; 
//	cmd->nrtallocated = NULL; //will be allocated in NRT thread 
//	cmd->type = CmdData::NRTCtorClang; 
//	
//	//(AsyncStageFn)PitchNoteUGencmdStage4
//	
//	DoAsynchronousCommand(unit->mWorld, 0, "", (void*)cmd,
//						  (AsyncStageFn)cmdStage2,
//						  (AsyncStageFn)cmdStage3,
//						  NULL,
//						  cmdCleanup,
//						  0, 0);

	
	SETCALC(Clang_next); 
	
}


void Clang_Dtor(Clang* unit) {
	
	unit->dspflag_ = 0; 
	
	RTFree(unit->mWorld,unit->floatbuffer_);
	RTFree(unit->mWorld,unit->intbuffer_);
	
//	if (unit->compiler_) {
//		
//		CmdData* cmd = (CmdData*)RTAlloc(unit->mWorld, sizeof(CmdData));
//		cmd->unit = unit; 
//		cmd->nrtallocated = unit->compiler_; 
//		unit->compiler_ = NULL; //no longer available, will be deallocated in NRT thread
//		cmd->type = CmdData::NRTDtorClang; 
//		
//		DoAsynchronousCommand(unit->mWorld, 0, "", (void*)cmd,
//							  (AsyncStageFn)cmdStage2,
//							  NULL,NULL,
//							  cmdCleanup,
//							  0, 0);
//		
//	}
	
}




extern "C" void load(InterfaceTable *inTable) {
	
	ft = inTable;
	
	DefineDtorCantAliasUnit(Clang); 
	
	printf("Clang Klang \n");
	
	//global llvm setup, only needed once
	
	llvm::InitializeNativeTarget();
	
	llvm::PerformTailCallOpt = true;
	
	llvm::llvm_start_multithreaded();

	compiler_ = new LLVMCompiler();		//assumed memory will be deallocated when server quits
	
	printf("hooray for LLVM\n");
	
	
	
	
	
}




