//central class for music information retrieval operations in SC  
//class variables and methods only, singleton class
 
SCMIR { 
	 
	//for auxilliary operations 
	classvar <soundfile;  
	classvar <tempdir; //location for temp files; if none given, same path as soundfile input 
	classvar <samplingrate; //assumed 44100 for now 
	classvar <framehop, <hoptime, <framerate; //<framesize,   
	classvar <executabledirectory;  
	classvar <globalfeaturenorms; 
		 
	*initClass { 
			 
		soundfile = SoundFile.new; 
		
		samplingrate = 44100;  
		//framesize = 1024; 
		framehop = 1024; 
		framerate = samplingrate/framehop; 
		hoptime = framerate.reciprocal; 
		
		executabledirectory = SCMIR.filenameSymbol.asString.dirname.escapeChar($ )++"/scmirexec/";  
		//tempdir = SCMIR.filenameSymbol.asString.dirname++"/scmirtemp/";  
		
		tempdir = "/tmp/";	//user should always have write permission here? 
		
		SCMIR.initGlobalFeatureNorms; 
		
	} 
	

	
	//warning: this method can invalidate all previous SCMIR method calls, and conflict with saved information
	//for individual files, can check using numframes and duration versus current SCMIR.framerate*duration
	*setFrameHop {|hopsize| 
		
		if ((hopsize!= 1024) && (hopsize!=512)) {
			
			"SCMIR:setFrameHop: only hopsize of 1024 or 512 supported".postln;
			
			^nil}; 
		
		framehop = hopsize;
		
		framerate = samplingrate/framehop; 

		hoptime = framerate.reciprocal; 
		
	}
	
	//frame hop length in seconds
//	hopTime {
//	
//		^hoptime; //framerate.reciprocal; 	
//		
//	}
	
	
	//COMPENSATION REQUIRED since triggering on chromafft, will be storing values based on initial delay of 4096 samples
	//should associate value with 2048 samples in halfway through window 
	*frameTime{|whichframe| ^(framehop*whichframe+2048)/samplingrate}

		 
	*setTempDir {|tmpdirectory| 
			 
		//can do further tests here 
		tempdir = tmpdirectory; //if nil, will construct as go from paths passed in 
			 
		if(tempdir.notNil,{ 
			if(tempdir.last!=$/,{ 
				tempdir = tempdir++"/";  
			});  
		});  
			 
	}
	
	*getTempDir {
		
		//return empty string as prefix otherwise
		^ tempdir?""; 	
		
	}
	 
		 
	*setExecutableDir {|execdir| 
			 
		//can do further tests here 
		executabledirectory = execdir; //if nil, will construct as go from paths passed in 
			 
		if(executabledirectory.notNil,{ 
			if(executabledirectory.last!=$/,{ 
				executabledirectory = executabledirectory++"/";  
			});  
		});  
			 
	} 
		
 
 
 		//return true if in Routine, else in Main thread and .wait not valid
	*waitStatus {
			
			^(thisThread.class==Routine); //Thread
	}
	
	
	*waitIfRoutine {|time|
		
		if(thisThread.class==Routine) {
			time.wait;	
		}
		
		
	}
	*external {|command, scorerender=false, limit=2000| 
		
		if(thisThread.class==Routine) {
			
		SCMIR.waitOnUnixCmd(command, limit);
			
			if(scorerender) {
				//safety first, file not being written out quickly enough
				0.2.wait;	
			};
				
		} {
		
		if(scorerender) {
		systemCmd(command);	
		} {
		SCMIR.pipe(command);
		};	
				
		}
	}
		 
	//wait on process, assumed within Routine 
	*processWait {|processname, limit=2000|  
			 
		var a, count;  
		var checkstring = "ps -xc | grep '"++processname++"'";  
			 
		count=0;  
			 
		0.01.wait; //make sure process running first (can be zero but better safe than sorry)   
			 
		while({      
			a=checkstring.systemCmd; //256 if not running, 0 if running      
			  
			if(count%10==0,{(processname+"running for"+(count.div(10))+"seconds").postln});      
			  
			(a==0) and: {(count = count+1) <limit }      
			},{      
			0.1.wait;	      
		});      
		 
		0.01.wait;   
			 
	} 
	
	*pipe {|command|  
		var pipe, line; 	
		//var timinginfo;
		
		//SCMIR.waitOnUnixCmd(command); 
			
		//can't run while unix process blocks the app, so no updates	 
		//timinginfo = {var time= 1; 0.wait; inf.do{("waiting"++time+"s").postln; time = time+1; 0.1.wait;} }.fork(SystemClock); 	 
		pipe = Pipe(command, "r");				
		line = pipe.getLine;	
		
		//"Pipe here".postln;
		// get the first line
		while({line.notNil}, {line.postln; line = pipe.getLine; });		// post until l = nil
		pipe.close;	
		//timinginfo.stop; 
		 
	}


	
	//would only run with {}.fork due to no calls of .wait on main Thread
	//added external to force wait, but doesn't allow time for postln
	*waitOnUnixCmd {|command, limit=2000|
		var ps; 
		var count=1;
		var checkstring,checkreturn; 
		var processname = command.split($ )[0]; //assumption here if piping, but will do for now
		
		//"wait here!".postln;
		ps = command.unixCmd;

		0.01.wait;
		checkstring = "ps -ax | grep '"++ps++" ' "; 

		//"now here!".postln;

		//0.01.wait; 
			
		while({ 
			
			//{"test this".postln;}.defer;
			
			checkreturn = checkstring.unixCmdGetStdOut; 
			
			//command
			//[checkreturn,checkreturn.contains(command), checkreturn.split($\n)].postln;
			
			if(count%10==0,{("SCMIR: calculation running for"+(count.div(10))+"seconds").postln});      
			
			  //(checkreturn.split($\n).size)>3
			(checkreturn.contains(processname)) and: {(count = count+1) <limit }  
			 },{	 
				
			0.1.wait;	 
			
			//doesn't post since blocked by first process!  
			//replace with call to external that simply forces a wait for specified time
			//(SCMIR.executabledirectory++"waitinmain 100" + count).systemCmd; 
			
				 
			}); 		
		0.01.wait;
	}
	
	
		 
	//given one dimensional curve, typically already normalized 0.0 to 1.0, find peak locations 
	*peakPick {|curve, reach=15, exaggeration = 5, threshold = 1.0, minseparation=20|  
			 
		var peakcurve;  
		var maxindex = curve.size-1;  
		var list;  
		var sep=0;  
			 
		peakcurve = Array.fill(curve.size,{|i|    
				 
			var below, above;  
			var sum = 0.0;  
			var now = curve[i];  
				 
			below = (i-reach).max(0); 
			above= (i+reach).min(maxindex);  
				 
				 
			for(below, above,{|j| 
				var temp;  
					 
				temp = now - curve[j];  
					 
				//increase penalty if not local maximum 
				if(temp<0.0) {temp = exaggeration*temp; }; 
					 
				sum = sum + (temp);  
					 
			});  
				 
			sum 
				 
		});  
			 
		list = List[]; 	 
			 
		peakcurve.do{|val,i|  if(sep>0,{sep= sep-1;}); if ((val>threshold) and: (sep==0)) {list.add(i); sep= minseparation; } };  
			 
		^[list, peakcurve] 
	 
	} 
		 
	
	*initGlobalFeatureNorms {
		
		globalfeaturenorms = nil; 
		
	}
	
	//could make a dictionary over all observations ever, just a bit trickier?  
	//*lookupGlobalFeatureNorm {|featuretype,normalizationtype|
//		
//	}
	
	//assumes you know what you're doing, that format of featureinfo used to extract globals is same as that now being used
	//and that values do exist
	*lookupGlobalFeatureNorms {|which|
		^[globalfeaturenorms[0][which],globalfeaturenorms[1][which]];
	}
	
	*saveGlobalFeatureNorms {|filename|

		var archive; 
		
		filename = filename ?? { (SCMIR.getTempDir)++"globalfeaturenorms.scmirZ" };   
		  
		archive = SCMIRZArchive.write(filename);  
	  
		archive.writeItem(globalfeaturenorms); 	  
		  	    
		archive.writeClose;  

	}
	
	*loadGlobalFeatureNorms {|filename|
		
		var archive; 
		
		filename = filename ?? {(SCMIR.getTempDir)++"globalfeaturenorms.scmirZ"};   
		
		archive = SCMIRZArchive.read(filename);  
		
		globalfeaturenorms = archive.readItem; 
		
		archive.close; 
	}
	
	//run normalization procedures for all standard features over all filenames in list, obtaining global max and min, and mean and stddev
	*findGlobalFeatureNorms {|filenamelist, featureinfo, normalizationtype=0|
		
		var e; 
		var norms; 		
		var framesum = 0, framesumr; 
		var temp1, temp2; 
		
			
			norms= nil!(filenamelist.size); 
			
			filenamelist.do {|filename,j|
				
			e = SCMIRAudioFile(filename,featureinfo, normalizationtype);
			
			e.extractFeatures(false); 
		
			norms[j] = [e.normalize(e.featuredata, true), e.numframes];     
		
			framesum = framesum + e.numframes; 
		
			};
			
			if(normalizationtype==0) {
				
				//normalize
				temp1 = norms[0][0][0]; 
				temp2 = norms[0][0][1]; 
				
				norms.do{|val| 
					
					temp1 = min(val[0][0],temp1); 
					temp2 = max(val[0][1],temp2);
					
					}; 

				//combine
				globalfeaturenorms = [temp1,temp2];
					
			} {
				
				//standardize
				framesumr = 1.0/framesum;
				
				temp1 = 0.0; 
				temp2 = 0.0; 
				
				norms.do{|val| 
					
					temp1 = temp1 + (val[0][0]*val[1]*framesumr);
					temp2 = temp2 + (val[0][1]*val[1]*framesumr);
					
					}; 
					
				globalfeaturenorms = [temp1,temp2.sqrt]; //to stddev from variance at this point
				
			};
			
		
	}
	
	
	//for adding multiple sound file feature instances to
	*createARFF {|filename,numfeatures,classes|
		
		var file; 
		
		filename = filename ?? {(SCMIR.getTempDir)++"features.arff"};
		
		numfeatures  = numfeatures ? 1; 
		
		classes = classes ? ["class1","class2"]; 
		
		file = File(filename,"w"); 
		
		file.write("@RELATION SCMIR\n");
		
		numfeatures.do{|i|
			
			file.write("@ATTRIBUTE"+i+"NUMERIC\n");
		
		};
		
		file.write("@ATTRIBUTE class {"); 
			
		classes.do{|class,i| 
			
			file.write(class.asString);	
			
			if((i+1)<classes.size) {
			file.write(",");	
			}
			
			};
			
		file.write("}\n");

		file.write("@DATA\n");

		^file;
	}
	
	

		 
} 
 
 
 
 
 
 
 
 
 
