//8
//Octonion based electroacoustic piece in 8 channels or 8 virtual spatial positions
//8 minutes long in 8 movements


//whilst assumes 8 outs and 8 ins on system
s.options.numOutputBusChannels //8
s.options.numInputBusChannels //8
//synths will use internal busses 16-23, then final render to 0-8 or 0-2
//so if you have default 2 outputs, you will still be fine as long as using HRTF or Splay stereo output render

//Note that some SynthDefs involve large memory allocation and much wiring between UGens, so for safety, some settings below to increase (use before booting server or put in your startup.scd)
//put in start up or run before boot
(
Server.local.options.memSize = 81920*4;
Server.internal.options.memSize = 81920*4;
Server.local.options.numWireBufs = 128;
Server.internal.options.numWireBufs = 128;
)


//output modes (first argument to piece constructor)
//0 = 8 channel
//1 = HRTF (stereo, simulates 8 virtual sources)
//2 = Splay (stereo, spreads to 8 locations over the stereo field)

//mode 1 HRTF requires Ambisonic Tool Kit
//http://www.ambisonictoolkit.net/download/supercollider/
//not compulsory if you use modes 0 or 2

e = Eight(1) //defaults to 8 channel output, here make it HRTF for headphone auditioning

//optional
e.record //if output to be recorded, will make 8 or 2 channel output as needed

e.run //8 movements over 8 minutes

//end optional
e.stopRecord






//caution, kills all
e.stop























/////////////////////////////////////////
//development notes



//DONE sort amplitudes of quietest sections too quiet
//DONE variation in envelope type for sections
//much faster section?
//global effects over 60 seconds in 2 sections of 8, e.g. big reverb, or spectral split amongst 8 channels
//NHHall, FreeVerb, GVerb or custom reverb as global fx? Per channel, or 4 stereo pair reverbs?
//ensure ending effective: big bang or slow fade for closing section?

Synth(\EightOctonion4,[\out,16,\duration, 240])

s.scope


//envelope shape checking

Env([0,1,1,0],[1,10-1-2,2],[-8,1,-4]).plot


Env([0,1,1,0],[1,10-1-2,2],[-32,1,-18]).plot

Env([0,1,1,0],[1,10-1-2,2],[0,0,0]).plot

Env([0,1,1,0],[1,10-1-2,2],[2,0,-2]).plot

Env([0,1,1,0],[1,10-1-2,2],[10,10,10]).plot



