//circular hyper complex 8 dimensional number, non-commutative and non-associative in general, though has sub-algebras isomorphic to the complex numbers and quaternions

//Carmody, Kevin. "Circular and hyperbolic quaternions, octonions, and sedenions." Applied Mathematics and Computation 28, no. 1 (1988): 47-72.

//as class methods only for now, don't want to be returning new Octonions etc

//assumes inputs are 8 dimensional arrays, no checking
Octonion {

classvar <>octmultindices;
classvar <>octmultsigns;

	*initClass {

//indices
Octonion.octmultindices =  [
	[0,1,2,3,4,5,6,7],
	[1,0,3,2,5,4,7,6],
	[2,3,0,1,6,7,4,5],
	[3,2,1,0,7,6,5,4],
	[4,5,6,7,0,1,2,3],
	[5,4,7,6,1,0,3,2],
	[6,7,4,5,2,3,0,1],
	[7,6,5,4,3,2,1,0]
];


//signs
Octonion.octmultsigns = [
	[1, 1, 1, 1, 1, 1, 1, 1],
	[1, -1, 1, -1, 1, -1, -1, 1],
	[1, -1, -1, 1, 1, 1,- 1, -1],
	[1, 1, -1, -1, 1, -1, 1, -1],
	[1, -1, -1, -1, -1, 1, 1, 1],
	[1, 1, -1, 1, -1, -1, -1, 1],
	[1, 1, 1, -1, -1, 1, -1, -1],
	[1, -1, 1, 1, -1, -1, 1, -1]
];
	}

	*add {|a b|

		^(a+b)
	}

	*multiply {|a,b,dsp=false|

	var c = if(dsp,{{DC.ar(0)}!8},{0!8});

	8.do {|i|

		8.do {|j|

			var indextarget = Octonion.octmultindices[i][j];

			c[indextarget] = c[indextarget] + (a[i]*b[j]*Octonion.octmultsigns[i][j]);

		};

	};

	^c
	}


	//doesn't work if zero in sum of squares
	*exp {|a,dsp=false|

		var sqrtsumznsquared;
		var imag;
		var realout;
		var realexp;
		var imagout; //over 7 dimensions of 7 square roots of -1, i,j,k,l,m,n,o

		imag = a.copyRange(1,7);

		sqrtsumznsquared = imag.squared.sum.sqrt;


		//[0,1,2,3,4,5,6,7].copyRange(1,7).squared.sum.sqrt

		realexp = exp(a[0]);
		realout = realexp * cos(sqrtsumznsquared);

				//safety to avoid divide by zero issue
		//if(abs(sqrtsumznsquared)<0.000000001) {^([realout] ++ (0!7))};
		//if(abs(sqrtsumznsquared)<0.000000001) {sqrtsumznsquared = 2pi; }; //sine will be zero

		if(dsp) {

			sqrtsumznsquared= if(abs(sqrtsumznsquared)<0.000000001,DC.ar(2pi),sqrtsumznsquared);

		} {
			if(abs(sqrtsumznsquared)<0.000000001) {^([realout] ++ (0!7))};
		};

		imagout = realexp * (sin(sqrtsumznsquared) / sqrtsumznsquared) * imag;

		^ ([realout] ++ imagout);

	}

	*log {|a,dsp=false|

		var sqrtsumznsquared;
		var imag;
		var realout;
		var imagout; //over 7 dimensions of 7 square roots of -1, i,j,k,l,m,n,o

		imag = a.copyRange(1,7);

		sqrtsumznsquared = imag.squared.sum.sqrt;

		realout = 0.5 * log( a.squared.sum );


		if(dsp) {

			imagout = if(abs(sqrtsumznsquared)<0.000000001,DC.ar(0),(imag / sqrtsumznsquared) * (atan(sqrtsumznsquared/(a[0]))));

		} {
			imagout =  (imag / sqrtsumznsquared) * (atan(sqrtsumznsquared/(a[0])));
		};

		//will cope with a[0] zero in atan calc, no need for atan2 form
		//imagout =  (imag / sqrtsumznsquared) * (atan(sqrtsumznsquared/(a[0])));

		^ ([realout] ++ imagout);
	}


	*pow {|a,b,dsp=false|

		//note that exp ( log(a) * b) may be a different result, not commutative!

		^ Octonion.exp( Octonion.multiply( b,  Octonion.log(a,dsp:dsp)) , dsp:dsp );
	}

}