
+ Eight {


	*initSynthDefs {|encoder,decoder|

		var s = Server.default;

		//test sound
		SynthDef(\eightsound1, {arg out=16, amp=0.1,duration=10,fadein=1,fadeout=1;

			var sound;

			var env = EnvGen.ar(Env([0,1,1,0],[fadein,duration-fadein-fadeout,fadeout]),doneAction:2);

			sound = SinOsc.ar(Rand(100,800));

			//Out.ar(out,Mix(output));
			Out.ar(out,PanAz.ar(8,sound*env*amp,Rand(0,2.0)));
		}).add;

		//using SynthDef.wrap

[
	[\Octonion1,{
	var basefreq = ExpRand(18,108);
	var beat = ExpRand(0.01,8);
	var a = SinOsc.ar(basefreq*(1..8));
	var b = SinOsc.ar((basefreq+beat)*(1..8));

	Octonion.multiply(a,b,dsp:true);
 }],
	[\Octonion2,{
	var a,b,c;

	var basefreq = ExpRand(18,108);
	var beat = ExpRand(0.008,0.08);

	a = LocalIn.ar(8);
				a = (LFNoise1.ar(ExpRand(1/8,8)).range(0,0.999)*a) + SinOsc.ar(basefreq*(1..8));
				b = SinOsc.ar((basefreq+beat)*(1..8));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	c
	}],
	[\Octonion3,{
	var a,b,c;
var basefreq = ExpRand(0.08,0.8);
	var beat = ExpRand(0.008,0.88);

	a = LocalIn.ar(8);
				a = (LFNoise1.ar(basefreq).range(0,8.8)*a) + SinOsc.ar(LFNoise1.ar(basefreq+beat).range(0.1,2)*{Rand(100,1000)}!8);
	b = SinOsc.ar({Rand(100,1000)}!8);
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)

			}],

	[\Octonion4,{
	var a,b,c;
	var basefreq = Rand(280,380);
	var baserate = Rand(0.18,0.8);

	a = LocalIn.ar(8);
	a = (LFNoise1.kr(baserate).range(0,1)*a) + SinOsc.ar(LFNoise1.kr(baserate+Rand(0.008,0.08)).range(0.01,1)* ({basefreq+Rand(-10,10.0)}!8));
	b = SinOsc.ar(({Rand(180,1080)}!8));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)

			}],
			[\Octonion5,{//ominous
	var a,b,c;
	var basefreq = Rand(18,108.8);
	var basefreq2 = Rand(18,118.8);

	a = LocalIn.ar(8);
	a = ((Rand(0.8,9.99)+(LFNoise1.ar(Rand(0.08,0.8)).range(-0.7,0.7)))*a) + SinOsc.ar(LFNoise1.ar(Rand(0.08,0.8)).range(0.1,2) * ({basefreq+Rand(-8.88,8.88)}!8));
	b = SinOsc.ar(({basefreq2+ Rand(-0.8,0.8)}!8));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)

			}],
			[\Octonion6,{//electrical
	var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.081).exprange(0.8,888)*a) + PMOsc.ar(100,23*(1..8),LFNoise1.ar(0.08).range(0,10));
	b = PMOsc.ar(101,27*(1..8),LFNoise1.ar(0.082).range(0,10));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)

			}],
			[\Octonion7,{//high pass

	var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.081).exprange(0.008,0.888)*a) + Blip.ar(23*(1..8),LFNoise1.ar(0.08).range(1,100));
		b = SinOsc.ar({Rand(1005,2117.8)}!8); //SinOsc.ar(Array.rand(8,105,117.8));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)

			}],
			[\Octonion8,{
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + Blip.ar(100*(1..8),LFNoise1.ar(0.08).range(1,10));
	b = SinOsc.ar({Rand(105,217.8)}!8);
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2)
			}],
			[\Octonion9,{//variable length delays
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + Blip.ar(100*(1..8),LFNoise1.ar(0.08).range(1,10));
	b = SinOsc.ar({Rand(88.8,218.8)}!8);
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(1.1,10.1)}!8)));

	Limiter.ar(c*0.2)
			}],
			[\Octonion10,{//rhythmic
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + Blip.ar(100*(1..8),LFNoise1.ar(0.08).range(1,10));
	b = Blip.ar({Rand(1.5,2.178)}!8,LFNoise1.ar(0.088).range(1,100));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(5.1,10.1)}!8)));

	Limiter.ar(c*0.2)
			}],
				[\Octonion11,{//rhythmic, scrabbly
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + SinOsc.ar(100*(1..8)*LFNoise1.ar(0.08).range(1,10));
	b = Blip.ar({Rand(0.15,0.9178)}!8 *(LFNoise1.ar(0.083).range(1,10)),LFNoise1.ar(0.088).range(1,100));
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(5.1,10.1)}!8)));

	Limiter.ar(c*0.2)

			}],
				[\Octonion12,{//non-commutative
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + SinOsc.ar(100*(1..8)*LFNoise1.ar(0.08).range(1,10));
	b = Blip.ar({Rand(0.15,0.9178)}!8 *(LFNoise1.ar(0.083).range(1,10)),LFNoise1.ar(0.088).range(1,100));
	c = Octonion.multiply(b,a,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(5.1,10.1)}!8)));

	Limiter.ar(c*0.2)

			}],
				[\Octonion13,{//non-associative

		var a,b,c,d;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,50)*LFNoise1.ar({Rand(0.3,3.1)}!8)*a) + SinOsc.ar(100*(1..8)*LFNoise1.ar(0.08).range(1,10));
	b = Blip.ar({Rand(0.15,0.9178)}!8 *(LFNoise1.ar(0.083).range(1,10)),LFNoise1.ar(0.088).range(1,100));
	c = Octonion.multiply(b,a,dsp:true);
	c = Octonion.multiply(c,a,dsp:true);
	d = Octonion.multiply(a,a,dsp:true);
	d = Octonion.multiply(b,d,dsp:true);

	c = c+d;

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(5.1,10.1)}!8)));

	Limiter.ar(c*0.2)

			}],
				[\Octonion14,{
		var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(0.08).range(0,10)*a) + SinOsc.ar((LFNoise1.ar({Rand(0.01,0.6)}!8).range(3, {Rand(80.1,160)}!8))*(1..8) );
	b = Blip.ar(LFNoise1.ar({Rand(0.02,0.16)}!8).range(3,16),LFNoise1.ar(0.088).range(1,100));
	c = Octonion.multiply(a,a,dsp:true);
	c = Octonion.multiply(b,c,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,{Rand(5.1,10.1)}!8)));

	Limiter.ar(c*0.2)

			}],
				[\Octonion15,{
	var basefreq = ExpRand(88,128);
	var a = SinOsc.ar(basefreq*(1..8)); //110
	var b = SinOsc.ar(LFNoise1.ar(Rand(0.08,0.8)).range(1,100)*(1..8));
	var c = Octonion.pow(a,b,dsp:true);

				Limiter.ar(Sanitize.ar(c)*0.2);
			}],
				[\Octonion16,{
	var a = SinOsc.ar(LFNoise1.ar(Rand(0.08,0.8)).exprange(0.1,1000)*(1..8)); //110
	var b = SinOsc.ar(LFNoise1.ar(Rand(0.08,0.8)).range(1,100)*(1..8));
	var c = Octonion.pow(a,b,dsp:true);
		Limiter.ar(Sanitize.ar(c)*0.2);

			}],
				[\Octonion17,{
	var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(Rand(0.08,0.8)).range(0.0,0.9)*a) + SinOsc.ar(LFNoise1.ar(Rand(0.08,0.8)).range(0.1,2)* {Rand(100,107.8)}!8  );
	b = SinOsc.ar( {Rand(105,117.8)}!8);
	c = Octonion.multiply(Octonion.log(b,dsp:true),Octonion.log(a,dsp:true),dsp:true);

	c = Sanitize.ar(c);

	LocalOut.ar(Limiter.ar(LeakDC.ar(c)));

	Limiter.ar(c*0.2);
			}],
				[\Octonion18,{

	var a,b,c;

	a = LocalIn.ar(8);
	a = (LFNoise1.ar(LFNoise0.kr({Rand(0.8,8.8)}!8).range(0.08,0.8)).range(0.0,1.99)*a) + SinOsc.ar(LFNoise1.ar(Rand(0.08,8.8)).exprange(0.8,8)* ({Rand(100,1007.8)}!8)  );
	b = SinOsc.ar( {Rand(10.5,117.8)}!8);

	c = Octonion.log(Octonion.add(DC.ar(1)!8,Octonion.multiply(a,b,dsp:true)),dsp:true);

	c = Sanitize.ar(c);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),8.8,{Rand(2.1,8.8)}!8)));

	Limiter.ar(c*0.2)

			}],

			[\Octonion19,{

	var a,b,c;

	a = LocalIn.ar(8);
	a =  (0.001*a) + Saw.ar( {Rand(2.2,40)}!8 ,0.1);
	b = Gendy1.ar(minfreq: ({Rand(20.5,200)}!8),ampscale:{Rand(0.008,0.1)}!8);
	c = Octonion.multiply(a,b,dsp:true);

	LocalOut.ar(Limiter.ar(DelayC.ar(LeakDC.ar(c),10.1,Array.rand(8,3.1,10.1) )));

	Limiter.ar(c*0.5)

			}]

/*[\Octonion20,{

			}],*/




	//[\IncComb,{ |input delaytime=0.05 decayinctime = 3| CombC.ar(input,delaytime,delaytime,XLine.kr(0.3,30,decayinctime)); }]

].do{|data|
	var name = \Eight ++ data[0];

			SynthDef(name, {arg out=16,amp=0.1,duration=10,fadein=1,fadeout=2,envslopein=(-8),envslopeout=(-4);
			//in lieu of audio input

			var input;

				var env = EnvGen.ar(Env([0,1,1,0],[fadein,duration-fadein-fadeout,fadeout],[envslopein,1,envslopeout]),doneAction:2);

			Out.ar(out,SynthDef.wrap(data[1],nil,[])*env*amp);
		}).add;

};



		// this will record to the disk
		SynthDef(\eightdiskout8, {arg bufnum;
			DiskOut.ar(bufnum, In.ar(0,8));
		}).add;

		SynthDef(\eightdiskout2, {arg bufnum;
			DiskOut.ar(bufnum, In.ar(0,2));
		}).add;

		SynthDef(\eightfx1,{|in=16 out=16|
			  	var input, process;
				var good;

			input= In.ar(in,8);

			good = Sanitize.ar(input);

			process = Limiter.ar(LeakDC.ar(FreeVerb.ar(input)));

			ReplaceOut.ar(0,process)
		}).add;


		SynthDef(\eightmaster8,{|in=16 out=0|
			  	var input, process;
				var good;

			input= In.ar(in,8);

			good = Sanitize.ar(input);

			process = Limiter.ar(LeakDC.ar(BLowShelf.ar(good,60,1.0, -40)),0.99,0.01).clip(-1.0,1.0);

			ReplaceOut.ar(0,process)
		}).add;

		SynthDef(\eightmasterSplay,{|in=16 out=0|
			  	var input, process;
				var good;

			input= In.ar(in,8);

			good = Sanitize.ar(input);

			process = Limiter.ar(LeakDC.ar(BLowShelf.ar(good,60,1.0, -40)),0.99,0.01).clip(-1.0,1.0);

			ReplaceOut.ar(0,Splay.ar(process))
		}).add;

		if(encoder.notNil) {

		SynthDef(\eightmasterHRTF,{|in=16 out=0|
			  	var input, process;
				var good;

			input= In.ar(in,8);

			good = Sanitize.ar(input);

			process = Limiter.ar(LeakDC.ar(BLowShelf.ar(good,60,1.0, -40)),0.99,0.01).clip(-1.0,1.0);

			process = Mix.fill(8,{|i|

					var inputnow = process[i];
					var encoded, decoded, push;
		encoded = FoaEncode.ar(inputnow,encoder);


		//push = FoaPush.ar(encoded, 0.5pi, [0,0.5pi,pi,1.5pi].wrapAt(i), [0.25pi,0].at(i.div(4)));

					//observer at centre of cube around (+-1,+-1,+-1)
		push = FoaPush.ar(encoded, 0.5pi, [1.5pi,0.5pi,-0.5pi,-1.5pi].wrapAt(i), [-0.25pi,0.25pi].at(i.div(4)));


	decoded = FoaDecode.ar(push, decoder);

	});

			ReplaceOut.ar(0,process);
		}).add;

		};



	}

}
  		