//8
//octonion dsp piece
//output render to:
//1) 8 channel system
//2) HRTF
//3) Splay to Stereo

//8 minutes long in 8 movements
//8 combinations of [slow/fast, soft/loud, sparse/dense]

Eight {

	var <>basegroup, <>pianogroup, <>synthgroup, <>fxgroup;
	var <>finalsynth;
	var <>s;
	var <>running;
	var recordbuffer, recordsynth;
	//performance computer output parameters
	var duration;
	var <encoder, <decoder;
	var <routine;
	var <outputchannelmode;

	*new {|outputmode=0|
		^super.new.init8(outputmode);
	}

	init8 {|outputmode=0|

		outputchannelmode = outputmode;

		s = Server.default;

		duration = 480; //8 minutes

		running = false;

		s.waitForBoot({

		encoder = FoaEncoderMatrix.newOmni;
		decoder = FoaDecoderKernel.newCIPIC;

			s.sync;

			Eight.initSynthDefs(encoder, decoder);

			s.sync;

			basegroup = Group();
			synthgroup = Group.head(basegroup);

			//for spatial mixdown and limiter etc
			finalsynth = Synth.tail(basegroup,[\eightmaster8,\eightmasterHRTF,\eightmasterSplay].at(outputmode));

			s.sync;


		});

	}

	run {

		//var speeds = ((0!4)++(1!4)).scramble;
		//var dynamics = ((0!4)++(1!4)).scramble;
		//var densities = ((0!4)++(1!4)).scramble;


		//8 combinations of [slow/fast, soft/loud, sparse/dense]
		//always finale with everything at end
		var allocation = ((0..6).collect{|num| num.asBinaryDigits(3)}.scramble) ++ [7.asBinaryDigits(3)];

		var allocation2 = (0..63).scramble.collect({|val| (val%19)+1}).clump(8).collect{|array| array.asSet.asArray};


		if(not(running)) {

			running = true;

			routine = {
				"8 is initialising".postln;

				0.8.wait;

				"8 is active".postln;

				8.do {|movement|

					var speed = allocation[movement][0];
					var dynamic = allocation[movement][1];
					var density = allocation[movement][2];
					var envin;
					var envout;
					var fadein;
					var fadeout;

					envin = [{rrand(-2,10)},{rrand(-25,-5)}].at(speed);
					envout = [{rrand(-25,-1)},{rrand(-5,-1)}].at(speed);
					fadein = [{|duration| min(exprand(0.5,10),duration*0.5)},{exprand(0.01,0.5)}].at(speed);
					fadeout = [{|duration| min(exprand(1,12),duration*0.5)},{|duration| min(exprand(0.01,2),duration*0.5)}].at(speed);


						("Movement"+(movement+1)).postln;

						//density number of parallel layers
						//speed rate of individual segments in a layer, swap more quickly if fast
						//dynamic general amplitude range

					[rrand(2,3), rrand(4,9)].at(density).do{|layer|

							{
							var timelocation = 0;
							var ioinow, initialsilence, durationnow;

							while({timelocation < 58.0},{

							ioinow = [rrand(5,25),rrand(1,8)].at(speed);
							initialsilence = [0,rrand(0,1)].choose;
							durationnow = ioinow - initialsilence;

								if((timelocation + ioinow)>60) {

									initialsilence = 0; ioinow = (60-timelocation);
									durationnow = ioinow;

								};

								initialsilence.wait;

								//test sound
								//Synth.head(synthgroup,\eightsound1,[\out,16, \duration,durationnow, \amp, [exprand(0.001,0.1),exprand(0.1,0.5)].at(dynamic)]);

									Synth.head(synthgroup,\EightOctonion++(allocation2[movement].choose),[\out,16, \duration,durationnow, \amp, [exprand(0.01,0.1),exprand(0.1,0.5)].at(dynamic),\fadein,fadein.value(durationnow),\fadeout,fadeout.value(durationnow),\envslopein,envin.value,\envslopeout,envout.value]);



								durationnow.wait;

								timelocation = timelocation + ioinow;
							}
							);

							}.fork(SystemClock);

						};

					60.wait;
				};

				"8 is Finished!".postln;

				running = false;
			}.fork(SystemClock);

		}

	}






	stop {

		routine.stop;

		running = false;

		basegroup.free;

	}







	record {

		{

			recordbuffer = Buffer.alloc(s, 65536,if(outputchannelmode==0,8,2));

			s.sync;

			recordbuffer.write("~/Music/SuperCollider Recordings/8.wav".standardizePath, "wav", "int24", 0, 0, true);

			s.sync;
			// create the diskout node; making sure it comes after the source
			recordsynth = Synth.tail(RootNode(s), [\eightdiskout8,\eightdiskout2].at(if(outputchannelmode==0,0,1)), [\bufnum, recordbuffer]);

		}.fork;

	}

	stopRecord {

		if(recordsynth.notNil) {

			recordsynth.free;

			{

				recordbuffer.close;

				s.sync;

				recordbuffer.free;

				recordsynth = nil;

			}.fork;

		};



	}



	*database {

		^ (TheWeightofHistory.filenameSymbol.asString.dirname++ "/database.scd").load;

	}


}



