<?php
error_reporting(E_ALL | E_STRICT);
ini_set("soap.wsdl_cache", 0);

/**
 * set the following paths to whatever your environment looks like
 * you may have to change the endpoint in the wsdl-file as well!
 */
$wsdl = 'http://127.0.0.1/www/scratchbook/test43338.wsdl';
$soapEndpoint = 'http://127.0.0.1:81/www/scratchbook/soap.php?accessserver';


if (isset ($_GET['accessserver'])) {

	/**
	 * SoapHandler
	 */
	class SoapHandler {
		function getSomething($arguments) {
			die(print_r($arguments, true) . "\n" . phpversion());
		}
	}

	/**
	 * SoapServer
	 */

	$server = new SoapServer($wsdl, array (
		'features' => SOAP_USE_XSI_ARRAY_TYPE + SOAP_SINGLE_ELEMENT_ARRAYS
	));
	$server->setClass('SoapHandler');
	$server->handle();

} else {

	require ('xmlFormatter.php');
	header('Content-Type: text/plain');
	echo phpversion(), "\n";


	echo "STARTING TEST WITHOUT XSI-ARRAY\n";
	$client = new SoapClient($wsdl, array (
		'location' => $soapEndpoint,
		'trace' => 1
	));
	try {
		var_dump($client->getSomething(array (
			'in' => array (
				'string1',
				'string2'
			),
			'in2' => 'string3'
		)));
	} catch (SoapFault $sf) {
		if ($sf->getMessage() != 'looks like we got no XML document')
			print_r($sf);
	}
	echo "\n\nINPUT WITHOUT XSI-ARRAY\n=======================\n";
	echo formatXmlString($client->__getLastRequest());
	echo "\n\nOUTPUT\n======\n";
	echo formatXmlString($client->__getLastResponse());
	$output_without_xsiarray = $client->__getLastResponse();



	echo "\n\n\n\n\nSTARTING TEST WITH XSI-ARRAY\n";
	$client = new SoapClient(null, array (
		'location' => $soapEndpoint,
		'uri' => 'http://castex.de/test43338/',
		'trace' => 1
	));

	try {
		var_dump($client->__call('getSomething', array (
			new SoapParam(array ('string1',	'string2'), 'in'),
			new SoapParam('string3', 'in2'))
		));
	} catch (SoapFault $sf) {
		if ($sf->getMessage() != 'looks like we got no XML document')
			print_r($sf);
	}
	echo "\n\nINPUT WITH XSI-ARRAY\n====================\n";
	echo formatXmlString($client->__getLastRequest());
	echo "\n\nOUTPUT\n======\n";
	echo formatXmlString($client->__getLastResponse());
	$output_with_xsiarray = $client->__getLastResponse();

	if ($output_with_xsiarray == $output_without_xsiarray)
		echo "WOOHOO, it works now";
	else
		echo "still not working :-(";

}