/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef XERCESWRITER
#define XERCESWRITER

//#include <sax2/DefaultHandler.hpp>
#include <sax2/Attributes.hpp>
#include <framework/LocalFileInputSource.hpp>
#include <framework/XMLFormatter.hpp>
#include <framework/StdOutFormatTarget.hpp>
#include <httpd.h>

  class XercesWriter {
    BasicWriter& w ;
    XMLFormatter formatter ;
  public:
    XercesWriter(BasicWriter& w_in, XMLFormatTarget* target) :
	w(w_in), formatter("utf-8", target) {
    }
    //virtual ~Writer() { }
  /* the basics - need implementations */
    XercesWriter& write(const char* buf, int len) {
	w.write(buf, len) ;
	return *this ;
    }
    //Writer& write(const char* buf, int len) { w.write(buf, len) ; return *this ; }
    XercesWriter& puts(const char* buf) { w.puts(buf) ; return *this ; }
    XercesWriter& putC(const char c) { w.putC(c) ; return *this ; }
    XercesWriter& puti(const int i) { w.puti(i) ; return *this ; }
    XercesWriter& escape(const char* s) { w.escape(s) ; return *this ; }
    XercesWriter& putstr(const char* s) { w.putstr(s) ; return *this ; }
    XercesWriter& escape(const XMLCh* buf, const unsigned int length) {
      formatter.formatBuf(buf, length) ;
      return *this ;
    }
    XercesWriter& escape(const XMLCh* buf) { formatter << buf ; return *this ; }
    XercesWriter& puts(const XMLCh* buf) { formatter << buf ; return *this ; }


    /*
    virtual void startdoc() {
	puts("<val:validation val:lib=\"mod_validator/Xerces\" xmlns:val=\"validator:val\" xmlns:ml=\"validator:ml\" xmlns:sax=\"validator:sax\">\n") ;
    }
    */
  } ;

#endif
