/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef XERCESVALIDATOR
#define XERCESVALIDATOR

XERCES_CPP_NAMESPACE_USE

#include "XercesWriter.h"
//#include "XercesErrorHandler.h"
#include "XercesHandlers.h"
#include "XercesEntityResolver.h"
//#include "XercesContentHandler.h"
//#include "XercesDTDHandler.h"
//#include "XercesDeclHandler.h"
//#include "XercesLexicalHandler.h"
#include "ApacheFormatTarget.h"
#include "ApacheValidator.h"
#include <sax2/SAX2XMLReader.hpp>
#include <sax2/XMLReaderFactory.hpp>

class XercesValidator : public ApacheValidator {
  virtual const char* const parserName() const { return "XercesC/2.2" ; }
  request_rec* r ;
  BasicWriter& out ;
  int resultsMode ;
  apr_table_t* features ;
  const bool getFeature(const char* const name) const {
#if 0
    const char* key = strstr(r->args, name) ;
    if ( ! key )
      return false ;				// no match
    if ( ( key != r->args ) && ( key[-1] != '&' ) )
      return getFeature(key+1) ;		// false match
    switch ( key[strlen(name)] ) {
      case 0: return false ;			// malformed
      case '=':	
	switch ( key[strlen(name)+1] ) {
	  case 0: return false ;		// empty val
	  case '&': return false ;		// empty val
	  default: return true ;		// has a value
	}
      default: return getFeature(key+1) ;	// false match
    }
#else
    if ( features ) {
      const char* f = apr_table_get(features, name) ;
      return ( f && *f ) ? true : false ;
    } else
	return ::getFeature(r->args, name) ;
#endif
  }
public:
  virtual void validate(char* filename) {
    SAX2XMLReader* parser = XMLReaderFactory::createXMLReader();
// Validate auto
    parser->setFeature(XMLUni::fgXercesContinueAfterFatalError, true);

    out.puts("<val:parseOpts force=\"") ;
    if ( getFeature("Force") ) {
      parser->setFeature(XMLUni::fgSAX2CoreValidation, true);
      parser->setFeature(XMLUni::fgXercesDynamic, false);
      out.puts("YES") ;
    } else {
      parser->setFeature(XMLUni::fgXercesDynamic, true);
      out.puts("NO") ;
    }

    out.puts("\" schema=\"") ;

    if ( getFeature("Schema") ) {
      parser->setFeature(XMLUni::fgXercesSchema, true);
      parser->setFeature(XMLUni::fgXercesSchemaFullChecking, true);
      out.puts("YES") ;
    } else {
      out.puts("NO") ;
    }

    out.puts("\" namespace=\"") ;

    if ( getFeature("Namespace") ) {
      parser->setFeature(XMLUni::fgSAX2CoreNameSpaces, true);
      parser->setFeature(XMLUni::fgSAX2CoreNameSpacePrefixes, true);
      out.puts("YES") ;
    } else {
      out.puts("NO") ;
    }
    out.puts("\"/>") ;

    //unsigned int nErrors = 0 ;
    try {
      ApacheFormatTarget target(r) ;
      XercesWriter writer(out, &target) ;

      XercesEntityResolver entityResolver(r) ;
      parser->setEntityResolver(&entityResolver) ;
#ifdef SEPARATE_CLASSES
      XercesContentHandler contentHandler( writer) ;
      if ( resultsMode & RESULTS_NORM )
	parser->setContentHandler(&contentHandler) ;

      XercesErrorHandler errorHandler(writer, resultsMode & RESULTS_ERRORS ) ;
      parser->setErrorHandler(&errorHandler) ;

      //XercesDTDHandler DTDHandler(writer) ;
      //parser->setDTDHandler(&DTDHandler) ;

      XercesLexicalHandler LexicalHandler(writer) ;
      parser->setLexicalHandler(&LexicalHandler) ;

      //XercesDeclHandler DeclHandler(writer) ;
      //parser->setDeclarationHandler(&DeclHandler) ;
#else
      XercesHandlers handlers(writer, (resultsMode & RESULTS_ERRORS) ) ;
      parser->setErrorHandler(&handlers) ;
      parser->setLexicalHandler(&handlers) ;
      if ( resultsMode & RESULTS_NORM )
	parser->setContentHandler(&handlers) ;

#endif

      parser->parse(filename) ;
      //nErrors = parser->getErrorCount() ;
      handlers.report() ;
    } catch ( const XMLException& toCatch) {
	out.puts("<val:message>Something bad happened</val:message>") ;
    }
    delete parser ;
  }
  virtual ~XercesValidator() {}
  XercesValidator(request_rec* rec, BasicWriter& o, int mode, apr_table_t* opts)
	: r(rec), out(o), resultsMode(mode), features(opts) {}

} ;
#endif
