/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef XERCESHANDLERS
#define XERCESHANDLERS

//XERCES_CPP_NAMESPACE_USE
#include "XercesWriter.h"
#include <sax2/ContentHandler.hpp>
#include <sax2/LexicalHandler.hpp>
#include <sax/ErrorHandler.hpp>
#include <sax/SAXParseException.hpp>

class XercesHandlers : public ContentHandler , public ErrorHandler, public LexicalHandler   {
public:
  XercesHandlers( XercesWriter& w, const bool yn)
	: out(w), depth(0), status(V_OK), suppress(!yn), errorcount(0) {
  }
  virtual ~XercesHandlers() {
  }
private:

  XercesWriter& out ;

#ifdef ELEMENTSTACK
  class ElementStack {
    const char* element ;
    class ElementStack* parent ;
  public:
    ElementStack(const XMLCh* elt =0, ElementStack* stack =0)
	: element(XMLString::transcode(elt)) , parent(stack) {}
    ~ElementStack() {}
    ElementStack* push(const XMLCh* elt) {
      return new ElementStack(elt, this) ;
    }
    ElementStack* pop() {
      ElementStack* tmp = parent ;
      delete element ;
      delete this ;
      return tmp ;
    }
    const char* peek() const {
      return element ;
    }
  } ;
  ElementStack* stack ;
#else
  unsigned int depth ;
#endif
public:
  virtual void endElement(const XMLCh* const uri, const XMLCh* const name,
	const XMLCh* const qname) {
#ifdef ELEMENTSTACK
    const char* qn = XMLString::transcode(qname) ;
    while ( ! XMLString::equals(stack->peek() , qn) ) {
	out.puts("</ml:element><!-- POP ").puts(stack->peek()).puts(" -->\n") ;
	stack = stack->pop() ;
    }
    delete qn ;
    out.puts("</ml:element><!-- ").puts(qname).puts(" -->\n") ;
    stack = stack->pop() ;
#else
    out.puts("</ml:element>") ;
    --depth ;
#endif
  }
  virtual void startElement(const XMLCh* const uri,
	const XMLCh* const localname, const XMLCh* const qname,
	const Attributes& attrs) {
	  /*
    out.puts("<ml:element uri=\"").puts(uri)
	.puts("\" localname=\"").puts(localname)
	.puts("\" qname=\"").puts(qname).puts("\">\n") ;
	*/
    out.puts("<ml:element type=\"unknown\" name=\"").puts(qname).puts("\">") ;
	
    for (size_t n=0; n < attrs.getLength(); ++n) {
      out.puts("\t<ml:attribute name=\"").puts(attrs.getLocalName(n))
	.puts("\" type=\"").puts(attrs.getType(n)).puts("\">")
	.escape(attrs.getValue(n)).puts("</ml:attribute>\n") ;
    }
#ifdef ELEMENTSTACK
    stack = stack->push(qname) ;
#else
    ++depth ;
#endif
  }

  virtual void characters(const XMLCh* chars, const unsigned int length) {
    out.escape(chars, length) ;
  }
  virtual void ignorableWhitespace(const XMLCh* const chars, const unsigned int length) {
  }
  virtual void endDocument() {
#ifdef ELEMENTSTACK
#else
    while ( depth-- ) { out.puts("</ml:element>") ; }
#endif
//    out.puts("</ml:document>\n") ;
  }
  virtual void processingInstruction(const XMLCh* const target,
	const XMLCh* const data) {
    //out.puts("<ml:pi target=\"").puts(target).puts("\">")
//	.escape(data).puts("</ml:pi>\n") ;
  }
  virtual void startDocument() {
//    out.puts("<ml:document>\n") ;
  }
  virtual void setDocumentLocator(const Locator* const locator) {
  }
  virtual void startPrefixMapping(const XMLCh* const prefix,
	const XMLCh* const uri) {
  }
  virtual void endPrefixMapping(const XMLCh* const prefix) {
  }
  virtual void skippedEntity(const XMLCh* const name) {
  }

#if 0
class XercesDTDHandler : public DTDHandler {
private:

  XercesWriter& out ;

public:
  XercesDTDHandler( XercesWriter& w)
	: out(w) {
  }
  virtual ~XercesDTDHandler() {
  }
  virtual void notationDecl (const XMLCh *const name,
	const XMLCh *const publicId, const XMLCh *const systemId) {
  }
  virtual void unparsedEntityDecl (const XMLCh *const name,
	const XMLCh *const publicId, const XMLCh *const systemId,
	const XMLCh *const notationName) {
  }
  virtual void resetDocType () {
  }
} ;
#endif
#if 0
class XercesDeclHandler : public DeclHandler {
private:

  XercesWriter& out ;

public:
  XercesDeclHandler( XercesWriter& w)
	: out(w) {
  }
  virtual ~XercesDeclHandler() {
  }
  virtual void elementDecl (const XMLCh *const name,
	const XMLCh *const model) {
  }
  virtual void attributeDecl (const XMLCh *const eName,
	const XMLCh *const aName, const XMLCh *const type,
	const XMLCh *const mode, const XMLCh *const value) {
  }
  virtual void internalEntityDecl (const XMLCh *const name,
	const XMLCh *const value) {
  }
  virtual void externalEntityDecl (const XMLCh *const name,
	const XMLCh *const publicId, const XMLCh *const systemId) {
  }
} ;
#endif

private:
  typedef enum { V_OK=0, V_WARNING=1, V_ERROR=2, V_FATAL=3 } ValStatus ;

  ValStatus status ;
  const bool suppress ;
  size_t errorcount ;

  void setstatus(const ValStatus stat) {
    if ( status < stat )
	status = stat ;
  }
  void message(const char* severity, const SAXParseException& ex) {
    if ( suppress )
	return ;
//    char* sysid = XMLString::transcode(ex.getSystemId()) ;
//    char* msg = XMLString::transcode(ex.getMessage()) ;
    out.puts("<sax:message severity=\"").puts(severity)
	.puts("\" file=\"").puts(ex.getSystemId()).puts("\" line=\"")
	.puti(ex.getLineNumber()).puts("\" char=\"")
	.puti(ex.getColumnNumber()).puts("\">")
	.escape(ex.getMessage()).puts("</sax:message>\n") ;
//    delete msg ;
//    delete sysid ;
  }
public:
  virtual void error(const SAXParseException& exception) {
    ++errorcount ;
    setstatus(V_ERROR) ;
    message("error", exception) ;
  }
  virtual void warning(const SAXParseException& exception) {
    setstatus(V_WARNING) ;
    message("warning", exception) ;
  }
  virtual void fatalError(const SAXParseException& exception) {
    ++errorcount ;
    setstatus(V_FATAL) ;
    message("fatal", exception) ;
  }
  virtual void resetErrors() {
     status = V_OK ;
     errorcount = 0 ;
  }
  void report() {
     out.puts("<val:result errors=\"").puti(errorcount).puts("\" message=\"") ;
     switch ( status ) {
	case V_OK: out.puts("Well-formed and valid") ; break ;
	case V_WARNING: out.puts("Valid with warnings") ; break ;
	case V_ERROR: out.puts("Well-formed but not valid") ; break ;
	case V_FATAL: out.puts("Not well-formed") ; break ;
	default: out.puts("BUG!") ; break ;
     }
     out.puts("\">") ;
     switch ( status ) {
	case V_OK: case V_WARNING: out.puts("pass") ; break ;
	case V_ERROR: case V_FATAL: out.puts("fail") ; break ;
	default: out.puts("BUG!") ; break ;
     }
     out.puts("</val:result>") ;
     resetErrors() ;
  }

  virtual void startDTD(const XMLCh* const name,
	const XMLCh* const publicId, const XMLCh* const systemId) {
    out.puts("<ml:dtd doctype=\"").puts(name) ;
    if ( publicId )
	  out.puts("\" publicId=\"").escape(publicId) ;
    if ( systemId )
	  out.puts("\" systemId=\"").escape(systemId) ;
    out.puts("\">\n") ;
  }
  virtual void endDTD() {
	resetErrors() ;
	out.puts("</ml:dtd>\n") ;
  }
  virtual void endCDATA() {
	out.puts("</ml:cdata>\n") ;
  }
  virtual void startCDATA() {
	out.puts("<ml:cdata>") ;
  }
  virtual void startEntity(const XMLCh* const name) {
  }
  virtual void endEntity(const XMLCh* const name) {
  }
  virtual void comment(const XMLCh *const chars, const unsigned int length) {
  }
} ;

#endif
