/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef XERCESENTITYRESOLVER
#define XERCESENTITYRESOLVER

#include <httpd.h>

#include "XercesWriter.h"
#include <framework/URLInputSource.hpp>
#include <framework/LocalFileInputSource.hpp>
#include <sax/EntityResolver.hpp>

class XercesEntityResolver : public EntityResolver {
private:

  request_rec* r ;	/* for entityresolver */

public:
  XercesEntityResolver( request_rec* rec)
	:  r(rec) {
  }
  virtual ~XercesEntityResolver() {
  }
  InputSource* resolveEntity(const XMLCh* publicId, const XMLCh* systemId) {

    static const XMLCh* const http = XMLString::transcode("http://") ;
    static const XMLCh* const ftp = XMLString::transcode("ftp://") ;

#if 0
    const char* filename = get_pubid(XMLString::transcode(publicId), false) ;
    if ( filename ) {
      struct stat st ;
      InputSource* ret = 0 ;
      if ( stat(filename, &st) == 0 )
	if ( S_ISREG(st.st_mode) && (st.st_size > 0) ) {
	  XMLCh* fname = XMLString::transcode(filename) ;
	  ret = new LocalFileInputSource(fname) ;
	  //delete [] fname ;
	}
      //delete [] filename ;
      if ( ret )
	return ret ;
    }
#endif
    InputSource* ret = 0 ;
    char* id = XMLString::transcode(publicId) ;
    const char* filename = get_pubid(id, true) ;
    if ( filename ) {
      struct stat st ;
      if ( stat(filename, &st) == 0 )
	if ( S_ISREG(st.st_mode) && (st.st_size > 0) ) {
	  XMLCh* fname = XMLString::transcode(filename) ;
	  ret = new LocalFileInputSource(fname) ;
	  delete fname ;
	}
    }
    delete id ;
    if ( ret )
	return ret ;

/* Security: don't retrieve local files from systemId */
    if ( ! XMLString::startsWithI(systemId, http) &&
	 ! XMLString::startsWithI(systemId, ftp) )
      return 0 ; //EntityResolver::resolveEntity(publicId, NULL) ;

/*else fetch over the 'net */
    else
      return new URLInputSource(systemId) ;
  }
private:

  const char* get_pubid(const char* id, bool withpath) const {
    validator_conf* cfg = (validator_conf*)
	ap_get_module_config(r->per_dir_config, &validator_module) ;
#if 0
    for ( pubid* entry = cfg->cache; entry; entry = entry->next )
      if ( !strcmp(id, entry->id) )
	if ( withpath )
	  return apr_pstrcat(r->pool, cfg->mlbase, "/", entry->filename, NULL) ;
	else
	  return entry->filename ;
#else
    char* filename = (char*) apr_hash_get(cfg->cache, id, APR_HASH_KEY_STRING) ;
    if ( filename )
      if ( withpath )
	return apr_pstrcat(r->pool, cfg->mlbase, "/", filename, NULL) ;
      else
	return filename ;
#endif
    return 0 ;
  }
} ;

#endif
