/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef VALIDATORAPP
#define VALIDATORAPP

#include <OpenSP/SGMLApplication.h>

#if 0
#define RESULTS_ERRORS 0x1
#define RESULTS_SOURCE 0x2
#define RESULTS_NORM 0x4
#define CTYPE_HTML	0x8
#define CTYPE_RDF	0x10
#endif

#include "BasicWriter.h"

class ValidatorApp : public SGMLApplication {
public:
  class Writer {
    BasicWriter& w ;
  public:
  /* the basics - need implementations */
    Writer& write(const char* buf, int len) { w.write(buf, len) ; return *this; }
    Writer& puts(const char* buf) { w.puts(buf) ; return *this; }
    Writer& putC(const char c) { w.putC(c) ; return *this; }
    Writer& puti(const int i) { w.puti(i) ; return *this; }
    Writer& escape(const char* s) { w.escape(s) ; return *this; }
    Writer& putstr(const char* s) { w.putstr(s) ; return *this ; }

    Writer(BasicWriter& x) : w(x) {
    }
    virtual ~Writer() {
    }
    Writer& writestr(const char* buf, int len) {
      for (int i = 0; i<len; ++i )
	putC(buf[i]) ;
      return *this ;
    }
  /* others we need - these use the basics */
    Writer& put(SGMLApplication::CharString s) {
      for (unsigned int n = 0; n < s.len; ++n) {
	unsigned int l = s.ptr[n] ;
	if ( l & 0xffffff80 )
	  puts("&#").puti(l).putC(';') ;
	else
	  putC(char(l)) ;
      }
      return *this ;
    }
    Writer& escape(SGMLApplication::CharString s) {
      for (size_t n = 0; n < s.len; ++n) {
	if ( s.ptr[n] >= 160 )
	  puts("&#").puti(s.ptr[n]).putC(';') ;
	else if ( s.ptr[n] >= 128 )
	  puts("<ml:badchar num=\"").puti(s.ptr[n]).puts("\"/>") ;
	else switch ( char(s.ptr[n]) ) {
	  case '>': write("&gt;", 4) ; break ;
	  case '<': write("&lt;", 4) ; break ;
	  case '&': write("&amp;", 5) ; break ;
	  case '"': write("&quot;", 6) ; break ;
	  default: putC(char(s.ptr[n])) ; break ;
	}
      }
      return *this ;
    }
    Writer& put(SGMLApplication::Attribute attr) {
      if ( attr.type == SGMLApplication::Attribute::implied )
	return *this ;
      puts("\t<ml:attribute name=\"").put(attr.name)
	  .puts("\" type=\"").puts(attrtype(attr.type)).puts("\">") ;
      if ( attr.type == SGMLApplication::Attribute::cdata )
	for (size_t n=0; n<attr.nCdataChunks; ++n)
	  escape(attr.cdataChunks[n].data) ;
      else if ( attr.type == SGMLApplication::Attribute::tokenized )
	put(attr.tokens) ;
      puts("</ml:attribute>\n") ;
      return *this ;
    }
  private:
    const char* attrtype(SGMLApplication::Attribute::Type type) const {
      switch (type) {
	case SGMLApplication::Attribute::invalid:   return "invalid" ;
	case SGMLApplication::Attribute::implied:   return "implied" ;
	case SGMLApplication::Attribute::cdata:     return "cdata" ;
	case SGMLApplication::Attribute::tokenized: return "tokenized" ;
      }
      return "bug" ;
    }
  } ;
private:
  Writer& out ;
  int resultsMode ;
  const char* contentType(StartElementEvent::ContentType type) const {
    switch(type) {
      case StartElementEvent::empty: return "empty" ;
      case StartElementEvent::cdata: return "cdata" ;
      case StartElementEvent::rcdata: return "rcdata" ;
      case StartElementEvent::mixed: return "mixed" ;
      case StartElementEvent::element: return "element" ;
    }
    return "bug" ;
  }
public:
  ValidatorApp(Writer& w, int mode) : out(w), resultsMode(mode) {
  }
  virtual ~ValidatorApp() {
  }
  virtual void startDtd(const StartDtdEvent& event) {
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.puts("<ml:dtd doctype=\"").put(event.name) ;
    if ( event.haveExternalId ) {
      if ( event.externalId.havePublicId )
	out.puts("\" publicId=\"").put(event.externalId.publicId) ;
      if ( event.externalId.haveSystemId )
	out.puts("\" systemId=\"").put(event.externalId.systemId) ;
    }
    out.puts("\"/>\n") ;
  }
  virtual void startElement(const StartElementEvent &event) {
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.puts("<ml:element name=\"").put(event.gi)
	.puts("\" type=\"").puts(contentType(event.contentType))
	.puts("\">\n")
    ;
    for (size_t n = 0; n < event.nAttributes; ++n) {
      out.put(event.attributes[n]) ;
    }
  }
  virtual void endElement(const EndElementEvent &event) {
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.puts("</ml:element>\n") ;
  }
  virtual void data(const DataEvent &event) {
//    out.puts("<ml:data>").escape(event.data).puts("</ml:data>\n") ;
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.escape(event.data) ;
  }
/*
  virtual void pi(const PiEvent &event) {
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.puts("<ml:pi>").put(event.data).puts("</ml:pi>\n") ;
  }
*/
  virtual void commentDecl(const CommentDeclEvent& event) {
    if ( ! ( resultsMode & RESULTS_NORM ) )
	return ;
    out.puts("<ml:commentDecl comments=\"").puti(event.nComments).puts("\">\n") ;
    for (size_t i = 0; i<event.nComments; ++i) {
      if ( event.comments[i].len > 0 )
	out.puts("\t<ml:comment>").escape(event.comments[i]).puts("</ml:comment>\n") ;
      if (  ( i +1 < event.nComments ) )
	out.puts("<ml:sep/>") ;
    }
    out.puts("</ml:commentDecl>\n") ;
  }
  virtual void error(const ErrorEvent &event) {
    if ( resultsMode & RESULTS_ERRORS )
      out.put(event.message) ;
  }
} ;
#endif
