/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef OPENSPVALIDATOR
#define OPENSPVALIDATOR

//#include <unistd.h>
#include <OpenSP/config.h>
#include <OpenSP/Boolean.h>

#include <OpenSP/ParserEventGeneratorKit.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "ValidatorApp.h"
#include <http_protocol.h>
#include <apr_strings.h>
#include <ctype.h>

#include <libxml/nanohttp.h>

#include "ApacheValidator.h"

class OpenSPValidator : public ApacheValidator {
  request_rec* r ;
  ValidatorApp::Writer out ;
  int resultsMode ;
  const char* parseMode ;
  const char* const parserName() const { return "OpenSP/1.5v" ; }
public:
  OpenSPValidator(request_rec* rec, BasicWriter& o, int mode,
	parsetype pmode, apr_table_t* params)
	: r(rec), out(o), resultsMode(mode) {
    switch ( pmode ) {
      case XML:
	parseMode = "xml" ;
	break ;
      case XHTML:
	parseMode = "xhtml" ;
	break ;
      default:
	parseMode = params
		? apr_table_get(params, "parseMode")
		: getArg(r->pool, r->args, "parseMode") ;
	break ;
    }
  }
  virtual ~OpenSPValidator() {}

  virtual void validate(char* filename) {
    validator_conf* cfg = (validator_conf*)
	ap_get_module_config(r->per_dir_config, &validator_module) ;
    putenv("SP_MESSAGE_FORMAT=XML") ;
    putenv(apr_pstrcat(r->pool, "SGML_SEARCH_PATH=/tmp:", cfg->mlbase, NULL)) ;
    ParserEventGeneratorKit parserKit ;
    parserKit.setOption(ParserEventGeneratorKit::outputCommentDecls) ;
    parserKit.setOption(ParserEventGeneratorKit::restrictFileReading) ;

    if ( !strcmp(parseMode, "web") ) {
      setenv("SGML_CATALOG_FILES", cfg->htmlCatalogue, 1) ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "min-tag") ;
    } else if ( !strcmp(parseMode, "fussy") ) {
      setenv("SGML_CATALOG_FILES", cfg->htmlCatalogue, 1) ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "min-tag") ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "amply-tagged") ;
    } else if ( !strcmp(parseMode, "sgml") ) {
      setenv("SGML_CATALOG_FILES", cfg->htmlCatalogue, 1) ;
    } else if ( !strcmp(parseMode, "xhtml") ) {
      setenv("SGML_CATALOG_FILES", cfg->xmlCatalogue, 1) ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "xml") ;
    } else if ( !strcmp(parseMode, "xml") ) {
      setenv("SGML_CATALOG_FILES", cfg->xmlCatalogue, 1) ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "xml") ;
    } else {
      setenv("SGML_CATALOG_FILES", cfg->htmlCatalogue, 1) ;
      parserKit.setOption(ParserEventGeneratorKit::enableWarning, "min-tag") ;
    }
    putenv("SP_ENCODING=utf-8") ;		// if we're transcoding input
    ValidatorApp app(out, resultsMode) ;

    EventGenerator *egp =
	parserKit.makeEventGenerator(1, &filename);
    egp->inhibitMessages(true) ;

    unsigned int nErrors = egp->run(app);
    delete egp;

    out.puts("<val:result errors=\"").puti(nErrors).puts("\">")
	.puts((nErrors>0)?"fail":"pass").puts("</val:result>")
	.puts("<val:parseMode>").putstr(parseMode).puts("</val:parseMode>\n")
    ;
  }
} ;
#endif
