/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef BASICWRITER
#define BASICWRITER

class BasicWriter {
public:
  BasicWriter() {} //: transbuf(0), transcoder(0) {}
  virtual ~BasicWriter() {
  }
  const BasicWriter& escape(const char* s) const {
    if ( s ) for (const char* p=s; *p; ++p)
      switch (*p) {
	case '>': write("&gt;",4) ; break ;
	case '<': write("&lt;",4) ; break ;
	case '&': write("&amp;",5) ; break ;
	case '"': write("&quot;",6) ; break ;
	default: putC(*p) ; break ;
      }
    return *this ;
  }
  const BasicWriter& putstr(const char* s) const {
    if ( s )
      while (*s)
	putC(*s++) ;
    return *this ;
  }
  const BasicWriter& startdoc() const {
    return puts("<val:validation xmlns:val=\"validator:val\" xmlns:ml=\"validator:ml\" xmlns:sp=\"validator:sp\" xmlns:sax=\"validator:sax\">") ;
  }

  virtual const BasicWriter& write(const char* buf, int len) const = 0 ;
  virtual const BasicWriter& puts(const char* buf) const = 0 ;
  virtual const BasicWriter& putC(const char c) const = 0 ;
  virtual const BasicWriter& putchar(const char c) const = 0 ;
  virtual const BasicWriter& puti(const int i) const = 0 ;
} ;
#endif
