/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef APACHEWRITER
#define APACHEWRITER

#include <http_protocol.h>
#include "BasicWriter.h"

class ApacheWriter : public BasicWriter {
private:
  request_rec* r ;
public:
  ApacheWriter(request_rec* o) : r(o) {}
  const BasicWriter& puts(const char* s) const {
    ap_rputs(s, r) ;
    return *this ;
  }
  const BasicWriter& write(const char* s, int len) const {
    ap_rwrite(s, len, r) ;
    return *this ;
  }
  const BasicWriter& putchar(const char c) const {
    ap_rputc(c, r) ;
    return *this ;
  }
  const BasicWriter& putC(const char c) const {
    unsigned char u = c ;
    if ( c & 0x80 )
      if ( u < 160 )
	ap_rprintf(r, "<ml:badchar num=\"%d\"/>", (int)u) ;
      else
	ap_rprintf(r, "&#%d;", int(u)) ;
    else
      ap_rputc(c, r) ;
    return *this ;
  }
  const BasicWriter& puti(const int i) const {
    ap_rprintf(r, "%d", i) ;
    return *this ;
  }
} ;
#endif
