/*
	Copyright (c) 2003, WebThing Ltd
	Author: Nick Kew <nick@webthing.com>
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/
#ifndef APACHEFORMATTARGET
#define APACHEFORMATTARGET


#include <http_protocol.h>
#include <framework/StdOutFormatTarget.hpp>
#include <framework/XMLFormatter.hpp>

class ApacheFormatTarget : public XMLFormatTarget {
  request_rec* r ;
public:
  ApacheFormatTarget(request_rec* rec) : r(rec) {}
  ~ApacheFormatTarget() {}
  void flush() {}
  void writeChars(const XMLByte* const toWrite , const unsigned int count,
	XMLFormatter* const formatter) {
    ap_rwrite((char*) toWrite, count, r) ;
  }
} ;

#endif
